/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractLegalSideContractPersonBO;
import com.tydic.contract.atom.ContractGetLegalSideContractPersonAtomService;
import com.tydic.contract.atom.bo.ContractGetLegalSideContractPersonAtomReqBO;
import com.tydic.contract.atom.bo.ContractGetLegalSideContractPersonAtomRspBO;
import com.tydic.contract.atom.bo.ContractLegalSidePersonBO;
import com.tydic.contract.busi.ContractGetLegalSideContractPersonBusiService;
import com.tydic.contract.busi.bo.ContractGetLegalSideContractPersonBusiReqBO;
import com.tydic.contract.busi.bo.ContractGetLegalSideContractPersonBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcLegalConversionBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractGetLegalSideContractPersonBusiServiceImpl
implements ContractGetLegalSideContractPersonBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractGetLegalSideContractPersonBusiServiceImpl.class);
    @Autowired
    private ContractGetLegalSideContractPersonAtomService contractGetLegalSideContractPersonAtomService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService dycUmcEnterpriseOrgQryDetailService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @Override
    public ContractGetLegalSideContractPersonBusiRspBO deductLegalSidePerson(ContractGetLegalSideContractPersonBusiReqBO reqBO) {
        ContractGetLegalSideContractPersonBusiRspBO rspBO = new ContractGetLegalSideContractPersonBusiRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5408\u540c\u627f\u529e\u4eba\u7528\u6237\u5982\u6b64\u90a3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        ContractGetLegalSideContractPersonAtomReqBO atomReqBO = (ContractGetLegalSideContractPersonAtomReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractGetLegalSideContractPersonAtomReqBO.class));
        List<Object> existCodes = new ArrayList();
        try {
            ContractGetLegalSideContractPersonAtomRspBO atomRspBO = this.contractGetLegalSideContractPersonAtomService.getLegalSidePerson(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new ZTBusinessException(atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getLegalSidePersonBOList())) {
                List<ContractLegalSidePersonBO> legalSidePersonBOList = atomRspBO.getLegalSidePersonBOList();
                List<Object> collect = legalSidePersonBOList.stream().map(item -> {
                    ContractLegalSideContractPersonBO personBO = new ContractLegalSideContractPersonBO();
                    personBO.setId(item.getID());
                    personBO.setOrg(item.getORG());
                    personBO.setLoginId(item.getLOGINID());
                    personBO.setPersonName(item.getPERSONNAME());
                    return personBO;
                }).collect(Collectors.toList());
                if (reqBO.getContractId() != null) {
                    ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
                    if (null == contractInfoPO) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\uff01");
                        return rspBO;
                    }
                    if (null == contractInfoPO.getCreateDeptId() || StringUtils.isEmpty((Object)contractInfoPO.getCreateDeptCode())) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u7ec4\u7ec7\u673a\u6784ID\u6216\u8005\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u67e5\u8be2\u4e3a\u7a7a\uff01");
                        return rspBO;
                    }
                    if (ContractConstant.ContractType.ORDER_CONTRACT.equals(contractInfoPO.getContractType()) && StringUtils.isEmpty((Object)contractInfoPO.getBuyerDeptCode())) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u9500\u552e\u8ba2\u5355\u5408\u540c\u7684\u4e70\u65b9\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        return rspBO;
                    }
                    UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                    if (ContractConstant.ContractType.ORDER_CONTRACT.equals(contractInfoPO.getContractType())) {
                        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgCode(contractInfoPO.getBuyerDeptCode());
                    } else {
                        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(contractInfoPO.getCreateDeptId());
                    }
                    UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.dycUmcEnterpriseOrgQryDetailService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
                    log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f" + JSONObject.toJSONString((Object)umcEnterpriseOrgQryDetailAbilityRspBO));
                    if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode())) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u673a\u6784\u83b7\u53d6\u8be6\u60c5\u5931\u8d25");
                        return rspBO;
                    }
                    UmcEnterpriseOrgDetailBO orgDetailBO = umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO();
                    if (!CollectionUtils.isEmpty((Collection)orgDetailBO.getContractLegalPromoters())) {
                        existCodes = orgDetailBO.getContractLegalPromoters().stream().filter(e -> !StringUtils.isEmpty((Object)e.getCode())).map(UmcLegalConversionBO::getCode).collect(Collectors.toList());
                    }
                }
                log.info("existCodes" + existCodes);
                if (!CollectionUtils.isEmpty(existCodes)) {
                    Integer isQryFlag = null;
                    ArrayList<ContractLegalSideContractPersonBO> legalSidePersonList = new ArrayList<ContractLegalSideContractPersonBO>();
                    for (ContractLegalSideContractPersonBO e2 : collect) {
                        if (!existCodes.contains(e2.getId())) continue;
                        isQryFlag = 1;
                        legalSidePersonList.add(e2);
                    }
                    if (isQryFlag != null && isQryFlag == 1) {
                        collect = legalSidePersonList;
                    }
                }
                if (!StringUtils.isEmpty((Object)reqBO.getLoginId()) || !StringUtils.isEmpty((Object)reqBO.getPersonName())) {
                    collect = collect.stream().filter(item -> item.getLoginId().equals(reqBO.getLoginId()) || item.getPersonName().contains(reqBO.getPersonName())).collect(Collectors.toList());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getOrg())) {
                    collect = collect.stream().filter(item -> item.getOrg().contains(reqBO.getOrg())).collect(Collectors.toList());
                }
                rspBO.setLegalSidePersonList(collect);
            }
        }
        catch (ZTBusinessException e3) {
            throw new ZTBusinessException(e3.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

