/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.CContractPushFailedBO;
import com.tydic.contract.ability.bo.ContractInfoItemBO;
import com.tydic.contract.busi.ContractPushMdmBusiService;
import com.tydic.contract.busi.bo.ContractCreateEgToMdmDataBO;
import com.tydic.contract.busi.bo.ContractGateWayApplicationForMasterDataReqBO;
import com.tydic.contract.busi.bo.ContractGateWayApplicationForMasterDataRspBO;
import com.tydic.contract.busi.bo.ContractGetPushFailedDataBusiReqBO;
import com.tydic.contract.busi.bo.ContractGetPushFailedDataBusiRspBO;
import com.tydic.contract.busi.bo.MdmzzfpBO;
import com.tydic.contract.busi.impl.ContractInitiateActionsBusiServiceImpl;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractManualEffectLogMapper;
import com.tydic.contract.dao.CContractPushFailedMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractPushFailedPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.umc.general.ability.api.UmcEntityOrgAddDataAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseBuyerQryReqBO;
import com.tydic.umc.general.ability.bo.UmcbuyerNameBuyerBO;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.UccGateWayApplicationForMasterDataMaterialOfChinaCoalAbilityService;
import com.tydic.uoc.common.ability.bo.UccGateWayApplicationForMasterReqBO;
import com.tydic.uoc.common.ability.bo.UccGateWayApplicationForMasterRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPushMdmBusiServiceImpl
implements ContractPushMdmBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractPushMdmBusiServiceImpl.class);
    @Autowired
    CContractPushFailedMapper cContractPushFailedMapper;
    @Autowired
    CContractManualEffectLogMapper cContractManualEffectLogMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    UccGateWayApplicationForMasterDataMaterialOfChinaCoalAbilityService uccGateWayApplicationForMasterDataMaterialOfChinaCoalAbilityService;
    @Value(value="${EG_TO_MDM_ZZFP}")
    private String egToMdmzzfp;
    @Autowired
    ContractInitiateActionsBusiServiceImpl contractInitiateActionsBusiService;
    @Autowired
    ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    CContractInfoExtMapper cContractInfoExtMapper;
    @Autowired
    ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEntityOrgAddDataAbilityService umcEntityOrgAddDataAbilityService;

    @Override
    public ContractGetPushFailedDataBusiRspBO getPushFailedData(ContractGetPushFailedDataBusiReqBO reqBO) {
        ContractGetPushFailedDataBusiRspBO rspBO = new ContractGetPushFailedDataBusiRspBO();
        CContractPushFailedPO cContractPushFailedPO = new CContractPushFailedPO();
        CContractPushFailedBO cContractPushFailedBO = new CContractPushFailedBO();
        cContractPushFailedBO.setRelateId(reqBO.getContractId());
        BeanUtil.copyProperties((Object)cContractPushFailedBO, (Object)cContractPushFailedPO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.cContractPushFailedMapper.queryAll(cContractPushFailedPO));
        List logPOS = page.getResult();
        List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)logPOS), CContractPushFailedBO.class);
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNum());
        rspBO.setTotal(page.getPages());
        rspBO.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        return rspBO;
    }

    @Override
    public ContractGetPushFailedDataBusiRspBO dealFailedDataToPush(ContractGetPushFailedDataBusiReqBO reqBO) {
        String desc18 = "";
        if (!StringUtils.isEmpty((Object)reqBO.getPushType())) {
            if ("1".equals(reqBO.getPushType())) {
                desc18 = "\u5e93\u5b58\u7c7b";
            }
            if ("2".equals(reqBO.getPushType())) {
                desc18 = "\u8d44\u4ea7\u7c7b";
            }
        }
        ContractGetPushFailedDataBusiRspBO rspBO = new ContractGetPushFailedDataBusiRspBO();
        CContractPushFailedPO cContractPushFailedPO = new CContractPushFailedPO();
        CContractPushFailedBO cContractPushFailedBO = new CContractPushFailedBO();
        cContractPushFailedBO.setRelateId(reqBO.getContractId());
        BeanUtil.copyProperties((Object)cContractPushFailedBO, (Object)cContractPushFailedPO);
        List<CContractPushFailedPO> cContractPushFailedPOS = this.cContractPushFailedMapper.queryAll(cContractPushFailedPO);
        if (CollectionUtils.isEmpty(cContractPushFailedPOS)) {
            return null;
        }
        this.cContractPushFailedMapper.deleteByPushIds(reqBO.getContractId());
        ArrayList<ContractCreateEgToMdmDataBO> createEgToMdmDataBOList = new ArrayList<ContractCreateEgToMdmDataBO>();
        for (CContractPushFailedPO contractPushFailedPO : cContractPushFailedPOS) {
            createEgToMdmDataBOList.add(this.buildFeailedDataBo(contractPushFailedPO, desc18));
        }
        this.dealData(createEgToMdmDataBOList, reqBO.getContractId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public ContractCreateEgToMdmDataBO buildFeailedDataBo(CContractPushFailedPO contractPushFailedPO, String desc18) {
        ContractCreateEgToMdmDataBO dataBO = new ContractCreateEgToMdmDataBO();
        dataBO.setDESC1(contractPushFailedPO.getMaterialCode());
        dataBO.setDESC4(contractPushFailedPO.getMaterialDesc());
        dataBO.setDESC6(contractPushFailedPO.getInventoryOrganization());
        dataBO.setDESC7(contractPushFailedPO.getErpOrgCode());
        dataBO.setDESC18(desc18);
        dataBO.setUUID(this.idUtil.nextId());
        dataBO.setUrl(this.egToMdmzzfp);
        return dataBO;
    }

    @Override
    public void pushData(Long contractId) {
        String contractTypeStr;
        String[] split;
        List<String> contractTypeList;
        ContractInfoPO contractInfoPO;
        String desc18 = "";
        CContractInfoExtPO cContractInfoExtPO = new CContractInfoExtPO();
        cContractInfoExtPO.setRelateId(contractId);
        CContractInfoExtPO modelBy = this.cContractInfoExtMapper.getModelBy(cContractInfoExtPO);
        if (modelBy == null || StringUtils.isEmpty((Object)modelBy.getPushMdm())) {
            return;
        }
        if (!StringUtils.isEmpty((Object)modelBy.getPushMdm())) {
            if ("1".equals(modelBy.getPushMdm())) {
                desc18 = "\u5e93\u5b58\u7c7b";
            }
            if ("2".equals(modelBy.getPushMdm())) {
                desc18 = "\u8d44\u4ea7\u7c7b";
            }
        }
        if ((contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractId)) != null && (contractTypeList = Arrays.asList(split = (contractTypeStr = "5,6,10,11,12,13,20,21").split(","))).contains(contractInfoPO.getContractType().toString())) {
            ArrayList<ContractCreateEgToMdmDataBO> createEgToMdmDataBOList = new ArrayList<ContractCreateEgToMdmDataBO>();
            List<ContractInfoItemPO> contractInfoItemPOList = this.contractInfoItemMapper.selectItemByContractId(contractId);
            if (!CollectionUtils.isEmpty(contractInfoItemPOList)) {
                for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOList) {
                    ContractInfoItemBO contractInfoItemBO = new ContractInfoItemBO();
                    BeanUtils.copyProperties((Object)contractInfoItemPO, (Object)contractInfoItemBO);
                    createEgToMdmDataBOList.add(this.buildDataBo(contractInfoItemBO, desc18));
                }
            }
            this.dealData(createEgToMdmDataBOList, contractId);
        }
    }

    public void dealData(List<ContractCreateEgToMdmDataBO> createEgToMdmDataBOList, Long contractId) {
        try {
            ContractGateWayApplicationForMasterDataReqBO masterDataReqBO = new ContractGateWayApplicationForMasterDataReqBO();
            Map<Long, ContractCreateEgToMdmDataBO> mapData = createEgToMdmDataBOList.stream().collect(Collectors.toMap(ContractCreateEgToMdmDataBO::getUUID, contractCreateEgToMdmDataBO -> contractCreateEgToMdmDataBO));
            masterDataReqBO.setCreateEgToMdmDataBOS(createEgToMdmDataBOList);
            masterDataReqBO.setUUID(String.valueOf(this.idUtil.nextId()));
            UccGateWayApplicationForMasterReqBO reqBO = (UccGateWayApplicationForMasterReqBO)JSON.parseObject((String)JSON.toJSONString((Object)masterDataReqBO), UccGateWayApplicationForMasterReqBO.class);
            log.info("\u8bf7\u6c42\u7684\u6570\u636e\u4e3a" + JSON.toJSONString((Object)masterDataReqBO));
            UccGateWayApplicationForMasterRspBO rspBO = this.uccGateWayApplicationForMasterDataMaterialOfChinaCoalAbilityService.applicationForMasterData(reqBO);
            log.info("\u8fd4\u56de\u7684\u6570\u636e\u4e3a" + JSON.toJSONString((Object)rspBO));
            ContractGateWayApplicationForMasterDataRspBO masterDataRspBO = (ContractGateWayApplicationForMasterDataRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspBO), ContractGateWayApplicationForMasterDataRspBO.class));
            log.info(JSON.toJSONString((Object)((Object)masterDataRspBO)));
            if (masterDataRspBO.getIsSuccess().booleanValue()) {
                if (!CollectionUtils.isEmpty(masterDataRspBO.getMdmzzfpBOListFailed())) {
                    List<MdmzzfpBO> mdmzzfpBOListFailed = masterDataRspBO.getMdmzzfpBOListFailed();
                    mdmzzfpBOListFailed.stream().forEach(mdmzzfpBO -> {
                        ContractCreateEgToMdmDataBO contractCreateEgToMdmDataBO = (ContractCreateEgToMdmDataBO)mapData.get(Long.valueOf(mdmzzfpBO.getUuid()));
                        if (contractCreateEgToMdmDataBO == null) {
                            throw new ZTBusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
                        }
                        this.saveData(contractCreateEgToMdmDataBO, contractId, mdmzzfpBO.getSynResult());
                    });
                }
            } else if (!CollectionUtils.isEmpty(createEgToMdmDataBOList)) {
                createEgToMdmDataBOList.stream().forEach(contractCreateEgToMdmDataBO -> this.saveData((ContractCreateEgToMdmDataBO)contractCreateEgToMdmDataBO, contractId, "\u8bbf\u95ee\u4e3b\u6570\u636e\u5904\u7406\u5f02\u5e38"));
            }
        }
        catch (Exception e) {
            if (!CollectionUtils.isEmpty(createEgToMdmDataBOList)) {
                createEgToMdmDataBOList.stream().forEach(contractCreateEgToMdmDataBO -> this.saveData((ContractCreateEgToMdmDataBO)contractCreateEgToMdmDataBO, contractId, "\u7a0b\u5e8f\u8fd0\u884c\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
            log.error("\u7a0b\u5e8f\u8fd0\u884c\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
    }

    public void saveData(ContractCreateEgToMdmDataBO createEgToMdmDataBO, Long contractId, String failedReason) {
        CContractPushFailedBO cContractPushFailedBO = new CContractPushFailedBO();
        cContractPushFailedBO.setPushId(Long.valueOf(this.idUtil.nextId()));
        cContractPushFailedBO.setRelateId(contractId);
        cContractPushFailedBO.setErpOrgCode(createEgToMdmDataBO.getDESC7() == null ? "" : createEgToMdmDataBO.getDESC7());
        cContractPushFailedBO.setInventoryOrganization(createEgToMdmDataBO.getDESC6() == null ? "" : createEgToMdmDataBO.getDESC6());
        cContractPushFailedBO.setMaterialDesc(createEgToMdmDataBO.getDESC4() == null ? "" : createEgToMdmDataBO.getDESC4());
        cContractPushFailedBO.setMaterialCode(createEgToMdmDataBO.getDESC1() == null ? "" : createEgToMdmDataBO.getDESC1());
        cContractPushFailedBO.setFailedReason(failedReason);
        cContractPushFailedBO.setCreateTime(new Date());
        CContractPushFailedPO cContractPushFailedPO = new CContractPushFailedPO();
        BeanUtils.copyProperties((Object)cContractPushFailedBO, (Object)cContractPushFailedPO);
        this.cContractPushFailedMapper.insert(cContractPushFailedPO);
    }

    public ContractCreateEgToMdmDataBO buildDataBo(ContractInfoItemBO contractInfoItemBO, String desc18) {
        ContractCreateEgToMdmDataBO dataBO = new ContractCreateEgToMdmDataBO();
        dataBO.setDESC1(contractInfoItemBO.getMaterialCode());
        dataBO.setDESC4(contractInfoItemBO.getMaterialDesc());
        if (!StringUtils.isEmpty((Object)contractInfoItemBO.getErpOrgCode())) {
            dataBO.setDESC6(contractInfoItemBO.getInventoryOrganization());
            dataBO.setDESC7(contractInfoItemBO.getErpOrgCode());
        } else {
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractInfoItemBO.getRelateId());
            UmcEnterpriseBuyerQryReqBO umcEnterpriseBuyerQryReqBO = new UmcEnterpriseBuyerQryReqBO();
            umcEnterpriseBuyerQryReqBO.setBuyerName(contractInfoPO.getBuyerName());
            UmcbuyerNameBuyerBO umcbuyerNameBuyerBO = this.umcEntityOrgAddDataAbilityService.queryOrganizationName(umcEnterpriseBuyerQryReqBO);
            if (umcbuyerNameBuyerBO != null) {
                dataBO.setDESC7(umcbuyerNameBuyerBO.getOrganizationId());
                dataBO.setDESC6(umcbuyerNameBuyerBO.getOrganizationName());
            }
        }
        dataBO.setDESC18(desc18);
        dataBO.setUUID(this.idUtil.nextId());
        dataBO.setUrl(this.egToMdmzzfp);
        return dataBO;
    }
}

