/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.tydic.contract.busi.ContractUpdateTermsBusiService;
import com.tydic.contract.busi.bo.ContractUpdateTermsBusiReqBO;
import com.tydic.contract.busi.bo.ContractUpdateTermsBusiRspBO;
import com.tydic.contract.dao.CContractRelOrgMapper;
import com.tydic.contract.dao.CContractRelTemplateTermMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.CContractRelOrgPO;
import com.tydic.contract.po.CContractRelTemplateTermPO;
import com.tydic.contract.po.ContractTermsPo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractUpdateTermsBusiServiceImpl
implements ContractUpdateTermsBusiService {
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    CContractRelTemplateTermMapper cContractRelTemplateTermMapper;
    @Autowired
    CContractRelOrgMapper cContractRelOrgMapper;

    @Override
    public ContractUpdateTermsBusiRspBO updateTerms(ContractUpdateTermsBusiReqBO reqBO) {
        ContractUpdateTermsBusiRspBO rspBO = new ContractUpdateTermsBusiRspBO();
        ContractTermsPo contractTermsInfoPo = this.contractTermsMapper.selectByPrimaryKey(reqBO.getTermId());
        if (null == contractTermsInfoPo) {
            rspBO.setRespCode("1002");
            rspBO.setRespDesc("\u5408\u540c\u6761\u6b3e\u4e0d\u5b58\u5728");
        } else {
            ContractTermsPo updateContractTermsPo = new ContractTermsPo();
            BeanUtils.copyProperties((Object)((Object)contractTermsInfoPo), (Object)((Object)updateContractTermsPo));
            updateContractTermsPo.setTermCode(reqBO.getTermCode());
            updateContractTermsPo.setTermName(reqBO.getTermName());
            updateContractTermsPo.setTermType(reqBO.getTermType());
            updateContractTermsPo.setTermText(reqBO.getTermText());
            updateContractTermsPo.setUpdateUserId(reqBO.getUpdateUserId());
            updateContractTermsPo.setUpdateUserName(reqBO.getUpdateUserName());
            updateContractTermsPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            updateContractTermsPo.setValidStatus(reqBO.getTermOperType() == 1 ? 3 : 1);
            updateContractTermsPo.setEditFlag(reqBO.getEditFlag());
            int i = this.contractTermsMapper.updateByPrimaryKeySelective(updateContractTermsPo);
            ArrayList<CContractRelOrgPO> cContractRelOrgPOS = new ArrayList<CContractRelOrgPO>();
            if (null != reqBO.getOrgInfos() && reqBO.getOrgInfos().size() > 0) {
                reqBO.getOrgInfos().forEach(depts -> {
                    CContractRelOrgPO cContractRelOrgPO = new CContractRelOrgPO();
                    cContractRelOrgPO.setRelateId(contractTermsInfoPo.getTermId());
                    cContractRelOrgPO.setApplyDeptId(depts.getOrgId());
                    cContractRelOrgPO.setApplyDeptCode(depts.getOrgCode());
                    cContractRelOrgPO.setApplyDeptName(depts.getOrgName());
                    cContractRelOrgPOS.add(cContractRelOrgPO);
                });
            }
            CContractRelOrgPO del = new CContractRelOrgPO();
            del.setRelateId(contractTermsInfoPo.getTermId());
            this.cContractRelOrgMapper.deleteBy(del);
            if (!CollectionUtils.isEmpty(cContractRelOrgPOS)) {
                this.cContractRelOrgMapper.insertBatch(cContractRelOrgPOS);
            }
            ArrayList<CContractRelTemplateTermPO> cContractRelTemplateTermPOS = new ArrayList<CContractRelTemplateTermPO>();
            List<Long> templateIds = reqBO.getTemplateIds();
            if (null != templateIds && templateIds.size() > 0) {
                templateIds.forEach(tem -> {
                    CContractRelTemplateTermPO cContractRelTemplateTermPO = new CContractRelTemplateTermPO();
                    cContractRelTemplateTermPO.setTermId(contractTermsInfoPo.getTermId());
                    cContractRelTemplateTermPO.setTemplateId((Long)tem);
                    cContractRelTemplateTermPOS.add(cContractRelTemplateTermPO);
                });
            }
            CContractRelTemplateTermPO delTer = new CContractRelTemplateTermPO();
            delTer.setTermId(contractTermsInfoPo.getTermId());
            this.cContractRelTemplateTermMapper.deleteBy(delTer);
            if (!CollectionUtils.isEmpty(cContractRelTemplateTermPOS)) {
                this.cContractRelTemplateTermMapper.insertBatch(cContractRelTemplateTermPOS);
            }
            if (i == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5408\u540c\u6761\u6b3e\u4fee\u6539\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5408\u540c\u6761\u6b3e\u4fee\u6539\u5931\u8d25");
            }
        }
        return rspBO;
    }
}

