/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import com.aspose.pdf.Document;
import com.aspose.pdf.Font;
import com.aspose.pdf.FontRepository;
import com.aspose.pdf.Page;
import com.aspose.pdf.Position;
import com.aspose.pdf.TextBuilder;
import com.aspose.pdf.TextParagraph;
import com.aspose.pdf.TextState;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PdfAsposeModel {
    private static final String FONT = "SimSun";
    private static final float FONTSIZE = 10.0f;
    private Double xCoordinate;
    private Double yCoordinate;
    private Integer pageNum;
    private String content;

    public Double getxCoordinate() {
        return this.xCoordinate;
    }

    public void setxCoordinate(Double xCoordinate) {
        this.xCoordinate = xCoordinate;
    }

    public Double getyCoordinate() {
        return this.yCoordinate;
    }

    public void setyCoordinate(Double yCoordinate) {
        this.yCoordinate = yCoordinate;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public PdfAsposeModel(Double xCoordinate, Double yCoordinate, Integer pageNum, String content) {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.pageNum = pageNum;
        this.content = content;
    }

    public static void main(String[] args) {
        ArrayList<PdfAsposeModel> list = new ArrayList<PdfAsposeModel>();
        list.add(new PdfAsposeModel(420.0, 800.0, 1, "\u5408\u540c\u7f16\u53f7\uff1a"));
        list.add(new PdfAsposeModel(470.0, 800.0, 1, "CK-1098-2212-0001"));
        String filePath = "C:\\Users\\Administrator\\Desktop/\u6d4b\u8bd5.pdf";
        try {
            PdfAsposeModel.pdfSign2(filePath, list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pdfSign2(String pdfFilePath, List<PdfAsposeModel> list) throws IOException {
        int indexOf = pdfFilePath.lastIndexOf("/");
        if (indexOf == -1) {
            indexOf = pdfFilePath.lastIndexOf("\\");
        }
        int indexOf2 = pdfFilePath.lastIndexOf(".");
        String suffix = pdfFilePath.substring(indexOf2);
        String url = pdfFilePath.substring(0, indexOf + 1);
        url = url + UUID.randomUUID().toString() + suffix;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(pdfFilePath);
            outputStream = new FileOutputStream(url);
            int hasRead = 0;
            while ((hasRead = inputStream.read()) != -1) {
                outputStream.write(hasRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        for (PdfAsposeModel model : list) {
            Double xCoordinate = model.getxCoordinate();
            Double yCoordinate = model.getyCoordinate();
            String content = model.getContent();
            Integer pageNum = model.getPageNum();
            if (xCoordinate == null || yCoordinate == null || content == null || "".equals(content) || pageNum == null || pageNum < 1) continue;
            Document document = null;
            try {
                document = new Document(url);
                if (document == null) continue;
                Page page = document.getPages().get_Item(pageNum.intValue());
                if (page != null) {
                    TextParagraph paragraph = new TextParagraph();
                    paragraph.getFormattingOptions().setWrapMode(2);
                    TextState textState = new TextState();
                    Font pdfFont = FontRepository.findFont((String)FONT, (boolean)true);
                    textState.setFont(pdfFont);
                    textState.setFontSize(10.0f);
                    paragraph.appendLine(content, textState);
                    Position position = new Position(xCoordinate.doubleValue(), yCoordinate.doubleValue());
                    paragraph.setPosition(position);
                    TextBuilder textBuilder = new TextBuilder(page);
                    textBuilder.appendParagraph(paragraph);
                } else {
                    System.out.println("\u9875\u9762\u7b2c\uff1a" + pageNum + "\u9875\u4e0d\u5b58\u5728");
                }
                document.save();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (document == null) continue;
                document.close();
            }
        }
    }
}

