/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.po.FscApprovalprocessListBO;
import com.tydic.contract.utils.CheckUtils;
import com.tydic.contract.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class PdfUtils {
    public static Font DEFAULT_TITLE_FONT;
    public static Font DEFAULT_SECOND_TITLE_FONT;
    public static Font DEFAULT_CONTENT_FONT;
    public static final int DEFAULT_COLUMNS = 24;

    public static Document newDefaultDocument() {
        return new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
    }

    public static PdfPTable newPdfTable() {
        return new PdfPTable(24);
    }

    public static PdfPTable newPdfTable(int size) {
        return new PdfPTable(size);
    }

    public static void addCellToTable(PdfPTable table, Object content, Font font, Integer horizontalAlignment, Integer verticalAlignment, Float fixedHeight, Integer colspan, Integer border) {
        if (CheckUtils.isBlank(content)) {
            if (content instanceof PdfPTable) {
                return;
            }
            content = content instanceof BigDecimal ? "0.00" : "";
        }
        PdfPCell cell = content instanceof PdfPTable ? new PdfPCell((PdfPTable)content) : new PdfPCell(new Phrase(content.toString(), font));
        if (fixedHeight != null) {
            cell.setFixedHeight(fixedHeight.floatValue());
        }
        if (horizontalAlignment != null) {
            cell.setHorizontalAlignment(horizontalAlignment.intValue());
        }
        if (verticalAlignment != null) {
            cell.setVerticalAlignment(verticalAlignment.intValue());
        }
        if (colspan != null) {
            cell.setColspan(colspan.intValue());
        }
        if (border != null) {
            cell.setBorder(border.intValue());
        }
        table.addCell(cell);
    }

    public static void addTableListToDoc(Document document, List<PdfPTable> tableList) {
        if (CollectionUtils.isEmpty(tableList)) {
            return;
        }
        tableList.forEach(table -> {
            try {
                document.add((Element)table);
            }
            catch (DocumentException e) {
                throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519");
            }
        });
    }

    public static void addAuditTable(List<PdfPTable> tableList, List<FscApprovalprocessListBO> auditList) {
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable(pageTableAuditTitle, "\u5ba1\u6279\u8bb0\u5f55", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(35.0f), 24, null);
        PdfPTable pageTableAudit = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable(pageTableAudit, "\u8282\u70b9", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
        PdfUtils.addCellToTable(pageTableAudit, "\u65e5\u671f", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
        PdfUtils.addCellToTable(pageTableAudit, "\u5ba1\u6279\u7ec4", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
        PdfUtils.addCellToTable(pageTableAudit, "\u5ba1\u6279\u4eba", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
        PdfUtils.addCellToTable(pageTableAudit, "\u5ba1\u6279\u610f\u89c1", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
        PdfUtils.addCellToTable(pageTableAudit, "\u5ba1\u6279\u72b6\u6001", DEFAULT_SECOND_TITLE_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
        tableList.add(pageTableAudit);
        if (!CollectionUtils.isEmpty(auditList)) {
            for (int i = 0; i < auditList.size(); ++i) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable(auditTable, String.valueOf(i + 1), DEFAULT_CONTENT_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
                PdfUtils.addCellToTable(auditTable, FscStringUtils.convertValue(auditList.get(i).getTime()), DEFAULT_CONTENT_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
                PdfUtils.addCellToTable(auditTable, FscStringUtils.convertValue(auditList.get(i).getStationName()), DEFAULT_CONTENT_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
                PdfUtils.addCellToTable(auditTable, FscStringUtils.convertValue(auditList.get(i).getOperName()), DEFAULT_CONTENT_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
                PdfUtils.addCellToTable(auditTable, FscStringUtils.convertValue(auditList.get(i).getAdvice()), DEFAULT_CONTENT_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
                PdfUtils.addCellToTable(auditTable, FscStringUtils.convertValue(auditList.get(i).getAudit()), DEFAULT_CONTENT_FONT, 1, 5, Float.valueOf(30.0f), 4, null);
                tableList.add(auditTable);
            }
        }
    }

    static {
        BaseFont baseFont;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
        }
        DEFAULT_TITLE_FONT = new Font(baseFont, 16.0f, 1);
        DEFAULT_SECOND_TITLE_FONT = new Font(baseFont, 11.0f, 0);
        DEFAULT_CONTENT_FONT = new Font(baseFont, 9.0f, 0);
    }
}

