/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractHeaderQryAbilityService;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.ability.bo.ContractHeaderQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHeaderQryAbilityRspBO;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractHeaderQryAbilityService"})
public class ContractHeaderQryAbilityServiceImpl
implements ContractHeaderQryAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;

    @PostMapping(value={"qryContractHeader"})
    public ContractHeaderQryAbilityRspBO qryContractHeader(@RequestBody ContractHeaderQryAbilityReqBO reqBO) {
        this.valid(reqBO);
        ContractHeaderQryAbilityRspBO rspBO = new ContractHeaderQryAbilityRspBO();
        ContractInfoPO contractPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractPo == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        rspBO.setContactPhone(contractPo.getSupplierPhone());
        rspBO.setContractType(contractPo.getContractType());
        rspBO.setContractStatus(contractPo.getContractStatus());
        rspBO.setContractName(contractPo.getContractName());
        rspBO.setRemark(contractPo.getRemark());
        rspBO.setMaterialSource(contractPo.getMaterialSource());
        rspBO.setSupplierBankAccount(contractPo.getSupplierAccount());
        rspBO.setSupplierBankName(contractPo.getSupplierBankName());
        ContractAccessoryPo accessoryPo = new ContractAccessoryPo();
        accessoryPo.setRelateId(contractPo.getContractId());
        List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(accessoryPo);
        ArrayList<ContractAccessoryBO> accessoryList = new ArrayList<ContractAccessoryBO>();
        for (ContractAccessoryPo contractAccessoryPo : contractAccessoryPos) {
            ContractAccessoryBO accessoryBO = (ContractAccessoryBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractAccessoryPo), ContractAccessoryBO.class);
            accessoryList.add(accessoryBO);
        }
        if (!StringUtils.isEmpty((CharSequence)contractPo.getContractDocUrl())) {
            ContractAccessoryBO accessoryBO = new ContractAccessoryBO();
            accessoryBO.setAcceessoryName(contractPo.getContractDocName());
            accessoryBO.setAcceessoryUrl(contractPo.getContractDocUrl());
            accessoryList.add(accessoryBO);
        }
        rspBO.setAccessoryList(accessoryList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(ContractHeaderQryAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

