/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractItemChangeQueryAbilityService;
import com.tydic.contract.ability.ContractItemPdfCreateAbilityService;
import com.tydic.contract.ability.bo.ContractAddNewAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityReqBO;
import com.tydic.contract.ability.impl.ContractItemPdfAcceessThread;
import com.tydic.contract.busi.ContractItemPdfCreateBusiService;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemPdfCreateAbilityService"})
public class ContractItemPdfCreateAbilityServiceImpl
implements ContractItemPdfCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemPdfCreateAbilityServiceImpl.class);
    @Autowired
    ContractItemChangeQueryAbilityService contractItemChangeQueryAbilityService;
    @Autowired
    ContractInfoMapper contractInfoMapper;
    @Autowired
    ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    ContractItemPdfCreateBusiService contractItemPdfCreateBusiService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"pdfCreate"})
    public ContractAddNewAbilityRspBO pdfCreate(@RequestBody ContractItemQueryAbilityReqBO reqBO) {
        ContractAddNewAbilityRspBO rspBO = new ContractAddNewAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b63\u5728\u751f\u6210\uff01");
        if (null != reqBO.getContractId()) {
            ContractInfoPO oldContractInfoPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            if (oldContractInfoPo == null) throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
            ContractInfoPO updatePO = new ContractInfoPO();
            updatePO.setItemPdfAccessoryName("\u5408\u540c\u660e\u7ec6pdf\u9644\u4ef6.xlsx");
            updatePO.setItemPdfAccessoryUrl(null);
            updatePO.setItemPdfAccessoryGenerateState(1);
            updatePO.setContractId(oldContractInfoPo.getContractId());
            this.contractInfoMapper.updateContract(updatePO);
            rspBO.setContractId(reqBO.getContractId());
            return rspBO;
        } else if (null != reqBO.getUpdateApplyId()) {
            ContractInfoChangePO oldContractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
            if (oldContractInfoChangePO == null) throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
            ContractInfoChangePO updatePO = new ContractInfoChangePO();
            updatePO.setItemAccessoryName("\u5408\u540c\u660e\u7ec6pdf\u9644\u4ef6.xlsx");
            updatePO.setItemPdfAccessoryUrl(null);
            updatePO.setItemPdfAccessoryGenerateState(1);
            updatePO.setUpdateApplyId(oldContractInfoChangePO.getUpdateApplyId());
            this.contractInfoChangeMapper.updateByPrimaryKeySelective(updatePO);
            rspBO.setContractId(reqBO.getUpdateApplyId());
            return rspBO;
        } else {
            ContractItemPdfAcceessThread itemAcceessThread;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            String format = sdf.format(new Date());
            ContractInfoPO searchPO = new ContractInfoPO();
            searchPO.setItemPdfAccessoryGenerateState(1);
            List<ContractInfoPO> pos = this.contractInfoMapper.getList(searchPO);
            List<Object> contractIds = new ArrayList();
            List<Object> updateApplyIds = new ArrayList();
            int size = 0;
            if (!CollectionUtils.isEmpty(pos)) {
                contractIds = pos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getIsItemPdfAccessory()) && e.getIsItemPdfAccessory().equals(1)).map(ContractInfoPO::getContractId).collect(Collectors.toList());
                size += contractIds.size();
            }
            ContractInfoChangePO searchChangePO = new ContractInfoChangePO();
            searchChangePO.setItemPdfAccessoryGenerateState(1);
            List<ContractInfoChangePO> changePOS = this.contractInfoChangeMapper.getList(searchChangePO);
            if (!CollectionUtils.isEmpty(changePOS)) {
                updateApplyIds = changePOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getIsItemPdfAccessory()) && e.getIsItemPdfAccessory().equals(1)).map(ContractInfoChangePO::getUpdateApplyId).collect(Collectors.toList());
                size += updateApplyIds.size();
            }
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-contract_item_acceess123-" + format).build();
            ThreadPoolExecutor fixedAcceessThreadPool = new ThreadPoolExecutor(3, 8, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
            if (!CollectionUtils.isEmpty(contractIds)) {
                for (Long l : contractIds) {
                    itemAcceessThread = new ContractItemPdfAcceessThread();
                    itemAcceessThread.setContractId(l);
                    itemAcceessThread.setContractInfoMapper(this.contractInfoMapper);
                    itemAcceessThread.setContractItemPdfCreateBusiService(this.contractItemPdfCreateBusiService);
                    fixedAcceessThreadPool.submit(itemAcceessThread);
                }
            }
            if (!CollectionUtils.isEmpty(updateApplyIds)) {
                for (Long l : updateApplyIds) {
                    itemAcceessThread = new ContractItemPdfAcceessThread();
                    itemAcceessThread.setUpdateApplyId(l);
                    itemAcceessThread.setContractInfoChangeMapper(this.contractInfoChangeMapper);
                    itemAcceessThread.setContractItemPdfCreateBusiService(this.contractItemPdfCreateBusiService);
                    fixedAcceessThreadPool.submit(itemAcceessThread);
                }
            }
            fixedAcceessThreadPool.shutdown();
            while (true) {
                if (fixedAcceessThreadPool.isTerminated()) {
                    log.debug("\u65f6\u95f4" + format + "\u5f00\u59cb\u7684\u5408\u540c\u660e\u7ec6\u9644\u4ef6\u5904\u7406\u670d\u52a1\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u52a1\u7ed3\u675f");
                    return rspBO;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage());
                }
            }
        }
    }
}

