/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractLegalPushAuditLogAbilityService;
import com.tydic.contract.ability.bo.ContractApproveWaitNotificationReqBO;
import com.tydic.contract.ability.bo.ContractLegalPushAuditLogAbilityReqBO;
import com.tydic.contract.ability.bo.ContractLegalPushAuditLogAbilityRspBO;
import com.tydic.contract.busi.ContractLegalPushAuditLogBusiService;
import com.tydic.contract.busi.bo.ContractLegalPushAuditLogBusiReqBO;
import com.tydic.contract.busi.bo.ContractLegalPushAuditLogBusiRspBO;
import com.tydic.contract.busi.bo.ContractPushErpBusiReqBO;
import com.tydic.contract.dao.ContractAcceptFailLogMapper;
import com.tydic.contract.dao.ContractAcceptLogMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.po.ContractAcceptFailLogPO;
import com.tydic.contract.po.ContractAcceptLogPO;
import com.tydic.contract.po.ContractInfoChangePO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractLegalPushAuditLogAbilityService"})
public class ContractLegalPushAuditLogAbilityServiceImpl
implements ContractLegalPushAuditLogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractLegalPushAuditLogAbilityServiceImpl.class);
    @Autowired
    private ContractLegalPushAuditLogBusiService contractLegalPushAuditLogBusiService;
    @Autowired
    private ContractAcceptLogMapper contractAcceptLogMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractAcceptFailLogMapper contractAcceptFailLogMapper;
    @Resource(name="mqContractApproveWaitNotificationProvider")
    private ProxyMessageProducer mqContractApproveWaitNotificationProvider;
    @Value(value="${CONTRACT_APPROVE_WAIT_NOTIFICATION_PID_TOPIC:CONTRACT_APPROVE_WAIT_NOTIFICATION_PID_TOPIC}")
    private String contractApproveWaitNotificationPidTopic;
    @Value(value="${CONTRACT_APPROVE_WAIT_NOTIFICATION_PID_TAG:*}")
    private String contractApproveWaitNotificationPidTag;
    @Resource(name="mqContractPushErpProvider")
    private ProxyMessageProducer mqContractPushErpProvider;
    @Value(value="${CONTRACT_PUSH_ERP_TOPIC}")
    private String contractPushErpTopic;
    @Value(value="${CONTRACT_PUSH_ERP_TAG:*}")
    private String contractPushErpTag;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Resource(name="mqContractApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqContractApproveEntrustNotificationProvider;
    @Value(value="${CONTRACT_APPROVE_ENTRUST_NOTIFICATION_TOPIC:CONTRACT_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String contractApproveEntrustNotificationTopic;
    @Value(value="${CONTRACT_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String contractApproveEntrustNotificationTag;

    @PostMapping(value={"pushAudit"})
    public ContractLegalPushAuditLogAbilityRspBO pushAudit(@RequestBody ContractLegalPushAuditLogAbilityReqBO reqBO) {
        ContractLegalPushAuditLogBusiReqBO busiReqBO = (ContractLegalPushAuditLogBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractLegalPushAuditLogBusiReqBO.class);
        Date acceptTime = new Date();
        long start = System.currentTimeMillis();
        ContractAcceptLogPO contractAcceptLogPO = new ContractAcceptLogPO();
        contractAcceptLogPO.setId(this.uccBatchSequence.nextId());
        contractAcceptLogPO.setAcceptInfo(JSONObject.toJSONString((Object)reqBO));
        contractAcceptLogPO.setAcceptTime(acceptTime);
        ContractLegalPushAuditLogBusiRspBO rspBO = this.contractLegalPushAuditLogBusiService.insertPushAudit(busiReqBO);
        Date figureOutTime = new Date();
        long end = System.currentTimeMillis();
        contractAcceptLogPO.setFigureOutTime(figureOutTime);
        contractAcceptLogPO.setTimeSpent("\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0);
        contractAcceptLogPO.setFigureOutInfo(rspBO.getRespDesc() + "\u7f16\u53f7\u751f\u6210\u65e5\u5fd7\uff1a" + rspBO.getGenerateCodeStr());
        if (reqBO.getAcceptLogType() != null && "2".equals(reqBO.getAcceptLogType().toString())) {
            contractAcceptLogPO.setType(3);
        } else {
            contractAcceptLogPO.setType(1);
        }
        this.contractAcceptLogMapper.insert(contractAcceptLogPO);
        if (!"0000".equals(rspBO.getRespCode())) {
            ContractAcceptFailLogPO contractAcceptFailLogPO = (ContractAcceptFailLogPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractAcceptLogPO), ContractAcceptFailLogPO.class);
            contractAcceptFailLogPO.setStatus(0);
            this.contractAcceptFailLogMapper.insert(contractAcceptFailLogPO);
        } else {
            ContractPushErpBusiReqBO zb = new ContractPushErpBusiReqBO();
            zb.setContractCode(busiReqBO.getContractCode());
            zb.setIsZb("1");
            this.mqContractPushErpProvider.send(new ProxyMessage(this.contractPushErpTopic, this.contractPushErpTag, JSON.toJSONString((Object)((Object)zb))));
        }
        if (!(rspBO.getSendType() == null || CollectionUtils.isEmpty(rspBO.getSendContractIds()) && CollectionUtils.isEmpty(rspBO.getSendUupdateApplyIds()))) {
            ContractApproveWaitNotificationReqBO contractApproveWaitNotificationReqBO = new ContractApproveWaitNotificationReqBO();
            if (!CollectionUtils.isEmpty(rspBO.getSendContractIds())) {
                contractApproveWaitNotificationReqBO.setContractIds(rspBO.getSendContractIds());
            }
            if (!CollectionUtils.isEmpty(rspBO.getSendUupdateApplyIds())) {
                contractApproveWaitNotificationReqBO.setUpdateApplyIds(rspBO.getSendUupdateApplyIds());
            }
            contractApproveWaitNotificationReqBO.setType(rspBO.getSendType());
            try {
                log.info("\u5408\u540c\u5ba1\u6279\u5f85\u529e\u901a\u77e5\u53d1\u9001\u670d\u52a1\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)contractApproveWaitNotificationReqBO));
                this.mqContractApproveWaitNotificationProvider.send(new ProxyMessage(this.contractApproveWaitNotificationPidTopic, this.contractApproveWaitNotificationPidTag, JSON.toJSONString((Object)contractApproveWaitNotificationReqBO)));
            }
            catch (Exception e2) {
                log.error("\u5408\u540c\u5ba1\u6279\u5f85\u529e\u901a\u77e5\u53d1\u9001\u670d\u52a1\u6d88\u606f\u5931\u8d25\uff1a" + e2.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractApproveWaitNotificationReqBO));
            }
        }
        if (!CollectionUtils.isEmpty(rspBO.getSendPushTzContractIds())) {
            List<ContractInfoChangePO> infoPOS = this.contractInfoChangeMapper.qryListByIds(rspBO.getSendPushTzContractIds());
            List contractIds = infoPOS.stream().filter(e -> new Integer(7).equals(e.getContractType())).map(e -> e.getContractId()).collect(Collectors.toList());
            for (Long contractId : contractIds) {
                JSONObject json = new JSONObject();
                json.put("contractId", (Object)contractId);
                this.mqContractApproveWaitNotificationProvider.send(new ProxyMessage(this.pushContractTzTopic, this.pushContractTzTag, json.toJSONString()));
            }
        }
        if ("0000".equals(rspBO.getRespCode()) && !CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
            ContractApproveWaitNotificationReqBO approveWaitNotificationReqBO = new ContractApproveWaitNotificationReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(rspBO.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(rspBO.getApproveEntrustType());
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqContractApproveEntrustNotificationProvider.send(new ProxyMessage(this.contractApproveEntrustNotificationTopic, this.contractApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e3) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e3.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        return (ContractLegalPushAuditLogAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)rspBO)), ContractLegalPushAuditLogAbilityRspBO.class);
    }
}

