/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQuerySaleContractCanOrderListAbilityService;
import com.tydic.contract.ability.bo.ContractQuerySaleContractCanOrderListAbilityBO;
import com.tydic.contract.ability.bo.ContractQuerySaleContractCanOrderListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQuerySaleContractCanOrderListAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractQuerySaleContractCanOrderListAbilityService"})
public class ContractQuerySaleContractCanOrderListAbilityServiceImpl
implements ContractQuerySaleContractCanOrderListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractQuerySaleContractCanOrderListAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Value(value="${DEVELOP_COMPANY_DEPARTMENT}")
    private String developCompanyDepartment;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Value(value="${contract.order.select.setting:test}")
    private String contractOrderSelectSetting;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"querySaleContractCanOrderList"})
    public ContractQuerySaleContractCanOrderListAbilityRspBO querySaleContractCanOrderList(@RequestBody ContractQuerySaleContractCanOrderListAbilityReqBO reqBO) {
        ContractQuerySaleContractCanOrderListAbilityRspBO rspBO = new ContractQuerySaleContractCanOrderListAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getOccupation())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
            rspBO.setRows(null);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            return rspBO;
        }
        if (reqBO.getOrgId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (!StringUtils.isEmpty((Object)this.developCompanyDepartment)) {
            if (this.developCompanyDepartment.contains(",")) {
                String[] split;
                for (String s : split = this.developCompanyDepartment.split(",")) {
                    try {
                        orgIdList.add(Long.valueOf(s));
                    }
                    catch (Exception e2) {
                        log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + s);
                    }
                }
            } else {
                try {
                    orgIdList.add(Long.valueOf(this.developCompanyDepartment));
                }
                catch (Exception e3) {
                    log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + this.developCompanyDepartment);
                }
            }
        }
        ContractInfoPO seachPO = new ContractInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)seachPO);
        if (orgIdList.contains(reqBO.getOrgId())) {
            if (this.contractOrderSelectSetting.equals("test")) {
                seachPO.setContractTypes(Lists.newArrayList((Object[])new Integer[]{ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE, ContractConstant.ContractType.SPOT_CONTRACT, ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT, ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT}));
                seachPO.setBusinessTypes(Arrays.asList(ContractConstant.BusinessType.SELF_PURCHASE, ContractConstant.BusinessType.TRIPARTITE_INTERNAL_AGENCY));
            }
            if (this.contractOrderSelectSetting.equals("uat")) {
                seachPO.setContractTypes(Lists.newArrayList((Object[])new Integer[]{ContractConstant.ContractType.DEVELOPMENT_CONTRACT, ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT}));
            }
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                seachPO.setCreateUserId(reqBO.getUserId());
            }
            seachPO.setSearchDate(new Date());
        } else {
            ArrayList<Integer> contractTypes = new ArrayList<Integer>();
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                List<String> buyerNos;
                seachPO.setContractType(ContractConstant.ContractType.SALE_CONTRACT);
                seachPO.setAwardEmployeeNumber(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
                dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
                if (!"0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode())) throw new ZTBusinessException(dycUmcQueryBuyerPermissionRspBo.getRespDesc());
                if (!CollectionUtils.isEmpty((Collection)dycUmcQueryBuyerPermissionRspBo.getRows()) && !CollectionUtils.isEmpty(buyerNos = dycUmcQueryBuyerPermissionRspBo.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrgCode())).map(e -> e.getOrgCode()).collect(Collectors.toList()))) {
                    seachPO.setBuyerNos(buyerNos);
                }
            } else {
                contractTypes.add(ContractConstant.ContractType.SALE_CONTRACT);
            }
            contractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
            seachPO.setSearchDate(new Date());
            seachPO.setUnitContractPricingType(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
            seachPO.setUnitContractPricingConsType(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
            seachPO.setContractTypes(contractTypes);
            seachPO.setIsDevelopCompanyDepartment(1);
        }
        seachPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        seachPO.setVendorStatus(1);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.querySaleContractCanOrderList(seachPO));
        List contractInfoPOS = page.getResult();
        ArrayList<ContractQuerySaleContractCanOrderListAbilityBO> rows = new ArrayList<ContractQuerySaleContractCanOrderListAbilityBO>();
        if (!CollectionUtils.isEmpty((Collection)contractInfoPOS)) {
            for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                ContractQuerySaleContractCanOrderListAbilityBO row = (ContractQuerySaleContractCanOrderListAbilityBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractInfoPO), ContractQuerySaleContractCanOrderListAbilityBO.class);
                if (contractInfoPO.getContractAmount() != null) {
                    row.setContractAmount(MoneyUtils.haoToYuan(contractInfoPO.getContractAmount()));
                }
                if (contractInfoPO.getDiscussAmount() != null) {
                    row.setDiscussAmount(MoneyUtils.haoToYuan(contractInfoPO.getDiscussAmount()));
                }
                if (contractInfoPO.getAmountLimit() != null) {
                    row.setAmountLimit(MoneyUtils.haoToYuan(contractInfoPO.getAmountLimit()));
                }
                if (contractInfoPO.getMinAmount() != null) {
                    row.setMinAmount(MoneyUtils.haoToYuan(contractInfoPO.getMinAmount()));
                }
                if (contractInfoPO.getContractType() != null) {
                    row.setContractTypeStr(ContractTransFieldUtil.transContractType(contractInfoPO.getContractType()));
                }
                rows.add(row);
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        return rspBO;
    }
}

