/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractSaveStockChangeAbilityService;
import com.tydic.contract.ability.bo.ContractSaveStockChangeReqBo;
import com.tydic.contract.ability.bo.ContractSaveStockChangeRspBo;
import com.tydic.contract.ability.bo.ContractStockChangePushWmsAbilityReqBO;
import com.tydic.contract.busi.ContractSaveStockChangeBusiService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractSaveStockChangeAbilityService"})
public class ContractSaveStockChangeAbilityServiceImpl
implements ContractSaveStockChangeAbilityService {
    @Autowired
    private ContractSaveStockChangeBusiService contractSaveStockChangeBusiService;
    @Resource(name="mqContractPushWmsProvider")
    private ProxyMessageProducer mqContractPushWmsProvider;
    @Value(value="${CONTRACT_PUSH_WMS_TOPIC:CONTRACT_PUSH_WMS_TOPIC}")
    private String contractPushWmsTopic;
    @Value(value="${CONTRACT_PUSH_WMS_TAG:*}")
    private String contractPushWmsTag;

    @PostMapping(value={"saveStockChange"})
    public ContractSaveStockChangeRspBo saveStockChange(@RequestBody ContractSaveStockChangeReqBo reqBo) {
        this.checkReqBO(reqBo);
        ContractSaveStockChangeRspBo rspBo = this.contractSaveStockChangeBusiService.saveStockChange(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            ContractStockChangePushWmsAbilityReqBO abilityReqBO = new ContractStockChangePushWmsAbilityReqBO();
            abilityReqBO.setContractId(reqBo.getContractId());
            abilityReqBO.setTempId(reqBo.getTempId());
            abilityReqBO.setOperateType(Integer.valueOf(1));
            this.mqContractPushWmsProvider.send(new ProxyMessage(this.contractPushWmsTopic, this.contractPushWmsTag, JSON.toJSONString((Object)abilityReqBO)));
        }
        return rspBo;
    }

    private void checkReqBO(ContractSaveStockChangeReqBo reqBo) {
        if (reqBo == null) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getChangeNo())) {
            throw new ZTBusinessException("\u5165\u53c2[changeNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

