/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractScopeAddAbilityService;
import com.tydic.contract.ability.bo.ContractQueryScopeAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQueryScopeAbilityRspBO;
import com.tydic.contract.ability.bo.ContractScopeAbilityReqBO;
import com.tydic.contract.ability.bo.ContractScopeAbilityRspBO;
import com.tydic.contract.ability.bo.ContractScopeBO;
import com.tydic.contract.ability.bo.ContractSetScopeAbilityReqBO;
import com.tydic.contract.ability.bo.ContractSetScopeAbilityRspBO;
import com.tydic.contract.busi.ContractScopeAddBusiService;
import com.tydic.contract.busi.bo.ContractPushErpBusiReqBO;
import com.tydic.contract.dao.ContractScopeMapper;
import com.tydic.contract.po.ContractScope;
import com.tydic.umc.general.ability.api.UmcBuyerPermissionRecvAcceptQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryReqBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractScopeAddAbilityService"})
public class ContractScopeAddAbilityServiceImpl
implements ContractScopeAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractScopeAddAbilityServiceImpl.class);
    @Autowired
    private ContractScopeAddBusiService contractScopeAddBusiService;
    @Autowired
    private UmcBuyerPermissionRecvAcceptQryAbilityService umcBuyerPermissionRecvAcceptQryAbilityService;
    @Autowired
    private ContractScopeMapper contractScopeMapper;
    private final int scopeStatusIsOk = 1;
    private final int scopeStatusIsOn = 2;
    @Resource(name="mqContractPushErpProvider")
    private ProxyMessageProducer mqContractPushErpProvider;
    @Value(value="${CONTRACT_PUSH_ERP_TOPIC}")
    private String contractPushErpTopic;
    @Value(value="${CONTRACT_PUSH_ERP_TAG:*}")
    private String contractPushErpTag;

    @PostMapping(value={"addScope"})
    public ContractScopeAbilityRspBO addScope(@RequestBody ContractScopeAbilityReqBO reqBO) {
        ContractScopeAbilityRspBO rspBO = this.contractScopeAddBusiService.addScope(reqBO);
        Long relateId = null;
        relateId = !CollectionUtils.isEmpty((Collection)reqBO.getContractScopeBOS()) ? ((ContractScopeBO)reqBO.getContractScopeBOS().get(0)).getRelateId() : reqBO.getRelateId();
        if (relateId != null) {
            ContractPushErpBusiReqBO contractPushErpBusiReqBO = new ContractPushErpBusiReqBO();
            try {
                contractPushErpBusiReqBO.setPushPlanContractIds(Lists.newArrayList((Object[])new Long[]{relateId}));
                log.info("\u53d1\u9001\u540c\u6b65erp\u6d88\u606f\uff1a" + JSONObject.toJSONString((Object)((Object)contractPushErpBusiReqBO)));
                this.mqContractPushErpProvider.send(new ProxyMessage(this.contractPushErpTopic, this.contractPushErpTag, JSON.toJSONString((Object)((Object)contractPushErpBusiReqBO))));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u540c\u6b65erp\u6d88\u606f\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)((Object)contractPushErpBusiReqBO)));
            }
        }
        return rspBO;
    }

    @PostMapping(value={"setScope"})
    public ContractSetScopeAbilityRspBO setScope(@RequestBody ContractSetScopeAbilityReqBO reqBO) {
        ContractSetScopeAbilityRspBO rspBO = new ContractSetScopeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<ContractScopeBO> contractScopeBOArrList = new ArrayList<ContractScopeBO>();
        UmcBuyerPermissionRecvAcceptQryReqBO umcReq = new UmcBuyerPermissionRecvAcceptQryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)umcReq);
        umcReq.setPageNo(Integer.valueOf(0));
        umcReq.setPageSize(Integer.valueOf(-1));
        umcReq.setErpCode(reqBO.getErpCode());
        umcReq.setBuyerOrgId(reqBO.getBuyerOrgId());
        umcReq.setBuyerOrgName(reqBO.getBuyerOrgName());
        UmcBuyerPermissionRecvAcceptQryRspBO qry = this.umcBuyerPermissionRecvAcceptQryAbilityService.qry(umcReq);
        List<Object> collect = null;
        ContractScope queries = new ContractScope();
        queries.setIsDelete(0);
        queries.setRelateId(reqBO.getRelateId());
        List<ContractScope> contractScopes = this.contractScopeMapper.queryAll(queries);
        List orgCodes = contractScopes.stream().map(ContractScope::getOrgCode).collect(Collectors.toList());
        if ("0000".equals(qry.getRespCode())) {
            List rows = qry.getRows();
            for (UmcBuyerPermissionRecvAcceptBO bo : rows) {
                ContractScopeBO contractScopeBO = new ContractScopeBO();
                contractScopeBO.setOrgCode(bo.getOrgCode());
                contractScopeBO.setOrgId(bo.getOrgId());
                contractScopeBO.setOrgName(bo.getBuyerOrgName());
                contractScopeBO.setExtFiled1(bo.getErpOrgCode());
                if (orgCodes.contains(bo.getOrgCode())) {
                    contractScopeBO.setStatus(Integer.valueOf(1));
                } else {
                    contractScopeBO.setStatus(Integer.valueOf(2));
                }
                contractScopeBOArrList.add(contractScopeBO);
            }
        } else {
            throw new ZTBusinessException(qry.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)reqBO.getStatus())) {
            reqBO.setStatus(Integer.valueOf(0));
        }
        collect = reqBO.getStatus() == 1 ? contractScopeBOArrList.stream().filter(key -> key.getStatus() == 1).collect(Collectors.toList()) : (reqBO.getStatus() == 2 ? contractScopeBOArrList.stream().filter(key -> key.getStatus() == 2).collect(Collectors.toList()) : contractScopeBOArrList);
        if (reqBO.getPageSize() == -1) {
            rspBO.setRows(collect);
        } else {
            rspBO.setRows(collect.stream().sorted(Comparator.comparing(ContractScopeBO::getOrgId)).skip((reqBO.getPageNo() - 1) * reqBO.getPageSize()).limit(reqBO.getPageSize().intValue()).collect(Collectors.toList()));
        }
        rspBO.setRecordsTotal(Integer.valueOf(collect.size()));
        return rspBO;
    }

    @PostMapping(value={"queryScope"})
    public ContractQueryScopeAbilityRspBO queryScope(@RequestBody ContractQueryScopeAbilityReqBO reqBO) {
        ContractQueryScopeAbilityRspBO rspBO = new ContractQueryScopeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ContractScope contractScope = new ContractScope();
        contractScope.setRelateId(reqBO.getRelateId());
        contractScope.setIsDelete(0);
        List<ContractScope> contractScopes = this.contractScopeMapper.queryAll(contractScope);
        List collect = contractScopes.stream().sorted(Comparator.comparing(ContractScope::getOrgId)).skip((reqBO.getPageNo() - 1) * reqBO.getPageSize()).limit(reqBO.getPageSize().intValue()).collect(Collectors.toList());
        rspBO.setRows(collect);
        rspBO.setRecordsTotal(Integer.valueOf(contractScopes.size()));
        return rspBO;
    }
}

