/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractDownloadSignDocumentAbilityService;
import com.tydic.contract.ability.ContractSyncSignatureAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractInfoPushNewWealthBO;
import com.tydic.contract.ability.bo.ContractSyncSignatureAbilityReqBO;
import com.tydic.contract.ability.bo.ContractSyncSignatureAbilityRspBO;
import com.tydic.contract.ability.impl.ContractSyncSignatureThread;
import com.tydic.contract.atom.ContractPurchaseSyncSaleContractAtomiService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.InterFaceContractFzSyncService;
import com.tydic.contract.atom.InterFaceContractGetEnvelopesDetailAtomService;
import com.tydic.contract.atom.InterFaceContractSignAccessTokenCreateAtomService;
import com.tydic.contract.busi.ContractSignPushLegalBusiService;
import com.tydic.contract.busi.ContractSyncSignatureBusiService;
import com.tydic.contract.busi.bo.ContractSyncSignatureBusiReqBO;
import com.tydic.contract.busi.bo.ContractSyncSignatureBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractSignFileMapper;
import com.tydic.contract.dao.CContractSignInitiatorInfoMapper;
import com.tydic.contract.dao.CContractSignOperLogMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOperateNodeRecordMapper;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractSignInitiatorInfoPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.uoc.common.ability.api.UocExtensionOfflineContractSyncAbilityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractSyncSignatureAbilityService"})
public class ContractSyncSignatureAbilityServiceImpl
implements ContractSyncSignatureAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractSyncSignatureAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private InterFaceContractGetEnvelopesDetailAtomService interFaceContractGetEnvelopesDetailAtomService;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Resource(name="syncContractFreezeStatusProvider")
    private ProxyMessageProducer syncContractFreezeStatusProvider;
    @Autowired
    private CContractAgrMapper cContractAgrMapper;
    @Value(value="${CONTRACT_FREEZE_SYNC_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_FREEZE_SYNC_TAG}")
    private String tag;
    @Autowired
    private InterFaceContractSignAccessTokenCreateAtomService interFaceContractSignAccessTokenCreateAtomService;
    @Autowired
    private ContractDownloadSignDocumentAbilityService contractDownloadSignDocumentAbilityService;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private InterFaceContractFzSyncService interFaceContractFzSyncService;
    @Autowired
    private ContractOperateNodeRecordMapper contractOperateNodeRecordMapper;
    @Autowired
    private CContractSignInitiatorInfoMapper cContractSignInitiatorInfoMapper;
    @Autowired
    private CContractSignOperLogMapper contractSignOperLogMapper;
    @Resource(name="mqContractPushErpProvider")
    private ProxyMessageProducer mqContractPushErpProvider;
    @Value(value="${CONTRACT_PUSH_ERP_TOPIC}")
    private String contractPushErpTopic;
    @Value(value="${CONTRACT_PUSH_ERP_TAG:*}")
    private String contractPushErpTag;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planDiversionSyncTag;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private ContractPurchaseSyncSaleContractAtomiService contractPurchaseSyncSaleContractAtomiService;
    @Autowired
    private ContractSignPushLegalBusiService contractSignPushLegalBusiService;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;
    @Autowired
    private CContractSignFileMapper cContractSignFileMapper;
    @Resource(name="pushNewWealthProvider")
    private ProxyMessageProducer pushNewWealthProvider;
    @Value(value="${PUSH_NEW_WEALTH_TOPIC:PUSH_NEW_WEALTH_TOPIC}")
    private String PUSH_NEW_WEALTH_TOPIC;
    @Value(value="${PUSH_NEW_WEALTH_TAG:*}")
    private String PUSH_NEW_WEALTH_TAG;
    @Autowired
    private ContractSyncSignatureBusiService contractSyncSignatureBusiService;
    @Value(value="${SIGNATURE_EFFECT_PUSH_LEGAL:0}")
    private String SIGNATURE_EFFECT_PUSH_LEGAL;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private UocExtensionOfflineContractSyncAbilityService uocExtensionOfflineContractSyncAbilityService;
    @Autowired
    private CContractInfoExtMapper contractInfoExtMapper;
    @Resource(name="znhtAutoOrderProvider")
    private ProxyMessageProducer znhtAutoOrderProvider;
    @Value(value="${ZNHT_AUTO_ORDER_TOPIC:ZNHT_AUTO_ORDER_TOPIC}")
    private String ZNHT_AUTO_ORDER_TOPIC;
    @Value(value="${ZNHT_AUTO_ORDER_TAG:*}")
    private String ZNHT_AUTO_ORDER_TAG;
    @Resource(name="planAddContractQtyMsgProvider")
    private ProxyMessageProducer planAddContractQtyMsgProvider;
    @Value(value="${PLAN_ADD_CONTRACT_QTY_TOPIC:PLAN_ADD_CONTRACT_QTY_TOPIC}")
    private String planAddContractQtyTopic;
    @Value(value="${PLAN_ADD_CONTRACT_QTY_TAG:*}")
    private String planAddContractQtyTag;

    @PostMapping(value={"contractSyncSignature"})
    public ContractSyncSignatureAbilityRspBO contractSyncSignature(@RequestBody ContractSyncSignatureAbilityReqBO reqBO) {
        ContractSyncSignatureAbilityRspBO rspBO = new ContractSyncSignatureAbilityRspBO();
        ContractInfoPO searchPO = new ContractInfoPO();
        ArrayList<Integer> contractStatusList = new ArrayList<Integer>();
        contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE);
        contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE);
        contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_THIRD_PARTY_WAIT_SIGNATURE);
        searchPO.setContractStatusList(contractStatusList);
        searchPO.setIsProcess(0);
        List<ContractInfoPO> pos = this.contractInfoMapper.getList(searchPO);
        pos = pos.stream().filter(e -> e.getEnvelopeId() != null && !StringUtils.isEmpty((Object)e.getSignInitiatorInfoSocCreCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pos)) {
            Set collect = pos.stream().map(ContractInfoPO::getSignInitiatorInfoSocCreCode).collect(Collectors.toSet());
            ArrayList<String> socCreCodes = new ArrayList<String>(collect);
            List<CContractSignInitiatorInfoPO> signInitiatorInfoPOS = this.cContractSignInitiatorInfoMapper.selectBySocCreCodes(socCreCodes);
            if (CollectionUtils.isEmpty(signInitiatorInfoPOS)) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a\u53d1\u8d77\u65b9\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a\uff01");
            }
            Map<String, List<CContractSignInitiatorInfoPO>> socCreCodeMap = signInitiatorInfoPOS.stream().collect(Collectors.groupingBy(CContractSignInitiatorInfoPO::getSocCreCode));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            String format = sdf.format(new Date());
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-contract_sync_signature-" + format).build();
            ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(3, 8, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
            long start = System.currentTimeMillis();
            log.info("\u65f6\u95f4" + format + "\u5f00\u59cb\u7684\u5408\u540c\u540c\u6b65\u7b7e\u7ae0\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb,\u5904\u7406\u6570\u636e\u7684\u6761\u6570:" + pos.size());
            List<Long> contractIds = pos.stream().map(ContractInfoPO::getContractId).collect(Collectors.toList());
            ContractSyncSignatureBusiReqBO busiReqBO = new ContractSyncSignatureBusiReqBO();
            busiReqBO.setContractIds(contractIds);
            ContractSyncSignatureBusiRspBO busiRspBO = this.contractSyncSignatureBusiService.updateContractIsProcess(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new ZTBusinessException("\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001\u5931\u8d25" + busiRspBO.getRespDesc());
            }
            for (ContractInfoPO po : pos) {
                if (po.getEnvelopeId() == null || StringUtils.isEmpty((Object)po.getSignInitiatorInfoSocCreCode())) continue;
                if (!socCreCodeMap.keySet().contains(po.getSignInitiatorInfoSocCreCode())) {
                    log.error("\u5408\u540cid\uff1a" + po.getContractId() + "\u5bf9\u5e94\u53d1\u8d77\u65b9\u4fe1\u606f\u6ca1\u6709\u67e5\u8be2\u5230");
                    continue;
                }
                CContractSignInitiatorInfoPO signInitiatorInfoPO = socCreCodeMap.get(po.getSignInitiatorInfoSocCreCode()).get(0);
                if (StringUtils.isEmpty((Object)signInitiatorInfoPO.getClientId()) || StringUtils.isEmpty((Object)signInitiatorInfoPO.getSecret())) {
                    log.error("\u5408\u540cid\uff1a" + po.getContractId() + "\u5bf9\u5e94\u53d1\u8d77\u65b9\u4fe1\u606f\u4e2d\u7684\u5e94\u7528(clientId&&secret)\u4e3a\u7a7a");
                    continue;
                }
                ContractSyncSignatureThread signatureThread = new ContractSyncSignatureThread();
                signatureThread.setContractId(po.getContractId());
                signatureThread.setEnvelopeId(po.getEnvelopeId());
                signatureThread.setContractAccessoryMapper(this.contractAccessoryMapper);
                signatureThread.setContractInfoMapper(this.contractInfoMapper);
                signatureThread.setContractInfoItemMapper(this.contractInfoItemMapper);
                signatureThread.setInterFaceContractGetEnvelopesDetailAtomService(this.interFaceContractGetEnvelopesDetailAtomService);
                signatureThread.setInterFaceContractFzSyncService(this.interFaceContractFzSyncService);
                signatureThread.setcContractAgrMapper(this.cContractAgrMapper);
                signatureThread.setSyncContractFreezeStatusProvider(this.syncContractFreezeStatusProvider);
                signatureThread.setTag(this.tag);
                signatureThread.setTopic(this.topic);
                signatureThread.setContractStatus(po.getContractStatus());
                signatureThread.setSignatureSort(po.getSignatureSort());
                signatureThread.setInterFaceContractSignAccessTokenCreateAtomService(this.interFaceContractSignAccessTokenCreateAtomService);
                signatureThread.setContractDownloadSignDocumentAbilityService(this.contractDownloadSignDocumentAbilityService);
                signatureThread.setContractRecordContractNodeOperLogAtomService(this.contractRecordContractNodeOperLogAtomService);
                signatureThread.setContractOperateNodeRecordMapper(this.contractOperateNodeRecordMapper);
                signatureThread.setClientId(signInitiatorInfoPO.getClientId());
                signatureThread.setSecret(signInitiatorInfoPO.getSecret());
                signatureThread.setContractSignOperLogMapper(this.contractSignOperLogMapper);
                signatureThread.setBuyerNo(po.getBuyerNo());
                signatureThread.setBuyerName(po.getBuyerName());
                signatureThread.setSupplierId(po.getSupplierId());
                signatureThread.setSupplierName(po.getSupplierName());
                signatureThread.setPushErpFlag(po.getPushErpFlag());
                signatureThread.setMqContractPushErpProvider(this.mqContractPushErpProvider);
                signatureThread.setContractPushErpTopic(this.contractPushErpTopic);
                signatureThread.setContractPushErpTag(this.contractPushErpTag);
                signatureThread.setContractType(po.getContractType());
                signatureThread.setValidaNum(po.getValidaNum());
                signatureThread.setValidaType(po.getValidaType());
                signatureThread.setMultiDealerCode(po.getMultiDealerCode());
                signatureThread.setMultiDealerName(po.getMultiDealerName());
                signatureThread.setContractInfoItemMapper(this.contractInfoItemMapper);
                signatureThread.setPlanDiversionSyncMsgProvider(this.planDiversionSyncMsgProvider);
                signatureThread.setPlanDiversionSyncTopic(this.planDiversionSyncTopic);
                signatureThread.setPlanDiversionSyncTag(this.planDiversionSyncTag);
                signatureThread.setcRelBuySaleContractMapper(this.cRelBuySaleContractMapper);
                signatureThread.setContractPurchaseSyncSaleContractAtomiService(this.contractPurchaseSyncSaleContractAtomiService);
                signatureThread.setContractInfoItemMapper(this.contractInfoItemMapper);
                signatureThread.setPlanDiversionSyncMsgProvider(this.planDiversionSyncMsgProvider);
                signatureThread.setPlanDiversionSyncTopic(this.planDiversionSyncTopic);
                signatureThread.setPlanDiversionSyncTag(this.planDiversionSyncTag);
                signatureThread.setContractInfoChangeMapper(this.contractInfoChangeMapper);
                signatureThread.setContractSignPushLegalBusiService(this.contractSignPushLegalBusiService);
                signatureThread.setContractPushLogMapper(this.contractPushLogMapper);
                signatureThread.setSignatureEffectPushlegal(this.SIGNATURE_EFFECT_PUSH_LEGAL);
                signatureThread.setcContractSignFileMapper(this.cContractSignFileMapper);
                signatureThread.setContractDetailQueryAbilityService(this.contractDetailQueryAbilityService);
                signatureThread.setUocExtensionOfflineContractSyncAbilityService(this.uocExtensionOfflineContractSyncAbilityService);
                signatureThread.setPlanAddContractQtyMsgProvider(this.planAddContractQtyMsgProvider);
                signatureThread.setPlanAddContractQtyTopic(this.planAddContractQtyTopic);
                signatureThread.setPlanAddContractQtyTag(this.planAddContractQtyTag);
                fixedThreadPool.submit(signatureThread);
            }
            fixedThreadPool.shutdown();
            while (true) {
                if (fixedThreadPool.isTerminated()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage());
                }
            }
            log.debug("\u65f6\u95f4" + format + "\u5f00\u59cb\u7684\u5408\u540c\u540c\u6b65\u7b7e\u7ae0\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
            this.sendZnHT(pos);
            this.sendNewfinance(pos);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendNewfinance(List<ContractInfoPO> pos) {
        ContractInfoPO searchPO1 = new ContractInfoPO();
        searchPO1.setContractIds(pos.stream().map(obj -> obj.getContractId()).collect(Collectors.toList()));
        searchPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        searchPO1.setIsProcess(2);
        List<ContractInfoPO> contractInfoPOList = this.contractInfoMapper.getList(searchPO1);
        if (!CollectionUtils.isEmpty(contractInfoPOList)) {
            contractInfoPOList.forEach(obj -> {
                Set checkOrderIds;
                List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.selectByContractIds(Lists.newArrayList((Object[])new Long[]{obj.getContractId()}));
                if (!CollectionUtils.isEmpty(contractInfoItemPOS) && !(checkOrderIds = contractInfoItemPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrderId())).map(e -> e.getOrderId()).collect(Collectors.toSet())).isEmpty()) {
                    ContractInfoPushNewWealthBO pushNewWealthBO = new ContractInfoPushNewWealthBO();
                    pushNewWealthBO.setContractId(obj.getContractId());
                    pushNewWealthBO.setContractNo(obj.getContractNo());
                    pushNewWealthBO.setPurchaserUnitId(obj.getPurchaserUnitId());
                    pushNewWealthBO.setOrderIds(new ArrayList(checkOrderIds));
                    log.info("\u7535\u5b50\u7b7e\u7ae0\u8865\u5f55\u5408\u540c\u751f\u6548\u63a8\u9001\u65b0\u4e1a\u8d22\u6d88\u606f{}", (Object)JSON.toJSONString((Object)pushNewWealthBO));
                    this.pushNewWealthProvider.send(new ProxyMessage(this.PUSH_NEW_WEALTH_TOPIC, this.PUSH_NEW_WEALTH_TAG, JSON.toJSONString((Object)pushNewWealthBO)));
                }
            });
        }
    }

    private void sendZnHT(List<ContractInfoPO> pos) {
        List<Long> ids = pos.stream().filter(x -> ContractConstant.BusinessType.SELF_PURCHASE.equals(x.getBusinessType())).map(obj -> obj.getContractId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        CContractInfoExtPO searchPO = new CContractInfoExtPO();
        searchPO.setRelateIds(ids);
        searchPO.setExtField3("1");
        List<CContractInfoExtPO> contractInfoExtPOS = this.contractInfoExtMapper.getList(searchPO);
        if (CollectionUtils.isEmpty(contractInfoExtPOS)) {
            return;
        }
        CompletableFuture.runAsync(() -> contractInfoExtPOS.forEach(x -> {
            try {
                ContractDetailQueryAbilityReqBO detailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
                detailQueryAbilityReqBO.setContractId(x.getRelateId());
                ContractDetailQueryAbilityRspBO detailRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(detailQueryAbilityReqBO);
                log.info("\u5408\u540cid\uff1a{}\uff0c\u63a8\u9001\u804c\u80fd\u5408\u540c\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)x.getRelateId(), (Object)JSON.toJSONString((Object)detailRspBO));
                this.znhtAutoOrderProvider.send(new ProxyMessage(this.ZNHT_AUTO_ORDER_TOPIC, this.ZNHT_AUTO_ORDER_TAG, JSON.toJSONString((Object)detailRspBO)));
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u804c\u80fd\u5408\u540c\u81ea\u52a8\u751f\u6210\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
            }
        }));
    }
}

