/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.SaeQueryContractInfoPageService;
import com.tydic.contract.ability.bo.ContractListNewBO;
import com.tydic.contract.ability.bo.ContractQryListNewabilityRspBO;
import com.tydic.contract.ability.bo.ContractQryListSaeAbilityReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoNewPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionRspBo;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.SaeQueryContractInfoPageService"})
public class SaeQueryContractInfoPageServiceImpl
implements SaeQueryContractInfoPageService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;

    @PostMapping(value={"queryContractInfoPage"})
    public ContractQryListNewabilityRspBO queryContractInfoPage(@RequestBody ContractQryListSaeAbilityReqBO reqBO) {
        ContractQryListNewabilityRspBO rspBO = new ContractQryListNewabilityRspBO();
        ContractInfoNewPO infoPO = (ContractInfoNewPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractInfoNewPO.class);
        List<String> dealAuth = this.dealAuth(reqBO.getIsAdmin(), reqBO.getUsername());
        if (null == dealAuth) {
            infoPO.setCreateUserId(reqBO.getUserId());
        } else {
            infoPO.setOrgCodeAuthList(dealAuth);
        }
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.getListSaePage(infoPO));
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List result = page.getResult();
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)result), ContractListNewBO.class);
        rows.forEach(item -> {
            if (item.getContractStatus() != null) {
                item.setContractStatusStr(ContractTransFieldUtil.transContractStatus(item.getContractStatus()));
            }
            if (item.getContractType() != null) {
                item.setContractTypeStr(ContractTransFieldUtil.transContractType(item.getContractType()));
            }
            if (item.getMaterialCategory() != null) {
                item.setMaterialCategoryStr(ContractTransFieldUtil.SaeTypeEnum.getCodeDesc(item.getMaterialCategory()));
            }
            if (null == item.getEvaluateFinishStatus()) {
                item.setEvaluateFinishStatus(ContractConstant.MaterialCategoryEnum.MODELSTATUS0.getCode());
            }
            if (item.getEvaluateFinishStatus() != null) {
                item.setEvaluateFinishStatusStr(ContractConstant.MaterialCategoryEnum.getValueByCode(item.getEvaluateFinishStatus()));
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }

    @PostMapping(value={"queryContractInfoCount"})
    public ContractQryListNewabilityRspBO queryContractInfoCount(@RequestBody ContractQryListSaeAbilityReqBO reqBO) {
        ContractQryListNewabilityRspBO rspBO = new ContractQryListNewabilityRspBO();
        ContractInfoNewPO infoPO = (ContractInfoNewPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractInfoNewPO.class);
        List<String> dealAuth = this.dealAuth(reqBO.getIsAdmin(), reqBO.getUsername());
        if (null == dealAuth) {
            infoPO.setCreateUserId(reqBO.getUserId());
        } else {
            infoPO.setOrgCodeAuthList(dealAuth);
        }
        int count = this.contractInfoMapper.getListSaeCount(infoPO);
        rspBO.setCount(Integer.valueOf(count));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<String> dealAuth(Integer isAdmin, String erpCode) {
        List<String> orgCodeAuthList;
        if (!ContractConstant.DicDelFlag.YES.equals(isAdmin)) {
            DycUmcQueryOrgPermissionReqBo orgPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
            orgPermissionReqBo.setPageFlag(false);
            orgPermissionReqBo.setErpCode(erpCode);
            DycUmcQueryOrgPermissionRspBo permissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermissionCtFast(orgPermissionReqBo);
            if (!"0000".equals(permissionRspBo.getRespCode())) {
                throw new ZTBusinessException("\u5355\u4f4d\u6743\u9650\u67e5\u8be2\u5931\u8d25\uff1a" + permissionRspBo.getRespDesc());
            }
            orgCodeAuthList = CollectionUtil.isNotEmpty((Collection)permissionRspBo.getOrgInfos()) ? permissionRspBo.getOrgInfos().stream().map(UmcEnterpriseOrgBO::getOrgCode).filter(StrUtil::isNotEmpty).distinct().collect(Collectors.toList()) : null;
        } else {
            orgCodeAuthList = new ArrayList<String>();
        }
        return orgCodeAuthList;
    }
}

