/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl.other;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.ability.bo.other.ContractModelInsertAbitilyReqBO;
import com.tydic.contract.ability.bo.other.ContractModelQryDetailAbilityReqBO;
import com.tydic.contract.ability.bo.other.ContractModelQryDetailAbilityRspBO;
import com.tydic.contract.ability.bo.other.ContractModelQryListAbilityReqBO;
import com.tydic.contract.ability.bo.other.ContractModelQryListAbilityRspBO;
import com.tydic.contract.ability.bo.other.ContractModelQryListBO;
import com.tydic.contract.ability.bo.other.ContractModelUpdateAbilityReqBO;
import com.tydic.contract.ability.other.ContractModelAbilityService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractModelMapper;
import com.tydic.contract.dao.SysDicDictionaryMapper;
import com.tydic.contract.po.CContractModelPO;
import com.tydic.contract.po.SysDicDictionaryPO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.other.ContractModelAbilityService"})
public class ContractModelAbilityServiceImpl
implements ContractModelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractModelAbilityServiceImpl.class);
    @Autowired
    private CContractModelMapper cContractModelMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @PostMapping(value={"insertContractModel"})
    public ContractRspBaseBO insertContractModel(@RequestBody ContractModelInsertAbitilyReqBO reqBO) {
        log.info("\u65b0\u589e\u5408\u540c\u8303\u672c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getBusinessCategory()) || StringUtils.isEmpty((Object)reqBO.getModelName()) || StringUtils.isEmpty((Object)reqBO.getModelUrl())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CContractModelPO cContractModelPO = this.cContractModelMapper.selectByPrimaryModelName(reqBO.getModelName());
        if (cContractModelPO != null) {
            throw new ZTBusinessException("\u8303\u672c\u540d\u79f0\u91cd\u590d");
        }
        CContractModelPO insertPo = new CContractModelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)insertPo);
        insertPo.setUuid(Sequence.getInstance().nextId());
        insertPo.setModelVersion(1);
        insertPo.setCreateTime(new Date());
        insertPo.setCreateUserId(reqBO.getUserId());
        insertPo.setCreateUserName(reqBO.getName());
        insertPo.setUpdateTime(new Date());
        insertPo.setUpdateUserId(reqBO.getUserId());
        insertPo.setUpdateUserName(reqBO.getName());
        this.cContractModelMapper.insertSelective(insertPo);
        return rspBaseBO;
    }

    @PostMapping(value={"qryContractModelDetail"})
    public ContractModelQryDetailAbilityRspBO qryContractModelDetail(@RequestBody ContractModelQryDetailAbilityReqBO reqBO) {
        ContractModelQryDetailAbilityRspBO rspBO = new ContractModelQryDetailAbilityRspBO();
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getModelId()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CContractModelPO cContractModelPO = this.cContractModelMapper.selectByPrimaryKey(reqBO.getModelId());
        if (cContractModelPO == null) {
            return rspBO;
        }
        BeanUtils.copyProperties((Object)cContractModelPO, (Object)rspBO);
        Map<Object, Object> contractModelBusinessCategoryMap = new HashMap();
        List<SysDicDictionaryPO> contractModelBusinessCategory = this.sysDicDictionaryMapper.selectByPCode("CONTRACT_MODEL_BUSINESS_CATEGORY");
        if (contractModelBusinessCategory != null) {
            contractModelBusinessCategoryMap = contractModelBusinessCategory.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
        }
        rspBO.setModelStatusStr(ContractConstant.ContractModelStatusEnum.getValueByCode(cContractModelPO.getModelStatus()));
        rspBO.setBusinessCategoryStr((String)contractModelBusinessCategoryMap.get(String.valueOf(cContractModelPO.getBusinessCategory())));
        return rspBO;
    }

    @PostMapping(value={"updateContractModel"})
    public ContractRspBaseBO updateContractModel(@RequestBody ContractModelUpdateAbilityReqBO reqBO) {
        log.info("\u4fee\u6539\u5408\u540c\u8303\u672c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getModelId() == null || StringUtils.isEmpty((Object)reqBO.getModelName()) || StringUtils.isEmpty((Object)reqBO.getModelUrl())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CContractModelPO cContractModelPO = this.cContractModelMapper.selectByPrimaryModelName(reqBO.getModelName());
        if (cContractModelPO != null && !cContractModelPO.getModelId().equals(reqBO.getModelId())) {
            throw new ZTBusinessException("\u8303\u672c\u540d\u79f0\u5df2\u5b58\u5728");
        }
        CContractModelPO contractModelPO1 = this.cContractModelMapper.selectByPrimaryKey(reqBO.getModelId());
        if (contractModelPO1 == null) {
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25\uff0c\u8303\u672c\u4e0d\u5b58\u5728");
        }
        CContractModelPO updatePO = new CContractModelPO();
        updatePO.setModelStatus(ContractConstant.ContractModelStatusEnum.MODELSTATUS1.getCode());
        updatePO.setModelId(reqBO.getModelId());
        this.cContractModelMapper.updateByPrimaryKeySelective(updatePO);
        CContractModelPO insertPO = new CContractModelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)insertPO);
        insertPO.setUuid(contractModelPO1.getUuid());
        insertPO.setModelStatus(ContractConstant.ContractModelStatusEnum.MODELSTATUS0.getCode());
        insertPO.setModelVersion(contractModelPO1.getModelVersion() + 1);
        insertPO.setCreateTime(new Date());
        insertPO.setCreateUserId(reqBO.getUserId());
        insertPO.setCreateUserName(reqBO.getName());
        insertPO.setUpdateTime(new Date());
        insertPO.setUpdateUserId(reqBO.getUserId());
        insertPO.setUpdateUserName(reqBO.getName());
        insertPO.setUpdateDesc(reqBO.getUpdateDesc());
        this.cContractModelMapper.insertSelective(insertPO);
        return rspBaseBO;
    }

    @PostMapping(value={"qryListContractModel"})
    public ContractModelQryListAbilityRspBO qryListContractModel(@RequestBody ContractModelQryListAbilityReqBO reqBO) {
        log.info("\u4fee\u6539\u5408\u540c\u8303\u672c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        ContractModelQryListAbilityRspBO rspBO = new ContractModelQryListAbilityRspBO();
        CContractModelPO qryPo = new CContractModelPO();
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u9875\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getTabId().toString())) {
            if (reqBO.getUuid() == null) {
                throw new ZTBusinessException("\u67e5\u8be2\u66f4\u65b0\u5185\u5bb9uuid\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            reqBO.setPageSize(Integer.valueOf(100));
        } else {
            qryPo.setModelStatus(ContractConstant.ContractModelStatusEnum.MODELSTATUS0.getCode());
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)qryPo);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.cContractModelMapper.getList(qryPo));
        List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)page), ContractModelQryListBO.class);
        Map<Object, Object> contractModelBusinessCategoryMap = new HashMap();
        List<SysDicDictionaryPO> contractModelBusinessCategory = this.sysDicDictionaryMapper.selectByPCode("CONTRACT_MODEL_BUSINESS_CATEGORY");
        if (contractModelBusinessCategory != null) {
            contractModelBusinessCategoryMap = contractModelBusinessCategory.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
        }
        for (ContractModelQryListBO r : rows) {
            r.setBusinessCategoryStr((String)contractModelBusinessCategoryMap.get(String.valueOf(r.getBusinessCategory())));
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        return rspBO;
    }

    @PostMapping(value={"deleteContractModel"})
    public ContractRspBaseBO deleteContractModel(@RequestBody ContractModelQryDetailAbilityReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getModelId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CContractModelPO deletePO = new CContractModelPO();
        deletePO.setModelStatus(ContractConstant.ContractModelStatusEnum.MODELSTATUS2.getCode());
        deletePO.setModelId(reqBO.getModelId());
        deletePO.setUpdateTime(new Date());
        deletePO.setUpdateUserId(reqBO.getUserId());
        deletePO.setUpdateUserName(reqBO.getName());
        this.cContractModelMapper.updateByPrimaryKeySelective(deletePO);
        return rspBaseBO;
    }
}

