/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.file.fastdfs.FastdfsUtil;
import com.tydic.contract.atom.ContractUploadByteFileAtomService;
import com.tydic.contract.atom.bo.ContractUploadByteFileAtomReqBo;
import com.tydic.contract.atom.bo.ContractUploadByteFileAtomRspBo;
import com.tydic.contract.utils.ExportExcel;
import com.tydic.uac.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractUploadByteFileAtomServiceImpl
implements ContractUploadByteFileAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractUploadByteFileAtomServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FastdfsConfig fastdfsConfig;

    @Override
    public ContractUploadByteFileAtomRspBo uploadByteFile(ContractUploadByteFileAtomReqBo reqBo) {
        String fileUrl;
        String path;
        this.validateParams(reqBo);
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(reqBo.getFileBytes());
             ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(reqBo.getFileBytes());){
            if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fileInfo = FastdfsUtil.uploadFile((String)reqBo.getFileName(), (FastdfsConfig)this.fastdfsConfig, (InputStream)byteArrayInputStream, (String)("dyc-common/" + fileDir));
                path = FastdfsFileInfo.toFilePath((FastdfsFileInfo)fileInfo);
            } else {
                path = this.fileClient.uploadFileByInputStream("dyc-common/" + fileDir, reqBo.getFileName(), (InputStream)inputStream);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u62a5\u9519\uff1a", (Throwable)e);
            throw new BusinessException("8888", "\u6587\u4ef6\u4e0a\u4f20\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if ("OSS".equals(this.fileType)) {
            fileUrl = this.ossFileUrl + path;
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            if (Objects.isNull(fastdfsFileInfo.getFileName()) || Objects.isNull(fastdfsFileInfo.getGroupName()) || "null".equals(fastdfsFileInfo.getFileName()) || "null".equals(fastdfsFileInfo.getGroupName())) {
                throw new BusinessException("8888", "\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new BusinessException("8888", "\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        ContractUploadByteFileAtomRspBo rspBo = new ContractUploadByteFileAtomRspBo();
        rspBo.setFileUrl(fileUrl);
        rspBo.setFileSize(reqBo.getFileBytes().length);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public ContractUploadByteFileAtomRspBo uploadByWorkbook(ContractUploadByteFileAtomReqBo reqBo) {
        byte[] bytes;
        long time = new Date().getTime();
        Workbook discountRateModifyTemplateWorkbook = ExportExcel.createWorkbook(reqBo.getDataList());
        log.info("\u521b\u5efaexcel\u8017\u65f6\uff1a{}", (Object)(new Date().getTime() - time));
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            discountRateModifyTemplateWorkbook.write((OutputStream)byteArrayOutputStream);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new BusinessException("8888", "Workbook\u8f6cbyte\u5f02\u5e38");
        }
        try {
            discountRateModifyTemplateWorkbook.close();
        }
        catch (IOException e) {
            throw new BusinessException("8888", "Workbook\u5173\u95ed\u5f02\u5e38");
        }
        ContractUploadByteFileAtomReqBo uploadByteFileAtomReqBo = new ContractUploadByteFileAtomReqBo();
        uploadByteFileAtomReqBo.setFileName(reqBo.getFileName());
        uploadByteFileAtomReqBo.setFileBytes(bytes);
        return this.uploadByteFile(uploadByteFileAtomReqBo);
    }

    private void validateParams(ContractUploadByteFileAtomReqBo reqBo) {
        if (null == reqBo) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getFileName())) {
            throw new BusinessException("8888", "\u5165\u53c2fileName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getFileBytes() || reqBo.getFileBytes().length == 0) {
            throw new BusinessException("8888", "\u5165\u53c2fileBytes\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

