/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.tydic.contract.busi.ContractOperTemplateBusiService;
import com.tydic.contract.busi.bo.ContractOperTemplateBusiReqBO;
import com.tydic.contract.busi.bo.ContractOperTemplateBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractTemplateMapper;
import com.tydic.contract.po.ContractTemplatePo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractOperTemplateBusiServiceImpl
implements ContractOperTemplateBusiService {
    @Autowired
    private ContractTemplateMapper contractTemplateMapper;

    @Override
    public ContractOperTemplateBusiRspBO updateTemplate(ContractOperTemplateBusiReqBO reqBO) {
        ContractTemplatePo contractTemplatePo;
        ContractOperTemplateBusiRspBO rspBO = new ContractOperTemplateBusiRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u64cd\u4f5c\u5408\u540c\u6761\u6b3e\u63a5\u53e3\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getContractTemplateIdList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getTemplateOperType()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<ContractTemplatePo> templatePos = this.contractTemplateMapper.getListBytemplateIds(reqBO.getContractTemplateIdList());
        if (CollectionUtils.isEmpty(templatePos) || reqBO.getContractTemplateIdList().size() != templatePos.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5408\u540c\u6a21\u677f");
            return rspBO;
        }
        if (reqBO.getTemplateOperType().equals(1)) {
            List templatePoList = templatePos.stream().filter(t -> t.getValidStatus().equals(1)).collect(Collectors.toList());
            if (templatePos.size() != templatePoList.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5408\u540c\u6a21\u677f\u6709\u72b6\u6001\u4e0d\u4e3a\u8349\u7a3f\u72b6\u6001\uff01");
                return rspBO;
            }
            for (ContractTemplatePo po : templatePoList) {
                contractTemplatePo = new ContractTemplatePo();
                contractTemplatePo.setTemplateId(po.getTemplateId());
                contractTemplatePo.setValidStatus(ContractConstant.ContractTemplateValidStatus.DISABLE);
                contractTemplatePo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                contractTemplatePo.setUpdateUserId(reqBO.getMemIdIn());
                contractTemplatePo.setUpdateUserName(reqBO.getName());
                this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplatePo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        if (reqBO.getTemplateOperType().equals(2)) {
            List poList = templatePos.stream().filter(t -> t.getValidStatus().equals(3)).collect(Collectors.toList());
            if (templatePos.size() != poList.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5408\u540c\u6a21\u677f\u6709\u72b6\u6001\u4e0d\u4e3a\u5df2\u53d1\u5e03\u72b6\u6001\uff01");
                return rspBO;
            }
            for (ContractTemplatePo po : poList) {
                contractTemplatePo = new ContractTemplatePo();
                contractTemplatePo.setTemplateId(po.getTemplateId());
                contractTemplatePo.setValidStatus(ContractConstant.ContractTemplateValidStatus.DRAFT);
                contractTemplatePo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                contractTemplatePo.setUpdateUserId(reqBO.getMemIdIn());
                contractTemplatePo.setUpdateUserName(reqBO.getName());
                this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplatePo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }
}

