/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractPlanMatchingAgreementInfoBO;
import com.tydic.contract.busi.ContractPlanMatchingAgreementQryListBusiService;
import com.tydic.contract.busi.bo.ContractPlanMatchingAgreementQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractPlanMatchingAgreementQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.umc.general.ability.api.UmcEntityOrgBuyerQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEntityOrgBuyerQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgBuyerQryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractPlanMatchingAgreementQryListBusiServiceImpl
implements ContractPlanMatchingAgreementQryListBusiService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEntityOrgBuyerQryAbilityService umcEntityOrgBuyerQryAbilityService;

    @Override
    public ContractPlanMatchingAgreementQryListBusiRspBO qryPlanMatchingAgreementList(ContractPlanMatchingAgreementQryListBusiReqBO reqBO) {
        ContractPlanMatchingAgreementQryListBusiRspBO rspBO = new ContractPlanMatchingAgreementQryListBusiRspBO();
        UmcEntityOrgBuyerQryAbilityReqBO umcEntityOrgBuyerQryAbilityReqBO = new UmcEntityOrgBuyerQryAbilityReqBO();
        umcEntityOrgBuyerQryAbilityReqBO.setErpOrgCode(reqBO.getErpOrgId());
        UmcEntityOrgBuyerQryAbilityRspBO umcEntityOrgBuyerQryAbilityRspBO = this.umcEntityOrgBuyerQryAbilityService.qryBuyer(umcEntityOrgBuyerQryAbilityReqBO);
        if ("0000".equals(umcEntityOrgBuyerQryAbilityRspBO.getRespCode())) {
            if (CollectionUtils.isEmpty((Collection)umcEntityOrgBuyerQryAbilityRspBO.getOrgCodes())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u4e70\u53d7\u4eba\u4e3a\u7a7a!");
                rspBO.setRows(null);
                rspBO.setPageNo(1);
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            ContractInfoPO queryContractPo = new ContractInfoPO();
            List orgCodes = umcEntityOrgBuyerQryAbilityRspBO.getOrgCodes();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryContractPo);
            ArrayList<Integer> contractTypes = new ArrayList<Integer>();
            contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
            contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
            queryContractPo.setContractTypes(contractTypes);
            queryContractPo.setBuyerNos(orgCodes);
            queryContractPo.setSearchDate(new Date());
            queryContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            queryContractPo.setVendorStatus(1);
            Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionAgreement(queryContractPo));
            List result = page.getResult();
            List infoBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)result)).toJavaList(ContractPlanMatchingAgreementInfoBO.class);
            for (ContractPlanMatchingAgreementInfoBO infoBO : infoBOS) {
                if (infoBO.getContractEndDate() == null || infoBO.getContractEffectiveDate() == null) continue;
                Long time = infoBO.getContractEndDate().getTime() - infoBO.getContractEffectiveDate().getTime();
                infoBO.setValidTime(String.valueOf(time / 24L / 60L / 60L / 1000L));
            }
            rspBO.setRows(infoBOS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
            return rspBO;
        }
        throw new ZTBusinessException("\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u4e70\u53d7\u4eba\u5931\u8d25" + umcEntityOrgBuyerQryAbilityRspBO.getRespDesc());
    }
}

