/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.busi.ContractPushDealConvFwTextFileBusiService;
import com.tydic.contract.busi.bo.ContractPushDealConvFwTextFileBusiReqBO;
import com.tydic.contract.busi.bo.ContractPushDealConvFwTextFileBusiRspBO;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.contract.utils.WordToPdf;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPushDealConvFwTextFileBusiServiceImpl
implements ContractPushDealConvFwTextFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractPushDealConvFwTextFileBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "contract/pdf";

    @Override
    public ContractPushDealConvFwTextFileBusiRspBO pushDealConvFwTextFile(ContractPushDealConvFwTextFileBusiReqBO reqBO) {
        Object updatePO;
        String contractDocUrl;
        String convFileUrl;
        List codes;
        String extFiled2;
        List<Object> materialCategoryList;
        Object po;
        ContractPushDealConvFwTextFileBusiRspBO rspBO = new ContractPushDealConvFwTextFileBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null && reqBO.getUpdateApplyId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getContractId() != null && (po = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId())) != null && ((ContractInfoPO)po).getPushLegalFlag() != null && ((ContractInfoPO)po).getPushLegalFlag() == 1 && !StringUtils.isEmpty((Object)((ContractInfoPO)po).getContractDocUrl()) && !((ContractInfoPO)po).getContractDocUrl().endsWith(".pdf") && (((ContractInfoPO)po).getContractDocUrl().endsWith(".doc") || ((ContractInfoPO)po).getContractDocUrl().endsWith(".docx"))) {
            materialCategoryList = new ArrayList();
            extFiled2 = ((ContractInfoPO)po).getExtFiled2();
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)extFiled2)) {
                codes = JSONObject.parseArray((String)extFiled2, String.class);
                materialCategoryList = codes.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList());
            }
            if (materialCategoryList.contains(((ContractInfoPO)po).getMaterialCategory()) && !StringUtils.isEmpty((Object)(convFileUrl = this.convFile(contractDocUrl = ((ContractInfoPO)po).getContractDocUrl())))) {
                updatePO = new ContractInfoPO();
                ((ContractInfoPO)updatePO).setContractDocUrl(convFileUrl);
                ((ContractInfoPO)updatePO).setExtFiled3(((ContractInfoPO)po).getContractDocUrl());
                ((ContractInfoPO)updatePO).setContractId(reqBO.getContractId());
                this.contractInfoMapper.updateByPrimaryKeySelective((ContractInfoPO)updatePO);
            }
        }
        if (reqBO.getUpdateApplyId() != null && (po = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId())) != null && ((ContractInfoChangePO)po).getPushLegalFlag() != null && ((ContractInfoChangePO)po).getPushLegalFlag() == 1 && !StringUtils.isEmpty((Object)((ContractInfoChangePO)po).getContractDocUrl()) && !((ContractInfoChangePO)po).getContractDocUrl().endsWith(".pdf") && (((ContractInfoChangePO)po).getContractDocUrl().endsWith(".doc") || ((ContractInfoChangePO)po).getContractDocUrl().endsWith(".docx"))) {
            materialCategoryList = new ArrayList();
            extFiled2 = ((ContractInfoChangePO)po).getExtFiled2();
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)extFiled2)) {
                codes = JSONObject.parseArray((String)extFiled2, String.class);
                materialCategoryList = codes.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList());
            }
            if (materialCategoryList.contains(((ContractInfoChangePO)po).getMaterialCategory()) && !StringUtils.isEmpty((Object)(convFileUrl = this.convFile(contractDocUrl = ((ContractInfoChangePO)po).getContractDocUrl())))) {
                updatePO = new ContractInfoChangePO();
                ((ContractInfoChangePO)updatePO).setContractDocUrl(convFileUrl);
                ((ContractInfoChangePO)updatePO).setExtFiled3(((ContractInfoChangePO)po).getContractDocUrl());
                ((ContractInfoChangePO)updatePO).setUpdateApplyId(reqBO.getUpdateApplyId());
                this.contractInfoChangeMapper.updateByPrimaryKeySelective((ContractInfoChangePO)updatePO);
            }
        }
        return rspBO;
    }

    private String convFile(String contractDocUrl) {
        String exportUrl;
        block23: {
            String preName = "signDocument-";
            String fileName = "";
            File wordFile = null;
            File pdfFile = null;
            fileName = contractDocUrl.endsWith(".doc") ? preName + String.valueOf(Sequence.getInstance().nextId() + ".doc") : preName + String.valueOf(Sequence.getInstance().nextId() + ".docx");
            String pdfFileName = preName + String.valueOf(Sequence.getInstance().nextId() + ".pdf");
            HttpUtil.httpDownload(contractDocUrl, fileName);
            log.info("\u5408\u540cword\u6587\u4ef6-\u4e0b\u8f7d\u5230\u672c\u5730");
            try {
                wordFile = new File(fileName);
                WordToPdf.wordToPdf2(fileName, pdfFileName);
                pdfFile = new File(pdfFileName);
                try {
                    byte[] bytes = FileHelper.getBytes(pdfFileName);
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    String path = this.fileClient.uploadFileByInputStream(PATH, pdfFileName, (InputStream)input);
                    if (FILE_TYPE_OSS.equals(this.fileType)) {
                        exportUrl = this.ossFileUrl + path;
                        break block23;
                    }
                    if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                        FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                        exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                        break block23;
                    }
                    throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25" + e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                throw new ZTBusinessException("\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            }
            finally {
                if (ObjectUtils.isEmpty(pdfFile)) {
                    log.error("pdfFile\u5bf9\u8c61\u662f\u7a7a\u7684");
                } else if (!pdfFile.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + pdfFileName + "\u4e0d\u5b58\u5728\uff01");
                } else if (pdfFile.isFile()) {
                    if (pdfFile.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + pdfFileName + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + pdfFileName + "\u5931\u8d25\uff01");
                    }
                }
                if (ObjectUtils.isEmpty((Object)wordFile)) {
                    log.error("wordFile\u5bf9\u8c61\u662f\u7a7a\u7684");
                } else if (!wordFile.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + fileName + "\u4e0d\u5b58\u5728\uff01");
                } else if (wordFile.isFile()) {
                    if (wordFile.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
                    }
                }
            }
        }
        return exportUrl;
    }
}

