/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractImoprtTemplateBO;
import com.tydic.contract.busi.ContractSafeStockImportBusiService;
import com.tydic.contract.busi.bo.ContractSafeStockImportBusiReqBO;
import com.tydic.contract.busi.bo.ContractSafeStockImportBusiRspBO;
import com.tydic.contract.dao.CContractStockTempMapper;
import com.tydic.contract.dao.SysDicDictionaryMapper;
import com.tydic.contract.po.CContractStockTempPO;
import com.tydic.contract.po.SysDicDictionaryPO;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContractSafeStockImportBusiServiceImpl
implements ContractSafeStockImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSafeStockImportBusiServiceImpl.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private CContractStockTempMapper cContractStockTempMapper;

    @Override
    public ContractSafeStockImportBusiRspBO dealImportSafeStock(ContractSafeStockImportBusiReqBO reqBO) {
        this.checkReqBO(reqBO);
        List importStockTempPOS = new ArrayList();
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getFileUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            ContractSafeStockImportBusiServiceImpl.getExcelDate((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("6018", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        List<SysDicDictionaryPO> dicDictionaryPOS = this.sysDicDictionaryMapper.selectByPCode("SAFE_STOCK_IMPOR_PCODE");
        if (CollectionUtils.isEmpty(dicDictionaryPOS)) {
            throw new ZTBusinessException("\u5b89\u5168\u5e93\u5b58\u5bfc\u5165\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u7ef4\u62a4\uff01");
        }
        String importTemplateStr = dicDictionaryPOS.get(0).getTitle();
        List templateBOs = JSON.parseArray((String)importTemplateStr, ContractImoprtTemplateBO.class);
        block4: for (ContractImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block4;
            }
        }
        log.info("data:" + data);
        log.info("dateMapIndex:" + dateMapIndex);
        log.info("templateBOs:" + templateBOs);
        ArrayList dateMaps = new ArrayList();
        StringBuilder failMsg = new StringBuilder();
        for (List list : data) {
            boolean importErrMsgFlag = false;
            HashMap<String, String> dataMap = new HashMap<String, String>();
            StringBuilder importRemark = new StringBuilder();
            for (ContractImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null == sheetKey) {
                    importErrMsgFlag = true;
                    importRemark.setLength(0);
                    importRemark.append("\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                    failMsg.append("\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                    continue;
                }
                if (sheetKey >= list.size()) continue;
                String content = (String)list.get(sheetKey);
                if (bo.getIsMustFill().booleanValue()) {
                    if (null == content || "".equals(content) || "null".equals(content)) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                        failMsg.append("\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                        continue;
                    }
                } else if ("null".equals(content)) {
                    content = "";
                }
                dataMap.put(bo.getFieldNameEng(), content);
            }
            dateMaps.add(dataMap);
        }
        if (!StringUtils.isEmpty((Object)failMsg.toString())) {
            throw new ZTBusinessException(failMsg.toString());
        }
        String jsonStr = JSON.toJSONString(dateMaps);
        log.info("\u586b\u5199\u6570\u636e\u89c4\u8303\u524d\u6570\u636e\uff1a" + jsonStr);
        try {
            importStockTempPOS = JSON.parseArray((String)jsonStr, CContractStockTempPO.class);
        }
        catch (Exception exception) {
            log.error("\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01" + exception);
            throw new BusinessException("8888", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        log.info("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\uff1a" + JSONObject.toJSONString(importStockTempPOS));
        if (!CollectionUtils.isEmpty(importStockTempPOS)) {
            CContractStockTempPO cContractStockTempPO = new CContractStockTempPO();
            cContractStockTempPO.setTempId(reqBO.getTempId());
            List<CContractStockTempPO> stockTempPOS = this.cContractStockTempMapper.queryAll(cContractStockTempPO);
            ArrayList<CContractStockTempPO> updateStockTempPOS = new ArrayList<CContractStockTempPO>();
            Map<Long, List<CContractStockTempPO>> itemIdMap = importStockTempPOS.stream().collect(Collectors.groupingBy(CContractStockTempPO::getItemId));
            for (CContractStockTempPO po : stockTempPOS) {
                if (!itemIdMap.containsKey(po.getItemId())) continue;
                CContractStockTempPO materialList = itemIdMap.get(po.getItemId()).get(0);
                CContractStockTempPO updatePO = new CContractStockTempPO();
                updatePO.setId(po.getId());
                updatePO.setSafeNum(materialList.getSafeNum());
                updatePO.setLimitNum(materialList.getLimitNum());
                updateStockTempPOS.add(updatePO);
            }
            if (!CollectionUtils.isEmpty(updateStockTempPOS)) {
                this.cContractStockTempMapper.updateBatch(updateStockTempPOS);
            }
        }
        ContractSafeStockImportBusiRspBO contractSafeStockImportBusiRspBO = new ContractSafeStockImportBusiRspBO();
        contractSafeStockImportBusiRspBO.setRespCode("0000");
        contractSafeStockImportBusiRspBO.setRespDesc("\u6210\u529f");
        return contractSafeStockImportBusiRspBO;
    }

    public void checkReqBO(ContractSafeStockImportBusiReqBO reqBO) {
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFileUrl())) {
            throw new ZTBusinessException("\u5165\u53c2[fileUrl]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void getExcelDate(MultipartFile file, List<List<String>> data, List<String> title) throws Exception {
        ContractSafeStockImportBusiServiceImpl.checkExcelVaild(file);
        Workbook workbook = ContractSafeStockImportBusiServiceImpl.getWorkbok(file);
        int count = 0;
        if (!ObjectUtils.isEmpty((Object)workbook)) {
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                int i;
                boolean cow = true;
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                for (i = 0; i < end; ++i) {
                    if (null == row.getCell(i) || "".equals(row.getCell(i).toString())) continue;
                    cow = false;
                    break;
                }
                if (cow) continue;
                for (i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ContractSafeStockImportBusiServiceImpl.getValue(cell);
                    if (count == 0) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < 1) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".0")) {
                        str = str.substring(0, str.length() - 2);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
    }

    public static Object getValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                String valueStr = String.valueOf(obj);
                if (valueStr.endsWith(".0")) {
                    obj = valueStr.substring(0, valueStr.lastIndexOf(".0"));
                }
                if (valueStr.endsWith(".00")) {
                    obj = valueStr.substring(0, valueStr.lastIndexOf(".00"));
                }
                if (valueStr.endsWith(".000")) {
                    obj = valueStr.substring(0, valueStr.lastIndexOf(".000"));
                }
                if (valueStr.endsWith(".0000")) {
                    obj = valueStr.substring(0, valueStr.lastIndexOf(".0000"));
                }
                if (!valueStr.endsWith(".00000")) break;
                obj = valueStr.substring(0, valueStr.lastIndexOf(".00000"));
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static Workbook getWorkbok(MultipartFile file) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getOriginalFilename().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(file.getInputStream());
        } else if (file.getOriginalFilename().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(file.getInputStream());
        }
        return wb;
    }

    public static void checkExcelVaild(MultipartFile file) throws Exception {
        if (!file.getOriginalFilename().endsWith(EXCEL_XLS) && !file.getOriginalFilename().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }
}

