/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.atom.bo.InterFacePushLegalSaveContractFileyfBO;
import com.tydic.contract.atom.bo.InterFacePushLegalSaveContractIdentificationBO;
import com.tydic.contract.atom.bo.InterFacePushLegalSaveContractPerformplanBO;
import com.tydic.contract.atom.bo.InterFacePushLegalSaveContractSignBO;
import com.tydic.contract.busi.ContractSignPushLegalBusiService;
import com.tydic.contract.busi.bo.ContractSignPushLegalBusiReqBO;
import com.tydic.contract.busi.bo.InterFaceSaveContractSignPushLegalReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractSignInitLogMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractSignInitLogPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractSignPushLegalBusiServiceImpl
implements ContractSignPushLegalBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSignPushLegalBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CContractSignInitLogMapper cContractSignInitLogMapper;
    @Value(value="${CONTRACT_SIGN_PUSH_LEGAL_SAVE_CONTRACT_URL}")
    private String contractSignPushLegalSaveContractUrl;

    @Override
    public ContractRspBaseBO dealSignPushLegal(ContractSignPushLegalBusiReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (reqBO.getContractId() != null) {
            InterFaceSaveContractSignPushLegalReqBO contractSignPushLegalReqBO = new InterFaceSaveContractSignPushLegalReqBO();
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            if (contractInfoPO != null && ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractInfoPO.getContractStatus()) && contractInfoPO.getPushLegalFlag() == 1 && !StringUtils.isEmpty((Object)contractInfoPO.getPushLegalContractCode())) {
                CContractSignInitLogPO cContractSignInitLogPO = new CContractSignInitLogPO();
                cContractSignInitLogPO.setContractId(reqBO.getContractId());
                List<CContractSignInitLogPO> cContractSignInitLogPOS = this.cContractSignInitLogMapper.getList(cContractSignInitLogPO);
                if (CollectionUtils.isEmpty(cContractSignInitLogPOS)) {
                    log.error("\u5408\u540c\u7b7e\u7ae0\u4fe1\u606f\u540c\u6b65\u6cd5\u52a1\u7cfb\u7edf\u5931\u8d25\uff0c\u7b7e\u7ae0\u4fe1\u606f\u4e3a\u7a7a\uff1a" + reqBO.getContractId());
                } else {
                    CContractSignInitLogPO signInitLogPO = cContractSignInitLogPOS.get(cContractSignInitLogPOS.size() - 1);
                    ArrayList<InterFacePushLegalSaveContractIdentificationBO> IDENTIFICATIONList = new ArrayList<InterFacePushLegalSaveContractIdentificationBO>();
                    InterFacePushLegalSaveContractIdentificationBO IDENTIFICATION = new InterFacePushLegalSaveContractIdentificationBO();
                    IDENTIFICATION.setIDENTIFICATION("yigou");
                    IDENTIFICATIONList.add(IDENTIFICATION);
                    contractSignPushLegalReqBO.setIDENTIFICATION(IDENTIFICATIONList);
                    ArrayList<InterFacePushLegalSaveContractFileyfBO> FILE = new ArrayList<InterFacePushLegalSaveContractFileyfBO>();
                    if (!StringUtils.isEmpty((Object)contractInfoPO.getContractDocName()) && !StringUtils.isEmpty((Object)contractInfoPO.getContractDocUrl())) {
                        InterFacePushLegalSaveContractFileyfBO fileyfBO = new InterFacePushLegalSaveContractFileyfBO();
                        fileyfBO.setFILENAME(contractInfoPO.getContractDocName());
                        fileyfBO.setFILEPATH(contractInfoPO.getContractDocUrl());
                        FILE.add(fileyfBO);
                    }
                    contractSignPushLegalReqBO.setFILE(FILE);
                    InterFacePushLegalSaveContractSignBO signBO = new InterFacePushLegalSaveContractSignBO();
                    signBO.setYGCONTNUMBER(contractInfoPO.getPushLegalContractCode());
                    signBO.setHANDLEUSERID(contractInfoPO.getLegalUndertakeId());
                    if (signInitLogPO.getFirstPartySealName().equals(signInitLogPO.getFirstPartySignName())) {
                        signBO.setOURSIGNMAN(signInitLogPO.getFirstPartySealName());
                    } else {
                        signBO.setOURSIGNMAN(signInitLogPO.getFirstPartySealName() + "," + signInitLogPO.getFirstPartySignName());
                    }
                    if (signInitLogPO.getSecondPartySealName().equals(signInitLogPO.getSecondPartySignName())) {
                        signBO.setPARTYSIGNMAN(signInitLogPO.getSecondPartySealName());
                    } else {
                        signBO.setPARTYSIGNMAN(signInitLogPO.getSecondPartySealName() + "," + signInitLogPO.getSecondPartySignName());
                    }
                    signBO.setSIGNPLACEE("\u4e2d\u7164\u6613\u7b7e");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    signBO.setCONTBEGINTIME(dateFormat.format(contractInfoPO.getContractEffectiveDate()));
                    ArrayList<InterFacePushLegalSaveContractSignBO> SIGN = new ArrayList<InterFacePushLegalSaveContractSignBO>();
                    SIGN.add(signBO);
                    contractSignPushLegalReqBO.setSIGN(SIGN);
                    contractSignPushLegalReqBO.setPERFORMPLAN(new ArrayList<InterFacePushLegalSaveContractPerformplanBO>());
                    try {
                        reqBO.setReqJson(JSONObject.toJSONString((Object)contractSignPushLegalReqBO));
                        reqBO.setPushLegalTime(new Date());
                        String callRetuanStr = this.call(contractSignPushLegalReqBO);
                        reqBO.setPushLegalReturnTime(new Date());
                        reqBO.setPushLegalReturnInfo(callRetuanStr);
                    }
                    catch (Exception e) {
                        reqBO.setPushLegalReturnInfo("\u8c03\u7528\u63a5\u53e3\u62a5\u9519\u5f02\u5e38" + e.getMessage());
                        throw new ZTBusinessException(e.getMessage());
                    }
                }
            } else {
                log.error("\u5408\u540c\u7b7e\u7ae0\u4fe1\u606f\u540c\u6b65\u6cd5\u52a1\u7cfb\u7edf\u5931\u8d25\uff0c\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\u6216\u72b6\u6001\u4e0d\u7b26\u5408\uff1a" + JSON.toJSONString((Object)contractInfoPO));
            }
        }
        return rspBaseBO;
    }

    public String call(InterFaceSaveContractSignPushLegalReqBO contractSignPushLegalReqBO) {
        String reqStr = JSONObject.toJSONString((Object)contractSignPushLegalReqBO);
        log.info("\u63a8\u9001\u5408\u540c\u7b7e\u7ae0\u4fe1\u606f\u63a5\u53e3\u5165\u53c2" + reqStr);
        String rspStr = HttpUtil.doPost(this.contractSignPushLegalSaveContractUrl, reqStr, null);
        log.info("\u63a8\u9001\u5408\u540c\u7b7e\u7ae0\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2" + rspStr);
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        if (jsonObject.get((Object)"status") == null) {
            return "\u63a8\u9001\u5408\u540c\u7b7e\u7ae0\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a" + reqStr;
        }
        return rspStr;
    }
}

