/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcBuyerAbbreviationConfigQryAbilityService;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigBO;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigQryAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigQryAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.contract.busi.ContractTrackNoBusiService;
import com.tydic.contract.busi.bo.ContractTrackNoBusiReqBO;
import com.tydic.contract.busi.bo.ContractTrackNoBusiRspBO;
import com.tydic.contract.dao.CContractTracknoConfigMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractTracknoConfigPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractTrackNoBusiServiceImpl
implements ContractTrackNoBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractTrackNoBusiServiceImpl.class);
    @Autowired
    private CContractTracknoConfigMapper cContractTracknoConfigMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CfcBuyerAbbreviationConfigQryAbilityService cfcBuyerAbbreviationConfigQryAbilityService;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;

    @Override
    public ContractTrackNoBusiRspBO qryTrackNo(ContractTrackNoBusiReqBO reqBO) {
        ContractTrackNoBusiRspBO rspBO = new ContractTrackNoBusiRspBO();
        String trackNoStr = "chushihuayigezhi";
        log.error("--------------\u5f00\u59cb\u751f\u6210\u8ddf\u8e2a\u53f7-----------------");
        if (reqBO.getContractId() != null) {
            CContractTracknoConfigPO po = new CContractTracknoConfigPO();
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            po.setBuyerId(contractInfoPO.getBuyerId());
            po.setContractType(this.getContractType(contractInfoPO.getContractType().toString()));
            String buyerShortName = this.getBuyerShortName(contractInfoPO.getBuyerNo());
            List<CContractTracknoConfigPO> cContractTracknoConfigPOS = this.cContractTracknoConfigMapper.qryTracknoConfig(po);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(cContractTracknoConfigPOS)) {
                CContractTracknoConfigPO tracknoConfigPO = cContractTracknoConfigPOS.get(0);
                trackNoStr = buyerShortName + tracknoConfigPO.getYear() + tracknoConfigPO.getMonth() + po.getContractType() + tracknoConfigPO.getSerialNo();
                this.cContractTracknoConfigMapper.updateSerialNo(tracknoConfigPO.getId());
            } else {
                String serialNo = "0001";
                Date currentDate = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(currentDate);
                int year = calendar.get(1);
                int month = calendar.get(2) + 1;
                String twoDigitYear = String.valueOf(year).substring(2);
                String monthString = String.valueOf(month);
                CContractTracknoConfigPO insertPo = new CContractTracknoConfigPO();
                insertPo.setBuyerId(contractInfoPO.getBuyerId());
                insertPo.setContractType(po.getContractType());
                insertPo.setYear(twoDigitYear);
                insertPo.setMonth(monthString);
                insertPo.setInsertSerialNo(Integer.valueOf(serialNo) + 1);
                this.cContractTracknoConfigMapper.insert(insertPo);
                trackNoStr = buyerShortName + twoDigitYear + String.format("%02d", month) + po.getContractType() + serialNo;
            }
        } else {
            throw new ZTBusinessException("\u751f\u6210\u8ddf\u8e2a\u53f7\u5931\u8d25\uff0c\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.error("--------------\u5f00\u59cb\u751f\u6210\u8ddf\u8e2a\u53f7\u4e3a:" + trackNoStr);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!this.checkTrack(trackNoStr)) {
            log.error("\u8ddf\u8e2a\u53f7\u4e0d\u91cd\u590d:" + trackNoStr);
            rspBO.setTrackNo(trackNoStr);
            return rspBO;
        }
        log.error("\u8ddf\u8e2a\u53f7\u91cd\u590d:" + trackNoStr);
        return this.qryTrackNo(reqBO);
    }

    public boolean checkTrack(String trackNo) {
        ContractInfoPO qryPo = new ContractInfoPO();
        qryPo.setTrackNo(trackNo);
        List<ContractInfoPO> list = this.contractInfoMapper.getList(qryPo);
        return !org.apache.commons.collections.CollectionUtils.isEmpty(list);
    }

    public String getContractType(String contractType) {
        CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
        cfcUniteParamQryListPageAbilityReqBO.setCenter("CONTRACT");
        cfcUniteParamQryListPageAbilityReqBO.setGroupCode("CONTRACT_TYPE_CODE");
        CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO);
        if (CollectionUtils.isEmpty((Collection)cfcUniteParamQryListPageAbilityRspBO.getRows())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u8bf7\u7ef4\u62a4\u5408\u540c\u7c7b\u578b\u540e\u521b\u5efa\u5408\u540c");
        }
        for (JSONObject jsonObject : cfcUniteParamQryListPageAbilityRspBO.getRows()) {
            String list;
            if (jsonObject.get((Object)"contractType") == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(list = jsonObject.get((Object)"contractType").toString())) || !list.contains(contractType)) continue;
            return (String)jsonObject.get((Object)"code");
        }
        return "";
    }

    public String getBuyerShortName(String buyerNo) {
        if (!StringUtils.isEmpty((String)buyerNo)) {
            CfcBuyerAbbreviationConfigQryAbilityReqBO buyerQryReqBO = new CfcBuyerAbbreviationConfigQryAbilityReqBO();
            buyerQryReqBO.setId(buyerNo);
            buyerQryReqBO.setPageNo(Integer.valueOf(1));
            buyerQryReqBO.setPageSize(Integer.valueOf(10));
            CfcBuyerAbbreviationConfigQryAbilityRspBO buyerQryRspBO = this.cfcBuyerAbbreviationConfigQryAbilityService.qryBuyerAbbreviationConfig(buyerQryReqBO);
            if (buyerQryRspBO.getRespCode().equals("0000") && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)buyerQryRspBO.getRows())) {
                return ((CfcBuyerAbbreviationConfigBO)buyerQryRspBO.getRows().get(0)).getBuyerShortName();
            }
            throw new ZTBusinessException("\u4e70\u53d7\u4eba\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u7684\u7b80\u79f0\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u914d\u7f6e\uff01");
        }
        throw new ZTBusinessException("\u5355\u4f4d\u5408\u540c\u83b7\u53d6\u7f16\u7801\u65f6\u4e70\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

