/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.bo.ContractAccessoryBOResp;
import com.tydic.contract.ability.bo.ContractInfoBOResp;
import com.tydic.contract.busi.ContractUpdateAccessoryBusiService;
import com.tydic.contract.busi.bo.ContractUpdateAccessoryBusiReqBO;
import com.tydic.contract.busi.bo.ContractUpdateAccessoryBusiRspBo;
import com.tydic.contract.busi.bo.ContractUpdateAccessoryQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractUpdateAccessoryQueryBusiRspBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ContractUpdateAccessoryBusiServiceImpl
implements ContractUpdateAccessoryBusiService {
    @Autowired
    ContractInfoMapper contractInfoMapper;
    @Autowired
    ContractAccessoryMapper contractAccessoryMapper;

    @Override
    public ContractUpdateAccessoryQueryBusiRspBo updateContractAccessoryQuery(ContractUpdateAccessoryQueryBusiReqBO reqBO) {
        ContractUpdateAccessoryQueryBusiRspBo rspBO = new ContractUpdateAccessoryQueryBusiRspBo();
        List<ContractInfoPO> contractInfoMapperList = this.getContractList(reqBO);
        if (CollectionUtils.isEmpty(contractInfoMapperList)) {
            rspBO.setRespCode("0");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (contractInfoMapperList.size() > 1) {
            rspBO.setRespCode("1");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setResultMessage("\u8bf7\u68c0\u67e5\u9700\u67e5\u8be2\u7684\u5185\u5bb9\u662f\u5426\u6b63\u786e");
            return rspBO;
        }
        this.findContractAccessory(contractInfoMapperList, rspBO);
        rspBO.setRespCode("0");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    @Transactional
    public ContractUpdateAccessoryBusiRspBo updateContractAccessory(ContractUpdateAccessoryBusiReqBO contractUpdateAccessoryBusiRepBO) {
        ContractUpdateAccessoryBusiRspBo rspBO = new ContractUpdateAccessoryBusiRspBo();
        if (null != contractUpdateAccessoryBusiRepBO.getContractId()) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractUpdateAccessoryBusiRepBO, (Object)contractInfoPO);
            this.contractInfoMapper.updateContract(contractInfoPO);
        }
        if (!CollectionUtils.isEmpty(contractUpdateAccessoryBusiRepBO.getContractAccessory())) {
            for (ContractAccessoryBOResp contractAccessoryBOResp : contractUpdateAccessoryBusiRepBO.getContractAccessory()) {
                ContractAccessoryPo contractAccessoryPo = new ContractAccessoryPo();
                BeanUtils.copyProperties((Object)contractAccessoryBOResp, (Object)contractAccessoryPo);
                this.contractAccessoryMapper.updateByPrimaryKeySelective(contractAccessoryPo);
            }
        }
        rspBO.setRespCode("0");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void findContractAccessory(List<ContractInfoPO> contractInfoMapperList, ContractUpdateAccessoryQueryBusiRspBo rspBO) {
        ContractInfoPO contractInfoPO = contractInfoMapperList.get(0);
        ContractAccessoryPo contractAccessoryPo = new ContractAccessoryPo();
        contractAccessoryPo.setRelateId(contractInfoPO.getContractId());
        ContractInfoBOResp contractInfoBO = (ContractInfoBOResp)JSON.parseObject((String)JSON.toJSONString((Object)contractInfoPO), ContractInfoBOResp.class);
        rspBO.setContractInfoBO(contractInfoBO);
        List<ContractAccessoryPo> contractAccessoryBOS = this.contractAccessoryMapper.qryByCondition(contractAccessoryPo);
        if (!CollectionUtils.isEmpty(contractAccessoryBOS)) {
            Map<Integer, List<ContractAccessoryPo>> mapData = contractAccessoryBOS.stream().collect(Collectors.groupingBy(contractAccessoryPoData -> contractAccessoryPoData.getRelateType()));
            Set<Integer> relateType = mapData.keySet();
            if (relateType.contains(ContractConstant.RelateType.RELATE_TYPE_CONTRACT)) {
                rspBO.setAccessoryList(this.changeData(mapData.get(ContractConstant.RelateType.RELATE_TYPE_CONTRACT)));
            }
            if (relateType.contains(ContractConstant.RelateType.RELATE_TYPE_BASE_OTHER_ACCESSORY)) {
                rspBO.setAccessoryListOther(this.changeData(mapData.get(ContractConstant.RelateType.RELATE_TYPE_BASE_OTHER_ACCESSORY)));
            }
            if (relateType.contains(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_BASIC)) {
                rspBO.setAccessoryListAccording(this.changeData(mapData.get(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_BASIC)));
            }
        }
    }

    public List<ContractAccessoryBOResp> changeData(List<ContractAccessoryPo> contractAccessoryBOS) {
        ArrayList<ContractAccessoryBOResp> contractAccessory = new ArrayList<ContractAccessoryBOResp>();
        if (!CollectionUtils.isEmpty(contractAccessoryBOS)) {
            for (ContractAccessoryPo contractAccessoryBO : contractAccessoryBOS) {
                ContractAccessoryBOResp contractAccessBO = new ContractAccessoryBOResp();
                BeanUtils.copyProperties((Object)contractAccessoryBO, (Object)contractAccessBO);
                contractAccessory.add(contractAccessBO);
            }
        }
        return contractAccessory;
    }

    public List<ContractInfoPO> getContractList(ContractUpdateAccessoryQueryBusiReqBO reqBO) {
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        contractInfoPO.setContractCode(reqBO.getContractCode());
        contractInfoPO.setContractNo(reqBO.getContractNo());
        contractInfoPO.setContractName(reqBO.getContractName());
        contractInfoPO.setCreateUserName(reqBO.getCreateUserName());
        String contractStatus = this.getContractStatus(reqBO.getContractTypeAccessory());
        if (StringUtils.isNotBlank((String)contractStatus)) {
            String[] split = contractStatus.split(",");
            ArrayList<Integer> contractTypes = new ArrayList<Integer>();
            for (String contractStatusValue : split) {
                contractTypes.add(Integer.valueOf(contractStatusValue));
            }
            contractInfoPO.setContractTypes(contractTypes);
        }
        return this.contractInfoMapper.getListData(contractInfoPO);
    }

    public String getContractStatus(Integer status) {
        if (ContractConstant.ChangeAccessoryStatusEnum.QUALITY1.getCode().equals(status)) {
            return ContractConstant.ChangeAccessoryStatusEnum.getValueByCode(ContractConstant.ChangeAccessoryStatusEnum.QUALITY1.getCode());
        }
        if (ContractConstant.ChangeAccessoryStatusEnum.QUALITY2.getCode().equals(status)) {
            return ContractConstant.ChangeAccessoryStatusEnum.getValueByCode(ContractConstant.ChangeAccessoryStatusEnum.QUALITY2.getCode());
        }
        if (ContractConstant.ChangeAccessoryStatusEnum.QUALITY3.getCode().equals(status)) {
            return ContractConstant.ChangeAccessoryStatusEnum.getValueByCode(ContractConstant.ChangeAccessoryStatusEnum.QUALITY3.getCode());
        }
        if (ContractConstant.ChangeAccessoryStatusEnum.QUALITY4.getCode().equals(status)) {
            return ContractConstant.ChangeAccessoryStatusEnum.getValueByCode(ContractConstant.ChangeAccessoryStatusEnum.QUALITY4.getCode());
        }
        return "";
    }
}

