/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static Long getFileSize(String path) {
        File file = new File(path);
        long length = 0L;
        if (file.exists() && file.isFile()) {
            String fileName = file.getName();
            length = file.length();
        }
        return length;
    }

    public static String getStringContentMD5(String str) {
        byte[] bytes = FileUtil.getFileMD5Bytes1282(str);
        return new String(Base64.getEncoder().encode(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileMD5Bytes1282(String filePath) {
        FileInputStream fis = null;
        byte[] md5Bytes = null;
        try {
            File file = new File(filePath);
            fis = new FileInputStream(file);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = fis.read(buffer, 0, 1024)) != -1) {
                md5.update(buffer, 0, length);
            }
            md5Bytes = md5.digest();
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return md5Bytes;
    }
}

