/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractDictionaryAbilityService;
import com.tydic.contract.ability.bo.ContractDicDictionaryQryReqBO;
import com.tydic.contract.ability.bo.ContractDicDictionaryReqBO;
import com.tydic.contract.ability.bo.ContractDicRspListPageBO;
import com.tydic.contract.ability.bo.ContractDictionaryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractQueryDictionaryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractRspListBO;
import com.tydic.contract.ability.bo.DicDictionaryBO;
import com.tydic.contract.busi.ContractDictionaryBusiService;
import com.tydic.contract.constant.ContractConstant;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractDictionaryAbilityService"})
public class ContractDictionaryAbilityServiceImpl
implements ContractDictionaryAbilityService {
    @Autowired
    private ContractDictionaryBusiService contractDictionaryBusiService;

    @PostMapping(value={"queryBypCodeBackPo"})
    public ContractRspListBO<DicDictionaryBO> queryBypCodeBackPo(@RequestBody ContractQueryDictionaryAbilityReqBO abilityReqBO) {
        ContractRspListBO result = new ContractRspListBO();
        List<DicDictionaryBO> busiList = this.contractDictionaryBusiService.queryBypCodeBackPo("CONTRACT", abilityReqBO.getPcode(), abilityReqBO.getTitle());
        result.setRows(busiList);
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }

    @PostMapping(value={"updateDicDictionary"})
    public ContractDictionaryAbilityRspBO updateDicDictionary(@RequestBody ContractDicDictionaryReqBO dicDictionaryBO) {
        this.validationParamsInvoice(dicDictionaryBO);
        ContractDictionaryAbilityRspBO contractDictionaryAbilityRspBO = new ContractDictionaryAbilityRspBO();
        contractDictionaryAbilityRspBO.setRespCode("0000");
        contractDictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.contractDictionaryBusiService.checkDicBy(dicDictionaryBO.getCode(), dicDictionaryBO.getPCode());
        if (checkResult < 1) {
            contractDictionaryAbilityRspBO.setRespCode("163033");
            contractDictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return contractDictionaryAbilityRspBO;
        }
        dicDictionaryBO.setSysCode("CONTRACT");
        dicDictionaryBO.setDelflag(ContractConstant.DicDelFlag.YES);
        int result = this.contractDictionaryBusiService.updateDicDictionary(dicDictionaryBO);
        if (result < 1) {
            contractDictionaryAbilityRspBO.setRespCode("163033");
            contractDictionaryAbilityRspBO.setRespDesc("\u4fee\u6539\u5931\u8d25");
        }
        return contractDictionaryAbilityRspBO;
    }

    @PostMapping(value={"deleteDicDictionary"})
    public ContractDictionaryAbilityRspBO deleteDicDictionary(@RequestBody ContractDicDictionaryReqBO dicDictionaryBO) {
        this.validationParamsInvoice(dicDictionaryBO);
        ContractDictionaryAbilityRspBO contractDictionaryAbilityRspBO = new ContractDictionaryAbilityRspBO();
        contractDictionaryAbilityRspBO.setRespCode("0000");
        contractDictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.contractDictionaryBusiService.checkDicBy(dicDictionaryBO.getCode(), dicDictionaryBO.getPCode());
        if (checkResult < 1) {
            contractDictionaryAbilityRspBO.setRespCode("163033");
            contractDictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return contractDictionaryAbilityRspBO;
        }
        int result = this.contractDictionaryBusiService.deleteDicDictionary(dicDictionaryBO);
        if (result < 1) {
            contractDictionaryAbilityRspBO.setRespCode("163033");
            contractDictionaryAbilityRspBO.setRespDesc("\u5220\u9664\u5931\u8d25");
        }
        return contractDictionaryAbilityRspBO;
    }

    @PostMapping(value={"addDicDictionary"})
    public ContractDictionaryAbilityRspBO addDicDictionary(@RequestBody ContractDicDictionaryReqBO dicDictionaryBO) {
        this.validationParamsInvoice(dicDictionaryBO);
        ContractDictionaryAbilityRspBO contractDictionaryAbilityRspBO = new ContractDictionaryAbilityRspBO();
        contractDictionaryAbilityRspBO.setRespCode("0000");
        contractDictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.contractDictionaryBusiService.checkDicBy(dicDictionaryBO.getCode(), dicDictionaryBO.getPCode());
        if (checkResult > 0) {
            contractDictionaryAbilityRspBO.setRespCode("163033");
            contractDictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u5df2\u5b58\u5728");
            return contractDictionaryAbilityRspBO;
        }
        dicDictionaryBO.setDelflag(ContractConstant.DicDelFlag.YES);
        dicDictionaryBO.setSysCode("CONTRACT");
        int result = this.contractDictionaryBusiService.addDicDictionary(dicDictionaryBO);
        if (result < 1) {
            contractDictionaryAbilityRspBO.setRespCode("163033");
            contractDictionaryAbilityRspBO.setRespDesc("\u65b0\u589e\u5931\u8d25");
        }
        return contractDictionaryAbilityRspBO;
    }

    @PostMapping(value={"queryListByPage"})
    public ContractDicRspListPageBO queryListByPage(@RequestBody ContractDicDictionaryQryReqBO qryReqBO) {
        if (StringUtils.isEmpty((CharSequence)qryReqBO.getPCode())) {
            throw new ZTBusinessException("\u5408\u540c\u4e2d\u5fc3-\u6570\u636e\u5b57\u5178\u670d\u52a1\u5165\u53c2\u3010pcode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.contractDictionaryBusiService.queryListBypCode(qryReqBO);
    }

    private void validationParamsInvoice(ContractDicDictionaryReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            throw new ZTBusinessException("\u5408\u540c\u4e2d\u5fc3-\u6570\u636e\u5b57\u5178\u670d\u52a1\u5165\u53c2\u3010pcode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            throw new ZTBusinessException("\u5408\u540c\u4e2d\u5fc3-\u6570\u636e\u5b57\u5178\u670d\u52a1\u5165\u53c2\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

