/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractPlanMatchingService;
import com.tydic.contract.ability.bo.ContractPlanMatchingAgreementItemQryListRspBO;
import com.tydic.contract.ability.bo.ContractPlanMatchingListReqBO;
import com.tydic.contract.busi.ContractPlanMatchingListBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractItemPlanListQryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractPlanMatchingService"})
public class ContractPlanMatchingServiceImpl
implements ContractPlanMatchingService {
    @Autowired
    private UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;

    @PostMapping(value={"qryAgreementItemList"})
    public ContractPlanMatchingAgreementItemQryListRspBO qryAgreementItemList(@RequestBody ContractPlanMatchingListReqBO reqBO) {
        this.ValidateParam(reqBO);
        ContractPlanMatchingAgreementItemQryListRspBO rspBO = new ContractPlanMatchingAgreementItemQryListRspBO();
        UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
        ArrayList erpOrderId = new ArrayList();
        reqBO.getMatchingPlans().forEach(e -> erpOrderId.add(e.getErpOrgId()));
        umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(erpOrderId);
        UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
        if (CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u4e70\u53d7\u4eba\u4e3a\u7a7a!");
            rspBO.setRows(null);
            return rspBO;
        }
        ArrayList<ContractItemPlanListQryPO> contractItemMatchingPlanListQryPO = new ArrayList<ContractItemPlanListQryPO>();
        reqBO.getMatchingPlans().forEach(e -> {
            Map collect;
            if (!CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows()) && ((UmcEntityOrgSubBO)(collect = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEntityOrgSubBO::getSubOrganizationId, Function.identity(), (key1, key2) -> key1))).get(e.getErpOrgId())).getEntityId() != null) {
                ContractItemPlanListQryPO contractMatchingPlan = new ContractItemPlanListQryPO();
                if (!ObjectUtils.isEmpty(collect.get(e.getErpOrgId()))) {
                    contractMatchingPlan.setBuyerNos(((UmcEntityOrgSubBO)collect.get(e.getErpOrgId())).getEntityId().toString());
                    contractMatchingPlan.setMaterialCode(e.getMaterialCode());
                    contractItemMatchingPlanListQryPO.add(contractMatchingPlan);
                }
            }
        });
        if (CollectionUtils.isEmpty(contractItemMatchingPlanListQryPO)) {
            return rspBO;
        }
        List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.qryItemByErpOrgCodePlanList(contractItemMatchingPlanListQryPO);
        ContractPlanMatchingListBusiRspBO contractPlanMatchingListBusiRspBO = new ContractPlanMatchingListBusiRspBO();
        for (ContractInfoItemPO itemBO : contractInfoItemPOS) {
            if (itemBO.getContractStatus() != null) {
                itemBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(itemBO.getContractStatus()));
            }
            if (itemBO.getAmount() == null) {
                itemBO.setAmount(BigDecimal.ZERO);
            }
            if (itemBO.getOrderNum() != null) continue;
            itemBO.setOrderNum(BigDecimal.ZERO);
        }
        contractPlanMatchingListBusiRspBO.setRows(contractInfoItemPOS);
        contractPlanMatchingListBusiRspBO.setRespCode("0000");
        contractPlanMatchingListBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return (ContractPlanMatchingAgreementItemQryListRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)contractPlanMatchingListBusiRspBO)), ContractPlanMatchingAgreementItemQryListRspBO.class);
    }

    private void ValidateParam(ContractPlanMatchingListReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getMatchingPlans())) {
            throw new ZTBusinessException("\u5339\u914d\u5355\u4f4d\u5408\u540c\u7684\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09m\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

