/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractPushLegalAbilityService;
import com.tydic.contract.ability.bo.ContractPushLegalAbilityReqBO;
import com.tydic.contract.ability.bo.ContractPushLegalAbilityRspBO;
import com.tydic.contract.busi.ContractPushLegalBusiService;
import com.tydic.contract.busi.bo.ContractPushLegalBusiReqBO;
import com.tydic.contract.busi.bo.ContractPushLegalBusiRspBO;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractPushLegalAbilityService"})
public class ContractPushLegalAbilityServiceImpl
implements ContractPushLegalAbilityService {
    @Autowired
    private ContractPushLegalBusiService contractPushLegalBusiService;
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;

    @PostMapping(value={"pushLegal"})
    public ContractPushLegalAbilityRspBO pushLegal(@RequestBody ContractPushLegalAbilityReqBO reqBO) {
        Date nowPushTime = new Date();
        ContractPushLogPO pushLogPO = new ContractPushLogPO();
        pushLogPO.setId(Sequence.getInstance().nextId());
        pushLogPO.setType(9);
        pushLogPO.setCreateTime(nowPushTime);
        ContractPushLegalAbilityRspBO abilityRspBO = new ContractPushLegalAbilityRspBO();
        Long key = null;
        if (reqBO.getContractId() != null) {
            key = reqBO.getContractId();
        }
        if (reqBO.getUpdateApplyId() != null) {
            key = reqBO.getUpdateApplyId();
        }
        if (reqBO.getPurchaseApprovalId() != null) {
            key = reqBO.getPurchaseApprovalId();
        }
        if (reqBO.getPurchaseUpdateApplyId() != null) {
            key = reqBO.getPurchaseUpdateApplyId();
        }
        if (key != null) {
            String reqMd = "PushLegal" + key;
            Object o = null;
            try {
                o = this.cacheService.get(reqMd);
            }
            catch (Exception e) {
                e.printStackTrace();
                reqMd = null;
            }
            if (null != o) {
                throw new UocProBusinessException("100100", "60\u79d2\u5185\u4e0d\u5141\u8bb8\u91cd\u590d\u63a8\u9001");
            }
            if (null != reqMd) {
                try {
                    this.cacheService.set(reqMd, (Object)"", 60);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ContractPushLegalBusiReqBO busiReqBO = (ContractPushLegalBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractPushLegalBusiReqBO.class));
        ContractPushLegalBusiRspBO busiRspBO = this.contractPushLegalBusiService.dealPushLegal(busiReqBO);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            String pushLegalReturnTimeStr = sdf.format(busiReqBO.getPushLegalReturnTime());
            String pushLegalTimeStr = sdf.format(busiReqBO.getPushLegalTime());
            pushLogPO.setRspJson("\u8c03\u7528\u63a8\u9001\u65f6\u95f4" + pushLegalTimeStr + "\u63a8\u9001\u8fd4\u56de\u65f6\u95f4" + pushLegalReturnTimeStr + "\u63a8\u9001\u8fd4\u56de\u62a5\u6587" + busiReqBO.getPushLegalReturnInfo());
            pushLogPO.setReqJson(busiReqBO.getReqJson());
            this.contractPushLogMapper.insert(pushLogPO);
        }
        catch (Exception e) {
            // empty catch block
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }
}

