/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractEnvelopeWaitSignInfoBO;
import com.tydic.contract.atom.InterFaceContractSignWaitQueryService;
import com.tydic.contract.atom.bo.InterFaceContractSignWaitQueryReqBo;
import com.tydic.contract.atom.bo.InterFaceContractSignWaitQueryRspBo;
import com.tydic.contract.utils.ComputeWorkDayBeforeUtils;
import com.tydic.contract.utils.HttpUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterFaceContractSignWaitQueryServiceImpl
implements InterFaceContractSignWaitQueryService {
    private static final Logger log = LoggerFactory.getLogger(InterFaceContractSignWaitQueryServiceImpl.class);
    @Value(value="${CONTRACT_GET_SIGN_WAIT_URL}")
    private String contractGetSignWaitUrl;

    @Override
    public InterFaceContractSignWaitQueryRspBo queryContractSignWait(InterFaceContractSignWaitQueryReqBo reqBo) {
        InterFaceContractSignWaitQueryRspBo rspBO = new InterFaceContractSignWaitQueryRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBo.getStaffNo() == null) {
            throw new ZTBusinessException("\u5458\u5de5\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JSONObject.toJSONString((Object)reqBo);
        log.debug("\u8c03\u7528\u67e5\u8be2\u7b7e\u7ae0\u5f85\u529e\u7684\u5165\u53c2\uff1a" + reqStr);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Authorization", (Object)reqBo.getAccessToken());
        try {
            String rspStr = HttpUtil.doGet(this.contractGetSignWaitUrl, reqStr, jsonObject.toJSONString());
            log.debug("\u8c03\u7528\u67e5\u8be2\u7b7e\u7ae0\u5f85\u529e\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)rspStr);
            rspBO = this.resolveRsp(rspStr, reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u7b7e\u7ae0\u5f85\u529e\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private InterFaceContractSignWaitQueryRspBo resolveRsp(String rspStr, InterFaceContractSignWaitQueryReqBo reqBo) {
        JSONObject jsonObject;
        InterFaceContractSignWaitQueryRspBo rspBO = new InterFaceContractSignWaitQueryRspBo();
        try {
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u7b7e\u7ae0\u5f85\u529e\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"code") == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u7b7e\u7ae0\u5f85\u529e\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            if (StringUtils.isEmpty((Object)jsonObject.getString("message")) || "null".equals(jsonObject.getString("message"))) {
                String resultMessage;
                int i;
                jsonObject.getString("resultMessage");
                if (!StringUtils.isEmpty((Object)jsonObject.getString("resultMessage")) && (i = (resultMessage = jsonObject.getString("resultMessage")).indexOf("{")) != -1) {
                    JSONObject jsonObject1 = JSONObject.parseObject((String)resultMessage.substring(i));
                    rspBO.setRespDesc(jsonObject1.getString("message"));
                }
            }
            return rspBO;
        }
        if ("200".equals(jsonObject.getString("code"))) {
            String content = jsonObject.getString("content");
            if (StringUtils.isEmpty((Object)content)) {
                rspBO.setContent("0");
            } else {
                JSONObject respObj = jsonObject.getJSONObject("content");
                if (StringUtils.isEmpty((Object)respObj.getString("envelopeWaitSignInfoVoList"))) {
                    rspBO.setContent("0");
                    rspBO.setItemCount(0);
                    rspBO.setWillOvertimeCount(0);
                    rspBO.setOvertimeCount(0);
                } else {
                    List signInfoVoList = JSON.parseArray((String)respObj.getJSONArray("envelopeWaitSignInfoVoList").toJSONString(), ContractEnvelopeWaitSignInfoBO.class);
                    if (!signInfoVoList.isEmpty()) {
                        if (reqBo.getOvertime() != null) {
                            Date overtimeDate = ComputeWorkDayBeforeUtils.computeWorkDayBefore(reqBo.getOvertime());
                            Date willOvertimeDate = ComputeWorkDayBeforeUtils.computeWorkDayBefore(reqBo.getOvertime() - 1);
                            long overtimeCount = signInfoVoList.stream().filter(c -> c.getExpireDatetime() != null).filter(c -> c.getExpireDatetime().before(overtimeDate)).count();
                            long willOvertimeCount = signInfoVoList.stream().filter(c -> c.getExpireDatetime() != null).filter(c -> c.getExpireDatetime().after(overtimeDate)).filter(c -> c.getExpireDatetime().before(willOvertimeDate)).count();
                            rspBO.setWillOvertimeCount((int)willOvertimeCount);
                            rspBO.setOvertimeCount((int)overtimeCount);
                            rspBO.setItemCount(signInfoVoList.size());
                        }
                        rspBO.setContent(String.valueOf(signInfoVoList.size()));
                    } else {
                        rspBO.setContent("0");
                        rspBO.setItemCount(0);
                        rspBO.setWillOvertimeCount(0);
                        rspBO.setOvertimeCount(0);
                    }
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc(jsonObject.getString("message"));
        return rspBO;
    }
}

