/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.busi.ContractDownloadSignDocumentBusiService;
import com.tydic.contract.busi.bo.ContractDownloadSignDocumentBusiReqBO;
import com.tydic.contract.busi.bo.ContractDownloadSignDocumentBusiRspBO;
import com.tydic.contract.utils.FileTypeJudge;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractDownloadSignDocumentBusiServiceImpl
implements ContractDownloadSignDocumentBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractDownloadSignDocumentBusiServiceImpl.class);
    @Value(value="${SIGNATURE_UPLOAD_IP}")
    private String signDocumentIp;
    private static final String SIGN_DOCUMENT_URL = "/envelopes/download";
    @Autowired
    private FileClient fileClient;
    private static final String OSS_SERVER_URL = "https://dev-zhongtai.oss-cn-beijing.aliyuncs.com/";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContractDownloadSignDocumentBusiRspBO downloadSignDocument(ContractDownloadSignDocumentBusiReqBO reqBO) {
        ContractDownloadSignDocumentBusiRspBO rspBO = new ContractDownloadSignDocumentBusiRspBO();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(this.signDocumentIp + SIGN_DOCUMENT_URL + "?envelopeId=" + reqBO.getEnvelopeId());
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpGet.setConfig(requestConfig);
        httpGet.setHeader("Content-Type", "application/json;charset=utf8");
        httpGet.setHeader("Authorization", reqBO.getAccessToken());
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            BufferedInputStream inputStream = (BufferedInputStream)response.getEntity().getContent();
            String preName = "signDocument-";
            String fileName = preName + String.valueOf(Sequence.getInstance().nextId() + ".pdf");
            String result = this.fileClient.uploadFileByInputStream(OSS_SERVER_URL, fileName, (InputStream)inputStream);
            rspBO.setFileUrl(OSS_SERVER_URL + result);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContractDownloadSignDocumentBusiRspBO downloadSignDocument2(ContractDownloadSignDocumentBusiReqBO reqBO) {
        ContractDownloadSignDocumentBusiRspBO rspBO = new ContractDownloadSignDocumentBusiRspBO();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        log.info("\u83b7\u53d6\u7b7e\u7f72\u6587\u4ef6\u5730\u5740\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)reqBO)));
        HttpGet httpGet = null;
        httpGet = reqBO.getFileId() != null ? new HttpGet(this.signDocumentIp + SIGN_DOCUMENT_URL + "?envelopeId=" + reqBO.getEnvelopeId() + "&contentId=" + reqBO.getFileId()) : new HttpGet(this.signDocumentIp + SIGN_DOCUMENT_URL + "?envelopeId=" + reqBO.getEnvelopeId());
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpGet.setConfig(requestConfig);
        httpGet.setHeader("Content-Type", "application/json;charset=utf8");
        httpGet.setHeader("Authorization", reqBO.getAccessToken());
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream inputStream = response.getEntity().getContent();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[10240];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inputStream.close();
            ByteArrayInputStream fileInputStream = new ByteArrayInputStream(outStream.toByteArray());
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            String fileName = "";
            response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream pdInputStream = response.getEntity().getContent();
            String fieyType = "PDF";
            try {
                fieyType = (Object)((Object)FileTypeJudge.getTypeByIs(pdInputStream)) + "";
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            fileName = "PDF".equals(fieyType) ? "\u4e0a\u4f20\u7684\u6587\u4ef6.pdf" : ("ZIP".equals(fieyType) ? "\u4e0a\u4f20\u7684\u6587\u4ef6.zip" : "\u4e0a\u4f20\u7684\u6587\u4ef6.rar");
            String path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)fileInputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            rspBO.setFileUrl(fileUrl);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

