/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractCceSyncAuditLogAbilityService;
import com.tydic.contract.ability.ContractLegalPushAuditLogAbilityService;
import com.tydic.contract.ability.ContractLegalReturnAbilityService;
import com.tydic.contract.ability.bo.CceReturnContractReqBO;
import com.tydic.contract.ability.bo.ContractAuditLogBO;
import com.tydic.contract.ability.bo.ContractCceSyncAuditLogAbilityReqBO;
import com.tydic.contract.ability.bo.ContractLegalPushAuditLogAbilityReqBO;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.busi.ContractGetLegalApprovalResultBusiService;
import com.tydic.contract.busi.bo.ContractGetLegalApprovalResultBusiServiceReqBO;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.HttpUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractGetLegalApprovalResultBusiServiceImpl
implements ContractGetLegalApprovalResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractGetLegalApprovalResultBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractLegalPushAuditLogAbilityService contractLegalPushAuditLogAbilityService;
    @Autowired
    private ContractCceSyncAuditLogAbilityService contractCceSyncAuditLogAbilityService;
    @Autowired
    private ContractLegalReturnAbilityService contractLegalReturnAbilityService;
    @Value(value="${CONTRACT_LEGAL_GET_URL}")
    private String legalGetResultUrl;
    @Value(value="${CONTRACT_LEGAL_GET_APPROVAL_RECORD_URL}")
    private String legalApprovalRecordUrl;
    @Value(value="${CONTRACT_LEGAL_CONTRACT_STATUS_URL}")
    private String legalContractStatusUrl;

    @Override
    public ContractRspBaseBO getApprovalResult(ContractGetLegalApprovalResultBusiServiceReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (CollectionUtils.isEmpty(reqBO.getContractIds())) {
            throw new ZTBusinessException("\u5165\u53c2\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList rspBOS = new ArrayList();
        for (Long contractId : reqBO.getContractIds()) {
            ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(contractId);
            if (po.getPushLegalContractCode() == null || "".equals(po.getPushLegalContractCode())) continue;
            ContractLegalPushAuditLogAbilityReqBO rspBO = new ContractLegalPushAuditLogAbilityReqBO();
            try {
                String resultMessage;
                String rspStr = HttpUtil.doGet(this.legalGetResultUrl + "?id=" + po.getPushLegalContractCode());
                log.info("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr + "\uff0c\u5165\u53c2:" + po.getPushLegalContractCode());
                JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
                if (!StringUtils.isEmpty((Object)jsonObject.getString("status")) && "0".equals(jsonObject.get((Object)"status")) || (resultMessage = jsonObject.getString("ResultMessage")) == null) continue;
                rspBO = (ContractLegalPushAuditLogAbilityReqBO)JSONObject.parseObject((String)resultMessage, ContractLegalPushAuditLogAbilityReqBO.class);
                rspBO.setAcceptLogType(Integer.valueOf(2));
                this.contractLegalPushAuditLogAbilityService.pushAudit(rspBO);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        log.info("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString(rspBOS));
        return rspBaseBO;
    }

    @Override
    public ContractRspBaseBO getApprovalRecord(ContractGetLegalApprovalResultBusiServiceReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (!CollectionUtils.isEmpty(reqBO.getContractIds())) {
            for (Long contractId : reqBO.getContractIds()) {
                ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(contractId);
                if (po.getPushLegalContractCode() == null || "".equals(po.getPushLegalContractCode())) continue;
                this.cellLegalApprovalRecord(po.getPushLegalContractCode());
            }
        } else if (!CollectionUtils.isEmpty(reqBO.getUpdateApplyIds())) {
            for (Long updateApplyId : reqBO.getUpdateApplyIds()) {
                ContractInfoChangePO changePO = this.contractInfoChangeMapper.selectByPrimaryKey(updateApplyId);
                if (changePO.getPushLegalContractCode() == null || "".equals(changePO.getPushLegalContractCode())) continue;
                this.cellLegalApprovalRecord(changePO.getPushLegalContractCode());
            }
        } else {
            rspBaseBO.setRespCode("8888");
            rspBaseBO.setRespDesc("\u83b7\u53d6\u6cd5\u52a1\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return rspBaseBO;
    }

    @Override
    public ContractRspBaseBO getLegalContractStatus(ContractGetLegalApprovalResultBusiServiceReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (!CollectionUtils.isEmpty(reqBO.getContractIds())) {
            for (Long contractId : reqBO.getContractIds()) {
                ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(contractId);
                if (po.getPushLegalContractCode() == null || "".equals(po.getPushLegalContractCode())) continue;
                this.cellLegalContractStatus(po.getPushLegalContractCode());
            }
        } else if (!CollectionUtils.isEmpty(reqBO.getUpdateApplyIds())) {
            for (Long updateApplyId : reqBO.getUpdateApplyIds()) {
                ContractInfoChangePO po = this.contractInfoChangeMapper.selectByPrimaryKey(updateApplyId);
                if (po.getPushLegalContractCode() == null || "".equals(po.getPushLegalContractCode())) continue;
                this.cellLegalContractStatus(po.getPushLegalContractCode());
            }
        } else {
            rspBaseBO.setRespCode("8888");
            rspBaseBO.setRespDesc("\u83b7\u53d6\u6cd5\u52a1\u5ba1\u6279\u72b6\u6001\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return rspBaseBO;
    }

    public void cellLegalContractStatus(String pushLegalContractCode) {
        try {
            String rspStr = HttpUtil.doGet(this.legalContractStatusUrl + "?id=" + pushLegalContractCode);
            log.info("\u83b7\u53d6\u5408\u540c\u5728\u6cd5\u52a1\u7cfb\u7edf\u72b6\u6001\u62a5\u6587\uff1a" + rspStr + "\uff0c\u5165\u53c2:" + pushLegalContractCode);
            JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
            if (!StringUtils.isEmpty((Object)jsonObject.getString("status"))) {
                if ("3".equals(jsonObject.getString("status"))) {
                    this.approve(pushLegalContractCode);
                } else if ("4".equals(jsonObject.getString("status"))) {
                    this.returnContract(pushLegalContractCode);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void approve(String pushLegalContractCode) {
        ContractLegalPushAuditLogAbilityReqBO rspBO = new ContractLegalPushAuditLogAbilityReqBO();
        try {
            String rspStr = HttpUtil.doGet(this.legalGetResultUrl + "?id=" + pushLegalContractCode);
            log.info("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr + "\uff0c\u5165\u53c2:" + pushLegalContractCode);
            JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
            if (!StringUtils.isEmpty((Object)jsonObject.getString("status")) && "0".equals(jsonObject.get((Object)"status"))) {
                return;
            }
            String resultMessage = jsonObject.getString("ResultMessage");
            if (resultMessage != null) {
                rspBO = (ContractLegalPushAuditLogAbilityReqBO)JSONObject.parseObject((String)resultMessage, ContractLegalPushAuditLogAbilityReqBO.class);
                rspBO.setAcceptLogType(Integer.valueOf(2));
                this.contractLegalPushAuditLogAbilityService.pushAudit(rspBO);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void returnContract(String pushLegalContractCode) {
        try {
            ContractCceSyncAuditLogAbilityReqBO contractCceSyncAuditLogAbilityReqBO;
            String rspStr = HttpUtil.doGet(this.legalApprovalRecordUrl + "?id=" + pushLegalContractCode);
            log.info("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr + "\uff0c\u5165\u53c2:" + pushLegalContractCode);
            JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
            if (!StringUtils.isEmpty((Object)jsonObject.getString("status")) && "0".equals(jsonObject.get((Object)"status"))) {
                return;
            }
            String resultMessage = jsonObject.getString("ResultMessage");
            if (resultMessage != null && (contractCceSyncAuditLogAbilityReqBO = (ContractCceSyncAuditLogAbilityReqBO)JSONObject.parseObject((String)resultMessage, ContractCceSyncAuditLogAbilityReqBO.class)) != null && contractCceSyncAuditLogAbilityReqBO.getAuditLogInfo().size() > 0) {
                ContractAuditLogBO contractAuditLogBO = (ContractAuditLogBO)contractCceSyncAuditLogAbilityReqBO.getAuditLogInfo().get(contractCceSyncAuditLogAbilityReqBO.getAuditLogInfo().size() - 1);
                CceReturnContractReqBO returnContractReqBO = new CceReturnContractReqBO();
                returnContractReqBO.setContractCode(contractAuditLogBO.getContractCode());
                returnContractReqBO.setDealUserName(contractAuditLogBO.getContractApprovalUserName());
                returnContractReqBO.setRemark(contractAuditLogBO.getContractApprovalRemark());
                returnContractReqBO.setAcceptLogType(Integer.valueOf(2));
                this.contractLegalReturnAbilityService.returnContract(returnContractReqBO);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void cellLegalApprovalRecord(String pushLegalContractCode) {
        try {
            String rspStr = HttpUtil.doGet(this.legalApprovalRecordUrl + "?id=" + pushLegalContractCode);
            log.info("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr + "\uff0c\u5165\u53c2:" + pushLegalContractCode);
            JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
            if (!StringUtils.isEmpty((Object)jsonObject.getString("status")) && "0".equals(jsonObject.get((Object)"status"))) {
                return;
            }
            String resultMessage = jsonObject.getString("ResultMessage");
            if (resultMessage != null) {
                ContractCceSyncAuditLogAbilityReqBO contractCceSyncAuditLogAbilityReqBO = (ContractCceSyncAuditLogAbilityReqBO)JSONObject.parseObject((String)resultMessage, ContractCceSyncAuditLogAbilityReqBO.class);
                this.contractCceSyncAuditLogAbilityService.cceSyncAuditLog(contractCceSyncAuditLogAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u8c03\u7528\u83b7\u53d6\u6cd5\u52a1\u4fa7\u5ba1\u6279\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

