/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.contract.busi.ContractHtAddMsgDealBusiService;
import com.tydic.contract.busi.bo.ContractHtAddMsgDealBusiReqBO;
import com.tydic.contract.busi.bo.ContractHtAddMsgDealBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.dyc.ssc.service.scheme.SchemeQryPackCreateUserService;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeQryPackCreateUserBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeQryPackCreateUserReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeQryPackCreateUserRspBO;
import com.tydic.ppc.ability.api.PlanQueryByPlanIdsAbilityService;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractHtAddMsgDealBusiServiceImpl
implements ContractHtAddMsgDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractHtAddMsgDealBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private UccThematerialsearchAbilityService uccThematerialsearchAbilityService;
    @Autowired
    UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;
    @Autowired
    PlanQueryByPlanIdsAbilityService planQueryByPlanIdsAbilityService;
    @Autowired
    private SchemeQryPackCreateUserService schemeQryPackCreateUserService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @Override
    public ContractHtAddMsgDealBusiRspBO addHTMsgDeal(ContractHtAddMsgDealBusiReqBO reqBO) {
        ContractHtAddMsgDealBusiRspBO rspBO = new ContractHtAddMsgDealBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        HashSet<String> notExist = new HashSet();
        if (!CollectionUtils.isEmpty(reqBO.getItemIds())) {
            List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(reqBO.getItemIds());
            notExist = this.buildInfoItem(contractInfoItemPOS);
            if (reqBO.getIsFz() != null && reqBO.getIsFz() == 0) {
                this.getAwardUser(contractInfoItemPOS);
            }
            this.contractInfoItemMapper.htInfoUpdateBatch(contractInfoItemPOS);
        }
        if (reqBO.getContractId() != null && reqBO.getAddHtMsgStatus() != null) {
            ContractInfoPO updatePO = new ContractInfoPO();
            updatePO.setAddHtMsgStatus(reqBO.getAddHtMsgStatus());
            updatePO.setContractId(reqBO.getContractId());
            this.contractInfoMapper.updateAddHtMsgStatus(updatePO);
        }
        if (!CollectionUtils.isEmpty(notExist)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u7269\u6599\u4fe1\u606f\u5931\u8d25" + notExist);
            rspBO.setNotExist(notExist);
        }
        return rspBO;
    }

    private Set<String> buildInfoItem(List<ContractInfoItemPO> contractInfoItemPOList) {
        Set<String> notExist = this.getCatelogInfo(contractInfoItemPOList);
        this.getBuyerAndUserCompanyName(contractInfoItemPOList);
        return notExist;
    }

    private Set<String> getCatelogInfo(List<ContractInfoItemPO> contractInfoItemTmpPOS) {
        HashSet<String> notExist = new HashSet<String>();
        if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
            Set collect = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialCode()) && (StringUtils.isEmpty((Object)e.getCatalogCode()) || StringUtils.isEmpty((Object)e.getMaterialLongName()))).map(ContractInfoItemPO::getMaterialCode).collect(Collectors.toSet());
            ArrayList materialCodes = new ArrayList();
            materialCodes.addAll(collect);
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
                uccThematerialsearchAbilityReqBO.setMaterialCodes(materialCodes);
                uccThematerialsearchAbilityReqBO.setPageNo(1);
                uccThematerialsearchAbilityReqBO.setPageSize(materialCodes.size());
                UccThematerialsearchAbilityRspBO uccThematerialsearchAbilityRspBO = this.uccThematerialsearchAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
                if ("0000".equals(uccThematerialsearchAbilityRspBO.getRespCode())) {
                    List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccThematerialsearchAbilityRspBO.getRows()), UccEMdmMaterialBO.class);
                    if (!CollectionUtils.isEmpty((Collection)rows)) {
                        Map<String, List<UccEMdmMaterialBO>> materialCodeMap = rows.stream().collect(Collectors.groupingBy(UccEMdmMaterialBO::getMaterialCode));
                        contractInfoItemTmpPOS.forEach(e -> {
                            if (materialCodeMap.containsKey(e.getMaterialCode())) {
                                UccEMdmMaterialBO uccEMdmMaterialBO = (UccEMdmMaterialBO)((List)materialCodeMap.get(e.getMaterialCode())).get(0);
                                e.setCatalogId(uccEMdmMaterialBO.getCatalogId().toString());
                                e.setCatalogCode(uccEMdmMaterialBO.getCatalogCode());
                                e.setCatalogName(uccEMdmMaterialBO.getCatalogName());
                                e.setMaterialName(uccEMdmMaterialBO.getMaterialName());
                                e.setMaterialId(uccEMdmMaterialBO.getMaterialId());
                                e.setMaterialLongName(uccEMdmMaterialBO.getLongDesc());
                                e.setSpec(uccEMdmMaterialBO.getSpec());
                                e.setMaterialDesc(uccEMdmMaterialBO.getLongDesc());
                            } else {
                                notExist.add(e.getMaterialCode());
                            }
                        });
                    } else {
                        notExist.addAll(materialCodes);
                    }
                }
            } else {
                log.info("\u7269\u6599\u4fe1\u606f\u5982\u679c\u4e4b\u524d\u5df2\u7ecf\u5904\u7406\u4e86\uff0c\u5c31\u4e0d\u9700\u8981\u518d\u5904\u7406");
            }
        }
        return notExist;
    }

    private void getBuyerAndUserCompanyName(List<ContractInfoItemPO> contractInfoItemTmpPOS) {
        Set decCompanyCodes = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getErpOrgCode()) && StringUtils.isEmpty((Object)e.getBuyerNo())).map(ContractInfoItemPO::getErpOrgCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(decCompanyCodes)) {
            UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
            ArrayList organizationCodes = new ArrayList();
            organizationCodes.addAll(decCompanyCodes);
            umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(organizationCodes);
            UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
            if ("0000".equals(umcContractQueryBuyerInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
                Map<String, List<UmcEntityOrgSubBO>> oIdMap = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcEntityOrgSubBO::getOrganizationId));
                contractInfoItemTmpPOS.forEach(e -> {
                    if (!CollectionUtils.isEmpty((Collection)((Collection)oIdMap.get(e.getErpOrgCode())))) {
                        UmcEntityOrgSubBO umcEntityOrgSubBO = (UmcEntityOrgSubBO)((List)oIdMap.get(e.getErpOrgCode())).get(0);
                        e.setBuyerId(umcEntityOrgSubBO.getEntityId());
                        if (umcEntityOrgSubBO.getEntityId() != null) {
                            e.setBuyerNo(umcEntityOrgSubBO.getEntityId().toString());
                        }
                        e.setBuyerName(umcEntityOrgSubBO.getEntityName());
                    }
                });
            }
        }
    }

    private void getAwardUser(List<ContractInfoItemPO> contractInfoItemPOS) {
        block7: {
            ArrayList<SchemeQryPackCreateUserBO> reqBos = new ArrayList<SchemeQryPackCreateUserBO>();
            for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOS) {
                if (contractInfoItemPO.getSchemeType() == null || StringUtils.isEmpty((Object)contractInfoItemPO.getPackId())) continue;
                SchemeQryPackCreateUserBO bo = new SchemeQryPackCreateUserBO();
                bo.setPackId(contractInfoItemPO.getPackId());
                bo.setSchemeType(contractInfoItemPO.getSchemeType());
                reqBos.add(bo);
            }
            if (!CollectionUtils.isEmpty(reqBos)) {
                log.info("\u67e5\u8be2\u975e\u62db\u5305\u539f\u59cb\u4eba\u5f00\u59cb\uff0c\u5165\u53c2" + JSONObject.toJSONString(reqBos));
                SchemeQryPackCreateUserReqBO qryPackCreateUserReqBO = new SchemeQryPackCreateUserReqBO();
                qryPackCreateUserReqBO.setBos(reqBos);
                try {
                    SchemeQryPackCreateUserRspBO schemeQryPackCreateUserRspBO = this.schemeQryPackCreateUserService.qryPackCreateUser(qryPackCreateUserReqBO);
                    log.info("\u67e5\u8be2\u975e\u62db\u5305\u539f\u59cb\u4eba\u5f00\u59cb\uff0c\u51fa\u53c2" + JSONObject.toJSONString((Object)schemeQryPackCreateUserRspBO));
                    if ("0000".equals(schemeQryPackCreateUserRspBO.getRespCode())) {
                        if (!CollectionUtils.isEmpty((Collection)schemeQryPackCreateUserRspBO.getBos())) {
                            Map<String, SchemeQryPackCreateUserBO> packIdMap = schemeQryPackCreateUserRspBO.getBos().stream().collect(Collectors.toMap(o -> o.getPackId().toString(), e -> e));
                            for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOS) {
                                if (!packIdMap.containsKey(contractInfoItemPO.getPackId().toString())) continue;
                                SchemeQryPackCreateUserBO createUserBO = packIdMap.get(contractInfoItemPO.getPackId().toString());
                                contractInfoItemPO.setAwardUserName(createUserBO.getAwardUserName());
                                contractInfoItemPO.setAwardEmployeeNumber(createUserBO.getAwardEmployeeNumber());
                            }
                        }
                        break block7;
                    }
                    throw new ZTBusinessException(schemeQryPackCreateUserRspBO.getRespDesc());
                }
                catch (Exception e2) {
                    log.info("\u67e5\u8be2\u975e\u62db\u5305\u539f\u59cb\u4eba\u5f02\u5e38" + e2.getMessage());
                }
            }
        }
    }
}

