/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.busi.ContractItemUpdateBusiService;
import com.tydic.contract.busi.bo.ContractItemUpdateBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemUpdateBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.utils.DateUtils;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class ContractItemUpdateBusiServiceImpl
implements ContractItemUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemUpdateBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;

    @Override
    public ContractItemUpdateBusiRspBO contractItemUpdate(ContractItemUpdateBusiReqBO reqBO) {
        ContractItemUpdateBusiRspBO contractItemUpdateBusiRspBO = new ContractItemUpdateBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().size() < 1) {
            contractItemUpdateBusiRspBO.setRespCode("8888");
            contractItemUpdateBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return contractItemUpdateBusiRspBO;
        }
        for (ContractItemAbilityBO temp : reqBO.getContractDetailList()) {
            int flag;
            ContractInfoItemPO contractItemPo = new ContractInfoItemPO();
            if (temp.getItemId() == null) {
                contractItemUpdateBusiRspBO.setRespCode("8888");
                contractItemUpdateBusiRspBO.setRespDesc("\u660e\u7ec6Id\u4e3a\u7a7a\uff01");
                return contractItemUpdateBusiRspBO;
            }
            BeanUtils.copyProperties((Object)temp, (Object)contractItemPo);
            if (contractItemPo.getTaxAmount() != null) {
                contractItemPo.setTaxAmount(contractItemPo.getTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (contractItemPo.getNotIncludingTaxAmount() != null) {
                contractItemPo.setNotIncludingTaxAmount(contractItemPo.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (contractItemPo.getTax() != null) {
                contractItemPo.setTax(contractItemPo.getTax().setScale(2, 4).stripTrailingZeros());
            }
            if ((flag = this.contractInfoItemMapper.updateByPrimaryKeySelective(contractItemPo)) >= 1) continue;
            contractItemUpdateBusiRspBO.setRespCode("8888");
            contractItemUpdateBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff01");
            return contractItemUpdateBusiRspBO;
        }
        contractItemUpdateBusiRspBO.setRespCode("0000");
        contractItemUpdateBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return contractItemUpdateBusiRspBO;
    }

    @Override
    public ContractItemUpdateBusiRspBO contractItemUpdateTemp(ContractItemUpdateBusiReqBO reqBO) {
        Set erpOrgCodes;
        ContractItemUpdateBusiRspBO contractItemUpdateBusiRspBO = new ContractItemUpdateBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().size() < 1) {
            contractItemUpdateBusiRspBO.setRespCode("8888");
            contractItemUpdateBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return contractItemUpdateBusiRspBO;
        }
        reqBO.getContractDetailList().forEach(e -> {
            if (StringUtils.isEmpty((Object)e.getSaleStatus()) && e.getSaleStatus() == 2 && StringUtils.isEmpty((Object)e.getSaleAmount())) {
                throw new ZTBusinessException("\u53ef\u4e0b\u5355\u6570\u91cf\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        });
        Map<Object, Object> oIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(reqBO.getContractDetailList()) && !CollectionUtils.isEmpty(erpOrgCodes = reqBO.getContractDetailList().stream().filter(e -> !StringUtils.isEmpty((Object)e.getErpOrgCode())).map(ContractItemAbilityBO::getErpOrgCode).collect(Collectors.toSet()))) {
            UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
            ArrayList organizationCodes = new ArrayList();
            organizationCodes.addAll(erpOrgCodes);
            umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(organizationCodes);
            UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
            if ("0000".equals(umcContractQueryBuyerInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
                oIdMap = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcEntityOrgSubBO::getOrganizationId));
            }
        }
        Date date = new Date();
        for (ContractItemAbilityBO temp : reqBO.getContractDetailList()) {
            if (temp.getItemId() == null && temp.getRelateId() == null) {
                contractItemUpdateBusiRspBO.setRespCode("8888");
                contractItemUpdateBusiRspBO.setRespDesc("\u4e34\u65f6\u8868\u660e\u7ec6Id\u4e0e\u5408\u540cid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
                return contractItemUpdateBusiRspBO;
            }
            this.translate(temp);
            ContractInfoItemTmpPO contractItemTmpPo = (ContractInfoItemTmpPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)temp), ContractInfoItemTmpPO.class);
            if (oIdMap.containsKey(contractItemTmpPo.getErpOrgCode())) {
                UmcEntityOrgSubBO umcEntityOrgSubBO = (UmcEntityOrgSubBO)((List)oIdMap.get(contractItemTmpPo.getErpOrgCode())).get(0);
                contractItemTmpPo.setBuyerId(umcEntityOrgSubBO.getEntityId());
                if (umcEntityOrgSubBO.getEntityId() != null) {
                    contractItemTmpPo.setBuyerNo(umcEntityOrgSubBO.getEntityId().toString());
                }
                contractItemTmpPo.setBuyerName(umcEntityOrgSubBO.getEntityName());
            }
            contractItemTmpPo.setUpdateUserId(reqBO.getUserId());
            contractItemTmpPo.setUpdateUserName(reqBO.getName());
            contractItemTmpPo.setUpdateTime(date);
            contractItemTmpPo.setExtFiled1("ContractItemUpdateAbilityService\u4fee\u6539\u4e34\u65f6\u8868\u670d\u52a1\u4fee\u6539\u65f6\u95f4" + DateUtils.dateToStrYYYYMMddHHmmss(date) + " \u4fee\u6539userId" + reqBO.getUserId() + "\u5220\u9664\u6807\u8bb0delFlag" + contractItemTmpPo.getDelFlag());
            if (contractItemTmpPo.getTaxAmount() != null) {
                contractItemTmpPo.setTaxAmount(contractItemTmpPo.getTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (contractItemTmpPo.getNotIncludingTaxAmount() != null) {
                contractItemTmpPo.setNotIncludingTaxAmount(contractItemTmpPo.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (contractItemTmpPo.getTax() != null) {
                contractItemTmpPo.setTax(contractItemTmpPo.getTax().setScale(2, 4).stripTrailingZeros());
            }
            int flag = this.contractInfoItemTmpMapper.update(contractItemTmpPo);
        }
        contractItemUpdateBusiRspBO.setRespCode("0000");
        contractItemUpdateBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return contractItemUpdateBusiRspBO;
    }

    public void translate(ContractItemAbilityBO contractItemAbilityBO) {
        if (contractItemAbilityBO.getTaxAmount() != null && contractItemAbilityBO.getNotIncludingTaxAmount() != null) {
            contractItemAbilityBO.setTax(contractItemAbilityBO.getTaxAmount().subtract(contractItemAbilityBO.getNotIncludingTaxAmount()));
        }
    }
}

