/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.bo.ContractQryExpiredCheckAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryExpiredCheckAbilityRspBO;
import com.tydic.contract.busi.ContractQryExpiredCheckBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryExpiredCheckBusiServiceImpl
implements ContractQryExpiredCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryExpiredCheckBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Resource(name="planAgrExpireProxyProducer")
    private ProxyMessageProducer planAgrExpireProxyProducer;
    @Value(value="${PLAN_AGR_EXPIRE_TOPIC:PLAN_AGR_EXPIRE_TOPIC}")
    private String planAgrExpireTopic;
    @Value(value="${PLAN_AGR_EXPIRE_TAG:*}")
    private String planAgrExpireTag;

    @Override
    public ContractQryExpiredCheckAbilityRspBO dealExpiredCheck(ContractQryExpiredCheckAbilityReqBO reqBO) {
        ContractQryExpiredCheckAbilityRspBO rspBO = new ContractQryExpiredCheckAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ContractInfoPO searchPO = new ContractInfoPO();
        ArrayList<Integer> contractTypes = new ArrayList<Integer>();
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        searchPO.setContractTypes(contractTypes);
        searchPO.setExpiredCheckFlag(0);
        searchPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        searchPO.setSearchDate(new Date());
        List<Long> expiredList = this.contractInfoMapper.qryExpiredList(searchPO);
        if (!CollectionUtils.isEmpty(expiredList)) {
            this.contractInfoMapper.batchUpdateContractExpiredCheckFlag(expiredList, 1);
            int pointsDataLimit = 100;
            Integer size = expiredList.size();
            if (size > pointsDataLimit) {
                if (pointsDataLimit < size) {
                    int part = size / pointsDataLimit;
                    System.out.println("\u5171\u6709 \uff1a " + size + "\u6761\uff0c\uff01" + " \u5206\u4e3a \uff1a" + part + "\u6279");
                    for (int i = 0; i < part; ++i) {
                        List<Long> listPage = expiredList.subList(0, pointsDataLimit);
                        this.sendMsg(listPage);
                        expiredList.subList(0, pointsDataLimit).clear();
                    }
                    if (!expiredList.isEmpty()) {
                        this.sendMsg(expiredList);
                    }
                }
            } else {
                this.sendMsg(expiredList);
            }
        }
        return rspBO;
    }

    private void sendMsg(List<Long> expiredList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agreementIds", expiredList);
        try {
            log.info("\u53d1\u9001\u7ed9\u8ba1\u5212\u5206\u6d41\u540c\u6b65\u534f\u8bae\u8fc7\u671f\u6d88\u606f\uff1a" + jsonObject.toJSONString());
            this.planAgrExpireProxyProducer.send(new ProxyMessage(this.planAgrExpireTopic, this.planAgrExpireTag, jsonObject.toJSONString()));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7ed9\u8ba1\u5212\u5206\u6d41\u540c\u6b65\u534f\u8bae\u8fc7\u671f\u6d88\u606f\u5f02\u5e38\uff1a\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + jsonObject.toJSONString());
            throw new ZTBusinessException("\u53d1\u9001\u7ed9\u8ba1\u5212\u5206\u6d41\u540c\u6b65\u534f\u8bae\u8fc7\u671f\u6d88\u606f\u5f02\u5e38\uff1a\uff1a" + e.getMessage());
        }
    }
}

