/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.bo.ContractItemBO;
import com.tydic.contract.busi.ContractQryItemBusiService;
import com.tydic.contract.busi.bo.ContractQryItemBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryItemBusiRspBO;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.po.ContractItemPo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryItemBusiServiceImpl
implements ContractQryItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryItemBusiServiceImpl.class);
    @Autowired
    private ContractItemMapper contractItemMapper;

    @Override
    public ContractQryItemBusiRspBO qryContractItem(ContractQryItemBusiReqBO reqBO) {
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractItemMapper.selectByRelateId(reqBO.getRelateId()));
        ContractQryItemBusiRspBO rspBO = new ContractQryItemBusiRspBO();
        if (!CollectionUtils.isEmpty((Collection)page.getResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<ContractItemBO> rows = this.transResultData(page.getResult());
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractItemBO> transResultData(List<ContractItemPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractItemBO.class);
        for (ContractItemBO row : rows) {
            try {
                row.setUnitPriceMoney(MoneyUtils.Long2BigDecimal((Long)row.getUnitPrice()));
                row.setTotalAmountMoney(MoneyUtils.Long2BigDecimal((Long)row.getTotalAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u5316\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        return rows;
    }
}

