/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.contract.ability.bo.ContractReqInfoBO;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.ability.bo.TodoAddWaitDoneAbilityParamBO;
import com.tydic.contract.ability.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.contract.ability.bo.TodoCancelWaitDoneReqBO;
import com.tydic.contract.ability.bo.other.ContractAuditCancelAbitityReqBO;
import com.tydic.contract.busi.ContractTodoBusiService;
import com.tydic.contract.busi.bo.TodoAddAlreadyDoneAbilityParamBO;
import com.tydic.contract.busi.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.contract.busi.bo.TodoWaitDoneReqBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractTodoBusiServiceImpl
implements ContractTodoBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractTodoBusiServiceImpl.class);
    @Resource(name="pushAgentProvider")
    private ProxyMessageProducer pushAgentProvider;
    @Value(value="${TODO_ADD_WAIT_DONE_TOPIC:TODO_ADD_WAIT_DONE_TOPIC}")
    private String todoAddWaitDoneTopic;
    @Value(value="${TODO_ADD_WAIT_DONE_TAG:*}")
    private String todoAddWaitDoneTag;
    @Resource(name="cancelAgentProvider")
    private ProxyMessageProducer cancelAgentProvider;
    @Value(value="${TODO_CANCEL_WAIT_DONE_TOPIC:TODO_CANCEL_WAIT_DONE_TOPIC}")
    private String todoCancelWaitDoneTopic;
    @Value(value="${TODO_CANCEL_WAIT_DONE_TAG:*}")
    private String todoCancelWaitDoneTag;
    @Resource(name="todoAddAlreadyDoneProvider")
    private ProxyMessageProducer todoAddAlreadyDoneProvider;
    @Value(value="${TODO_ADD_ALREADY_DONE_TOPIC:TODO_ADD_ALREADY_DONE_TOPIC}")
    private String todoAddAlreadyDoneTopic;
    @Value(value="${TODO_ADD_ALREADY_DONE_TOPIC:*}")
    private String todoAddAlreadyDoneTag;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    List<String> lognAgrContractTypes = Arrays.asList("5", "6", "9", "22", "32", "33");
    List<String> unitContractTypes = Arrays.asList("11", "12", "13", "21");
    List<String> saleContractTypes = Arrays.asList("8", "10", "20");
    String sinceMiningSpotContractTypes = "7";
    List<String> funtionContractTypes = Arrays.asList("15", "16", "30", "31");

    @Override
    public void todoAddWaitDone(TodoWaitDoneReqBo po, ContractReqInfoBO reqInfoBO) {
        boolean isChange = false;
        String busiName = "";
        if (po.getContractChangeId() != null) {
            isChange = true;
            busiName = "\u53d8\u66f4";
        }
        TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
        List<UserBO> userBOS = this.qryDealApprovalPersones(isChange ? po.getContractChangeId().toString() : po.getContractId().toString(), reqInfoBO, todoAddWaitDoneAbilityReqBO);
        log.info("***************\u5408\u540c\u63a8\u9001\u4ee3\u529e\u67e5\u8be2\u7528\u6237\u8fd4\u56de***************\uff1a" + JSON.toJSONString(userBOS));
        if (!CollectionUtils.isEmpty(userBOS)) {
            todoAddWaitDoneAbilityReqBO.setCenterCode("contract");
            String contractType = isChange ? po.getContractChangeType().toString() : po.getContractType().toString();
            todoAddWaitDoneAbilityReqBO.setContractType(contractType);
            todoAddWaitDoneAbilityReqBO.setExt1(po.getContractName());
            if (this.lognAgrContractTypes.contains(contractType)) {
                todoAddWaitDoneAbilityReqBO.setBusiCode(isChange ? "6019" : "6018");
                todoAddWaitDoneAbilityReqBO.setBusiName("\u96c6\u91c7\u5408\u540c" + busiName + "\u5ba1\u6279");
            } else if (this.unitContractTypes.contains(contractType)) {
                todoAddWaitDoneAbilityReqBO.setBusiCode(isChange ? "6023" : "6021");
                todoAddWaitDoneAbilityReqBO.setBusiName("\u5355\u4f4d\u5408\u540c" + busiName + "\u5ba1\u6279");
            } else if (this.saleContractTypes.contains(contractType)) {
                todoAddWaitDoneAbilityReqBO.setBusiCode(isChange ? "6006" : "6005");
                todoAddWaitDoneAbilityReqBO.setBusiName("\u9500\u552e\u5408\u540c" + busiName + "\u5ba1\u6279");
            } else if (this.sinceMiningSpotContractTypes.equals(contractType)) {
                todoAddWaitDoneAbilityReqBO.setBusiCode(isChange ? "6004" : "6003");
                todoAddWaitDoneAbilityReqBO.setBusiName("\u91c7\u8d2d\u6807\u51c6\u5408\u540c" + busiName + "\u5ba1\u6279");
            } else if (this.funtionContractTypes.contains(contractType)) {
                todoAddWaitDoneAbilityReqBO.setBusiCode(isChange ? "6033" : "6032");
                todoAddWaitDoneAbilityReqBO.setBusiName("\u804c\u80fd\u5408\u540c" + busiName + "\u5ba1\u6279");
            } else {
                return;
            }
            todoAddWaitDoneAbilityReqBO.setSystemCode(Integer.valueOf(1));
            todoAddWaitDoneAbilityReqBO.setOperatorId(reqInfoBO.getUsername());
            todoAddWaitDoneAbilityReqBO.setOperatorName(reqInfoBO.getName());
            ArrayList<TodoAddWaitDoneAbilityParamBO> paramBOList = new ArrayList<TodoAddWaitDoneAbilityParamBO>();
            for (UserBO itemBO : userBOS) {
                TodoAddWaitDoneAbilityParamBO paramBO = new TodoAddWaitDoneAbilityParamBO();
                if (isChange) {
                    paramBO.setObjId(po.getContractChangeId().toString());
                    paramBO.setObjNo(po.getContractChangeCode());
                } else {
                    paramBO.setObjId(po.getContractId().toString());
                    paramBO.setObjNo(po.getContractCode());
                }
                paramBO.setHandleUserName(itemBO.getName());
                paramBO.setHandleUserNo(itemBO.getLoginName());
                paramBOList.add(paramBO);
            }
            todoAddWaitDoneAbilityReqBO.setWaitDoneList(paramBOList);
            if (isChange) {
                ContractInfoChangePO contractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(po.getContractChangeId());
                if (contractInfoChangePO != null) {
                    todoAddWaitDoneAbilityReqBO.setCreateId(contractInfoChangePO.getCreateUserCode());
                    todoAddWaitDoneAbilityReqBO.setCreateName(contractInfoChangePO.getCreateUserName());
                }
            } else {
                ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(po.getContractId());
                if (contractInfoPO != null) {
                    todoAddWaitDoneAbilityReqBO.setCreateId(contractInfoPO.getCreateUserCode());
                    todoAddWaitDoneAbilityReqBO.setCreateName(contractInfoPO.getCreateUserName());
                }
            }
            try {
                log.info("***************\u5408\u540c\u63a8\u9001\u4ee3\u529e***************\uff1a" + JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
                this.pushAgentProvider.send(new ProxyMessage(this.todoAddWaitDoneTopic, this.todoAddWaitDoneTag, JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO)));
            }
            catch (Exception e) {
                log.error("\u5408\u540c\u63a8\u9001\u4ee3\u529e\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
            }
        }
    }

    @Override
    public void todoCancelWaitDone(TodoWaitDoneReqBo po, ContractReqInfoBO reqInfoBO, List<UserBO> userBOS) {
        log.info("-----------\u53d6\u6d88\u5408\u540c\u4ee3\u529e\u5165\u53c2po\uff1a" + JSON.toJSONString((Object)po));
        log.info("-----------\u53d6\u6d88\u5408\u540c\u4ee3\u529e\u7528\u6237userBOS\uff1a" + JSON.toJSONString(userBOS));
        log.info("-----------\u53d6\u6d88\u5408\u540c\u4ee3\u529e\u7528\u6237reqInfoBO\uff1a" + JSON.toJSONString((Object)reqInfoBO));
        if (!CollectionUtils.isEmpty(userBOS)) {
            String contractType;
            boolean ischange = false;
            if (po.getContractChangeId() != null) {
                ischange = true;
            }
            TodoCancelWaitDoneReqBO todoCancelWaitDoneReqBO = new TodoCancelWaitDoneReqBO();
            todoCancelWaitDoneReqBO.setCenterCode("contract");
            todoCancelWaitDoneReqBO.setOperatorId(reqInfoBO.getUsername());
            todoCancelWaitDoneReqBO.setOperatorName(reqInfoBO.getName());
            String string = contractType = ischange ? po.getContractChangeType().toString() : po.getContractType().toString();
            if (this.lognAgrContractTypes.contains(contractType)) {
                todoCancelWaitDoneReqBO.setBusiCode(ischange ? "6019" : "6018");
            } else if (this.unitContractTypes.contains(contractType)) {
                todoCancelWaitDoneReqBO.setBusiCode(ischange ? "6023" : "6021");
            } else if (this.saleContractTypes.contains(contractType)) {
                todoCancelWaitDoneReqBO.setBusiCode(ischange ? "6006" : "6005");
            } else if (this.sinceMiningSpotContractTypes.equals(contractType)) {
                todoCancelWaitDoneReqBO.setBusiCode(ischange ? "6004" : "6003");
            } else if (this.funtionContractTypes.contains(contractType)) {
                todoCancelWaitDoneReqBO.setBusiCode(ischange ? "6033" : "6032");
            } else {
                return;
            }
            ArrayList<TodoAddWaitDoneAbilityParamBO> paramBOS = new ArrayList<TodoAddWaitDoneAbilityParamBO>();
            for (UserBO userbo : userBOS) {
                TodoAddWaitDoneAbilityParamBO paramBO = new TodoAddWaitDoneAbilityParamBO();
                paramBO.setObjId(ischange ? po.getContractChangeId().toString() : po.getContractId().toString());
                if ("1".equals(po.getCancelType().toString()) && userbo.getLoginName().equals(reqInfoBO.getUsername())) continue;
                paramBO.setHandleUserNo(userbo.getLoginName());
                paramBOS.add(paramBO);
            }
            todoCancelWaitDoneReqBO.setCancelList(paramBOS);
            try {
                log.info("***************\u53d6\u6d88\u5408\u540c\u4ee3\u529e***************\uff1a" + JSON.toJSONString((Object)todoCancelWaitDoneReqBO));
                this.cancelAgentProvider.send(new ProxyMessage(this.todoCancelWaitDoneTopic, this.todoCancelWaitDoneTag, JSON.toJSONString((Object)todoCancelWaitDoneReqBO)));
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u5408\u540c\u4ee3\u529e\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)todoCancelWaitDoneReqBO));
            }
        }
    }

    @Override
    public void todoAlreadyDtoneWrite(TodoWaitDoneReqBo po, ContractReqInfoBO reqInfoBO) {
        boolean ischange = false;
        if (po.getContractChangeId() != null) {
            ischange = true;
        }
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setCenterCode("contract");
        String contractType = ischange ? po.getContractChangeType().toString() : po.getContractType().toString();
        todoAddAlreadyDoneAbilityReqBO.setContractType(contractType);
        if (this.lognAgrContractTypes.contains(contractType)) {
            todoAddAlreadyDoneAbilityReqBO.setBusiCode(ischange ? "6019" : "6018");
        } else if (this.unitContractTypes.contains(contractType)) {
            todoAddAlreadyDoneAbilityReqBO.setBusiCode(ischange ? "6023" : "6021");
        } else if (this.saleContractTypes.contains(contractType)) {
            todoAddAlreadyDoneAbilityReqBO.setBusiCode(ischange ? "6006" : "6005");
        } else if (this.sinceMiningSpotContractTypes.equals(contractType)) {
            todoAddAlreadyDoneAbilityReqBO.setBusiCode(ischange ? "6004" : "6003");
        } else if (this.funtionContractTypes.contains(contractType)) {
            todoAddAlreadyDoneAbilityReqBO.setBusiCode(ischange ? "6033" : "6032");
        } else {
            return;
        }
        todoAddAlreadyDoneAbilityReqBO.setHandleUserNo(reqInfoBO.getUsername());
        todoAddAlreadyDoneAbilityReqBO.setOperatorId(reqInfoBO.getUsername());
        todoAddAlreadyDoneAbilityReqBO.setOperatorName(reqInfoBO.getName());
        ArrayList<TodoAddAlreadyDoneAbilityParamBO> paramBOList = new ArrayList<TodoAddAlreadyDoneAbilityParamBO>();
        TodoAddAlreadyDoneAbilityParamBO paramBO = new TodoAddAlreadyDoneAbilityParamBO();
        paramBO.setObjId(ischange ? po.getContractChangeId().toString() : po.getContractId().toString());
        if ("1".equals(po.getDealResult().toString())) {
            paramBO.setAuditStatus(true);
            if (po.getFinishYn().booleanValue()) {
                paramBO.setFinishTime(new Date());
                paramBO.setFinishYn(true);
            } else {
                paramBO.setFinishYn(false);
            }
        } else {
            paramBO.setAuditStatus(false);
            paramBO.setFinishTime(new Date());
            paramBO.setFinishYn(true);
        }
        paramBO.setAuditRemark(po.getAuditRemark());
        paramBOList.add(paramBO);
        todoAddAlreadyDoneAbilityReqBO.setDoneList(paramBOList);
        log.error("\u5f53\u524d\u83b7\u53d6\u5230\u7684ContractId\u4e3a\uff1a{}", (Object)po.getContractId());
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(po.getContractId());
        if (contractInfoPO != null) {
            todoAddAlreadyDoneAbilityReqBO.setCreateId(contractInfoPO.getCreateUserCode());
            todoAddAlreadyDoneAbilityReqBO.setCreateName(contractInfoPO.getCreateUserName());
        }
        try {
            log.info("***************\u63a8\u9001\u5408\u540c\u5df2\u529e*******\uff1a" + JSON.toJSONString((Object)todoAddAlreadyDoneAbilityReqBO));
            this.todoAddAlreadyDoneProvider.send(new ProxyMessage(this.todoAddAlreadyDoneTopic, this.todoAddAlreadyDoneTag, JSON.toJSONString((Object)todoAddAlreadyDoneAbilityReqBO)));
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5408\u540c\u5df2\u529e\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)todoAddAlreadyDoneAbilityReqBO));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ContractRspBaseBO handTodoAddWaitDone(ContractAuditCancelAbitityReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        boolean ischange = false;
        if (reqBO == null) throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqBO.getUpdateApplyId() != null) {
            ischange = true;
        }
        ContractInfoPO po = null;
        ContractInfoChangePO changePO = null;
        if (ischange) {
            changePO = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
        } else {
            po = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        }
        if (ischange) {
            if (changePO == null || !ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE.equals(changePO.getModifyStatus())) throw new ZTBusinessException("\u53d8\u66f4\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u63a8\u9001\u4ee3\u529e");
            TodoWaitDoneReqBo todoWaitDoneReqBo = new TodoWaitDoneReqBo();
            todoWaitDoneReqBo.setContractChangeId(changePO.getUpdateApplyId());
            todoWaitDoneReqBo.setContractChangeCode(changePO.getUpdateApplyCode());
            todoWaitDoneReqBo.setContractChangeType(changePO.getContractType());
            this.todoAddWaitDone(todoWaitDoneReqBo, (ContractReqInfoBO)reqBO);
        } else {
            if (po == null || !ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL.equals(po.getContractStatus())) throw new ZTBusinessException("\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u63a8\u9001\u4ee3\u529e");
            TodoWaitDoneReqBo todoWaitDoneReqBo = new TodoWaitDoneReqBo();
            todoWaitDoneReqBo.setContractId(po.getContractId());
            todoWaitDoneReqBo.setContractCode(po.getContractCode());
            todoWaitDoneReqBo.setContractType(po.getContractType());
            this.todoAddWaitDone(todoWaitDoneReqBo, (ContractReqInfoBO)reqBO);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u6210\u529f");
        return rspBaseBO;
    }

    @Override
    public List<UserBO> qryDealApprovalPersones(String objId, ContractReqInfoBO reqBO, TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO) {
        List logPOS;
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(Integer.valueOf(1));
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(999));
        uacQryAuditLogReqBO.setObjId(objId);
        uacQryAuditLogReqBO.setObjType(Integer.valueOf(1));
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        log.info("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if ("0000".equals(uacQryAuditLogRspBO.getRespCode()) && (logPOS = uacQryAuditLogRspBO.getRows()).size() > 0) {
            String nextStationId = ((ApprovalLogBO)logPOS.get(0)).getNextStationId();
            if (Objects.nonNull(todoAddWaitDoneAbilityReqBO)) {
                todoAddWaitDoneAbilityReqBO.setExt7(((ApprovalLogBO)logPOS.get(0)).getAuditOrderId() + "");
                todoAddWaitDoneAbilityReqBO.setExt8(((ApprovalLogBO)logPOS.get(0)).getId() + "");
                todoAddWaitDoneAbilityReqBO.setRemark(((ApprovalLogBO)logPOS.get(0)).getNextStepName());
            }
            if (!StringUtils.isBlank((String)nextStationId)) {
                DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
                dycStationOrgSelectUserNameReqBO.setOrgIdWeb(reqBO.getOrgId());
                DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                    return dycStationOrgSelectUserNameRspBO.getUserList();
                }
            }
        }
        return new ArrayList<UserBO>();
    }
}

