/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.contract.atom.InterFaceContractFzSyncService;
import com.tydic.contract.atom.bo.InterFaceContractFzSyncReqBo;
import com.tydic.contract.atom.bo.InterFaceContractFzSyncReqFileBo;
import com.tydic.contract.busi.ContractPushErpBusiService;
import com.tydic.contract.busi.ContractPushPlanBusiService;
import com.tydic.contract.busi.bo.ContractPushErpBusiReqBO;
import com.tydic.contract.busi.bo.ContractPushErpBusiRspBO;
import com.tydic.contract.busi.bo.ContractPushPlanBusiReqBo;
import com.tydic.contract.busi.bo.ContractPushPlanBusiRspBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContracRelPushCodeLogMapper;
import com.tydic.contract.dao.CContractInfoPushErpLogMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContracRelPushCodeLogPO;
import com.tydic.contract.po.CContractInfoPushErpPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.DateUtils;
import com.tydic.contract.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ContractPushErpConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(ContractPushErpConsumer.class);
    @Autowired
    private ContractPushErpBusiService contractPushErpBusiService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CContractInfoPushErpLogMapper cContractInfoPushErpLogMapper;
    @Autowired
    private ContractPushPlanBusiService contractPushPlanBusiService;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Value(value="${contract_zb_sync_flag:false}")
    private boolean pushFlag;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private InterFaceContractFzSyncService interFaceContractFzSyncService;
    @Autowired
    private CContracRelPushCodeLogMapper cContracRelPushCodeLogMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        String content = message.getContent();
        log.info("\u63a8\u9001erp-\u6d88\u8d39\u8005\u2014\u2014\u63a5\u6536\u5230\u7684\u53c2\u6570\u4e3a\uff1a" + content);
        try {
            ContractPushErpBusiReqBO reqBO = (ContractPushErpBusiReqBO)((Object)JSONObject.parseObject((String)content, ContractPushErpBusiReqBO.class));
            if ("1".equals(reqBO.getIsZb())) {
                CContracRelPushCodeLogPO relPushCodeLogPO;
                Object cContracRelPushCodeLogPOS;
                if (!this.pushFlag) {
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                if (!StringUtils.isEmpty((Object)reqBO.getContractCode()) && !org.apache.commons.collections.CollectionUtils.isEmpty(cContracRelPushCodeLogPOS = this.cContracRelPushCodeLogMapper.selectListByPushContractCode(reqBO.getContractCode())) && (relPushCodeLogPO = (CContracRelPushCodeLogPO)cContracRelPushCodeLogPOS.get(0)).getRelateType() == 2) {
                    ArrayList<Long> contractIds = new ArrayList<Long>();
                    contractIds.add(relPushCodeLogPO.getRelateId());
                    reqBO.setContractIds(contractIds);
                }
                if (CollectionUtils.isEmpty(reqBO.getContractIds())) {
                    log.error("\u63a8\u9001\u53d8\u66f4\u7ed9\u62db\u6807\uff0c\u6ca1\u6709\u627e\u5230\u53d8\u66f4\uff1a" + content);
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                for (Long updateApplyId : reqBO.getContractIds()) {
                    ContractInfoChangePO contractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(updateApplyId);
                    if (ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE.equals(contractInfoChangePO.getModifyStatus())) continue;
                    ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractInfoChangePO.getContractId());
                    List<String> biddingCodes = this.contractInfoItemMapper.getBiddingCode(contractInfoChangePO.getContractId());
                    String businessCode = String.join((CharSequence)",", biddingCodes);
                    try {
                        InterFaceContractFzSyncReqBo interFaceContractFzSyncReqBo = new InterFaceContractFzSyncReqBo();
                        interFaceContractFzSyncReqBo.setCompanyId(contractInfoPO.getSupplierCode());
                        interFaceContractFzSyncReqBo.setCompanyName(contractInfoPO.getSupplierName());
                        interFaceContractFzSyncReqBo.setBusinessId("");
                        interFaceContractFzSyncReqBo.setBusinessCode(businessCode);
                        interFaceContractFzSyncReqBo.setAgreementCode(contractInfoPO.getContractCode());
                        interFaceContractFzSyncReqBo.setAgreementName(contractInfoPO.getContractName());
                        interFaceContractFzSyncReqBo.setContractId(contractInfoPO.getContractId().toString());
                        interFaceContractFzSyncReqBo.setContractType(String.valueOf(contractInfoPO.getContractType()));
                        if (1 == contractInfoChangePO.getUpdateApplyType()) {
                            interFaceContractFzSyncReqBo.setContractStatus("20");
                        } else {
                            interFaceContractFzSyncReqBo.setContractStatus("30");
                        }
                        if (contractInfoPO.getContractAmount() != null) {
                            interFaceContractFzSyncReqBo.setAmountValue(MoneyUtils.haoToYuan(contractInfoPO.getContractAmount()).toString());
                        }
                        if (contractInfoPO.getContractSignDate() != null) {
                            interFaceContractFzSyncReqBo.setCheckDate(DateUtils.dateToStr(contractInfoPO.getContractSignDate()));
                        }
                        interFaceContractFzSyncReqBo.setDeptId(contractInfoPO.getBuyerNo());
                        interFaceContractFzSyncReqBo.setDeptName(contractInfoPO.getBuyerName());
                        if (!StringUtils.isEmpty((Object)contractInfoPO.getContractDocUrl())) {
                            ArrayList<InterFaceContractFzSyncReqFileBo> fileList = new ArrayList<InterFaceContractFzSyncReqFileBo>();
                            InterFaceContractFzSyncReqFileBo interFaceContractFzSyncReqFileBo = new InterFaceContractFzSyncReqFileBo();
                            interFaceContractFzSyncReqFileBo.setFileName(contractInfoPO.getContractDocName());
                            interFaceContractFzSyncReqFileBo.setFileUrl(contractInfoPO.getContractDocUrl());
                            fileList.add(interFaceContractFzSyncReqFileBo);
                            interFaceContractFzSyncReqBo.setFileList(fileList);
                        }
                        this.interFaceContractFzSyncService.syncContractFz(interFaceContractFzSyncReqBo);
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u975e\u62db\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            ArrayList<CContractInfoPushErpPO> contractInfoPushErpPOS = new ArrayList<CContractInfoPushErpPO>();
            if (!CollectionUtils.isEmpty(reqBO.getContractIds())) {
                ArrayList<Long> contractIds = new ArrayList<Long>();
                contractIds.addAll(reqBO.getContractIds());
                for (Long dealContractId : contractIds) {
                    ArrayList<Long> dealContractIds = new ArrayList<Long>();
                    dealContractIds.add(dealContractId);
                    reqBO.setContractIds(dealContractIds);
                    ContractPushErpBusiRspBO rspBO = this.contractPushErpBusiService.dealPushErp(reqBO);
                    if (!"0000".equals(rspBO.getRespCode())) {
                        Date nowDate = new Date();
                        for (Long contractId : reqBO.getContractIds()) {
                            CContractInfoPushErpPO cContractInfoPushErpPO = new CContractInfoPushErpPO();
                            cContractInfoPushErpPO.setContractId(contractId);
                            cContractInfoPushErpPO.setId(this.uccBatchSequence.nextId());
                            cContractInfoPushErpPO.setPushInfo("\u6570\u636e\u5904\u7406\u5931\u8d25\uff1a\u51fa\u73b0\u5f02\u5e38");
                            cContractInfoPushErpPO.setPushTime(nowDate);
                            contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                        }
                        this.contractInfoMapper.updatePushErpSyncStatusByCodes(reqBO.getContractIds(), ContractConstant.PushErpStatus.FAIL_SYNC, null);
                        continue;
                    }
                    if (CollectionUtils.isEmpty(rspBO.getContractInfoPushErpPOS())) continue;
                    contractInfoPushErpPOS.addAll(rspBO.getContractInfoPushErpPOS());
                }
            }
            Map<Long, CContractInfoPushErpPO> pushErpFailIds = contractInfoPushErpPOS.stream().collect(Collectors.toMap(a -> a.getContractId(), b -> b, (a, b) -> a));
            if (!CollectionUtils.isEmpty(reqBO.getPushPlanContractIds())) {
                ContractPushPlanBusiReqBo contractPushPlanBusiReqBo = new ContractPushPlanBusiReqBo();
                contractPushPlanBusiReqBo.setContractIds(reqBO.getPushPlanContractIds());
                ContractPushPlanBusiRspBo contractPushPlanBusiRspBo = this.contractPushPlanBusiService.dealContractPushPlan(contractPushPlanBusiReqBo);
                if (!"0000".equals(contractPushPlanBusiRspBo.getRespCode())) {
                    Date nowDate = new Date();
                    for (Long contractId : reqBO.getPushPlanContractIds()) {
                        if (pushErpFailIds.containsKey(contractId)) {
                            pushErpFailIds.get(contractId).setPlanPushInfo("\u6570\u636e\u5904\u7406\u5931\u8d25\uff1a\u51fa\u73b0\u5f02\u5e38");
                            pushErpFailIds.get(contractId).setPlanPushTime(nowDate);
                            continue;
                        }
                        CContractInfoPushErpPO cContractInfoPushErpPO = new CContractInfoPushErpPO();
                        cContractInfoPushErpPO.setContractId(contractId);
                        cContractInfoPushErpPO.setId(Sequence.getInstance().nextId());
                        cContractInfoPushErpPO.setPlanPushInfo("\u6570\u636e\u5904\u7406\u5931\u8d25\uff1a\u51fa\u73b0\u5f02\u5e38");
                        cContractInfoPushErpPO.setPlanPushTime(nowDate);
                        contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                    }
                    this.contractInfoMapper.updatePushPlanSyncStatusByCodes(reqBO.getContractIds(), ContractConstant.PushErpStatus.FAIL_SYNC);
                    log.error("\u63a8\u9001erp--\u6d88\u8d39\u8005-\u5931\u8d25" + contractPushPlanBusiRspBo.getRespDesc());
                } else if (!CollectionUtils.isEmpty(contractPushPlanBusiRspBo.getContractInfoPushErpPOS())) {
                    for (CContractInfoPushErpPO contractInfoPushErpPO : contractPushPlanBusiRspBo.getContractInfoPushErpPOS()) {
                        if (pushErpFailIds.containsKey(contractInfoPushErpPO.getContractId())) {
                            pushErpFailIds.get(contractInfoPushErpPO.getContractId()).setPlanPushInfo(contractInfoPushErpPO.getPlanPushInfo());
                            pushErpFailIds.get(contractInfoPushErpPO.getContractId()).setPushPlanInParameterInfo(contractInfoPushErpPO.getPushPlanInParameterInfo());
                            pushErpFailIds.get(contractInfoPushErpPO.getContractId()).setPlanPushReturnInfo(contractInfoPushErpPO.getPlanPushReturnInfo());
                            pushErpFailIds.get(contractInfoPushErpPO.getContractId()).setPushPlanReturnInfo(contractInfoPushErpPO.getPushPlanReturnInfo());
                            pushErpFailIds.get(contractInfoPushErpPO.getContractId()).setPlanPushTime(contractInfoPushErpPO.getPlanPushTime());
                            continue;
                        }
                        CContractInfoPushErpPO cContractInfoPushErpPO = new CContractInfoPushErpPO();
                        cContractInfoPushErpPO.setContractId(contractInfoPushErpPO.getContractId());
                        cContractInfoPushErpPO.setId(Sequence.getInstance().nextId());
                        cContractInfoPushErpPO.setPlanPushInfo(contractInfoPushErpPO.getPlanPushInfo());
                        cContractInfoPushErpPO.setPushPlanInParameterInfo(contractInfoPushErpPO.getPushPlanInParameterInfo());
                        cContractInfoPushErpPO.setPlanPushReturnInfo(contractInfoPushErpPO.getPlanPushReturnInfo());
                        cContractInfoPushErpPO.setPushPlanReturnInfo(contractInfoPushErpPO.getPushPlanReturnInfo());
                        cContractInfoPushErpPO.setPlanPushTime(contractInfoPushErpPO.getPlanPushTime());
                        contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(contractInfoPushErpPOS)) {
                this.cContractInfoPushErpLogMapper.insertBatch(contractInfoPushErpPOS);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001erp-\u6d88\u8d39\u8005\u2014\u2014\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

