/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractAffirmRevocationAbilityService;
import com.tydic.contract.ability.bo.ContractAffirmRevocationAbilityReqBO;
import com.tydic.contract.ability.bo.ContractAffirmRevocationAbilityRspBO;
import com.tydic.contract.busi.ContractAffirmRevocationBusiService;
import com.tydic.contract.busi.bo.ContractFreezeStatusSyncAgrBo;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.po.CContractAgrPO;
import com.tydic.contract.po.ContractInfoChangePO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractAffirmRevocationAbilityService"})
public class ContractAffirmRevocationAbilityServiceImpl
implements ContractAffirmRevocationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractAffirmRevocationAbilityServiceImpl.class);
    @Autowired
    private ContractAffirmRevocationBusiService contractAffirmRevocationBusiService;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Resource(name="syncContractFreezeStatusProvider")
    private ProxyMessageProducer syncContractFreezeStatusProvider;
    @Autowired
    private CContractAgrMapper cContractAgrMapper;
    @Value(value="${CONTRACT_FREEZE_SYNC_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_FREEZE_SYNC_TAG}")
    private String tag;

    @PostMapping(value={"updateContractAffirmRevoca"})
    public ContractAffirmRevocationAbilityRspBO updateContractAffirmRevoca(@RequestBody ContractAffirmRevocationAbilityReqBO reqBO) {
        ContractInfoChangePO contractInfoChangePO1;
        this.verify(reqBO);
        ContractAffirmRevocationAbilityRspBO rspBO = this.contractAffirmRevocationBusiService.updateContractAffirmRevoca(reqBO);
        if (reqBO.getRecallTypeId() == 1 && (contractInfoChangePO1 = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getContractId())) != null) {
            ContractFreezeStatusSyncAgrBo contractFreezeStatusSyncAgrBo = new ContractFreezeStatusSyncAgrBo();
            try {
                CContractAgrPO cContractAgrPO = new CContractAgrPO();
                cContractAgrPO.setRelateId(contractInfoChangePO1.getContractId());
                List<CContractAgrPO> cContractAgrPOS = this.cContractAgrMapper.getList(cContractAgrPO);
                if (!CollectionUtils.isEmpty(cContractAgrPOS)) {
                    contractFreezeStatusSyncAgrBo.setContractId(contractInfoChangePO1.getContractId());
                    contractFreezeStatusSyncAgrBo.setAgrId(cContractAgrPOS.get(0).getAgreementId());
                    contractFreezeStatusSyncAgrBo.setDealType(2);
                    log.info("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\uff1a" + JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo));
                    this.syncContractFreezeStatusProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo)));
                }
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractFreezeStatusSyncAgrBo));
            }
        }
        return rspBO;
    }

    private void verify(ContractAffirmRevocationAbilityReqBO reqBO) {
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRecallTypeId() == null) {
            throw new ZTBusinessException("\u64a4\u56de\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

