/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractGlDailyRateAbilityService;
import com.tydic.contract.ability.bo.ContractGlDailyRateAbilityBO;
import com.tydic.contract.ability.bo.ContractGlDailyRateAbilityReqBO;
import com.tydic.contract.ability.bo.ContractGlDailyRateAbilityRspBO;
import com.tydic.contract.ability.bo.ContractGlDailyRateResultBO;
import com.tydic.contract.utils.DateUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractGlDailyRateAbilityService"})
public class ContractGlDailyRateAbilityServiceImpl
implements ContractGlDailyRateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractGlDailyRateAbilityServiceImpl.class);
    @Value(value="${GL_QUERY_DailyRate_URL}")
    private String GL_QUERY_DailyRate_URL;
    @Value(value="${P_GUEST_NAME:Q1VYUE9QT1JUQUw=}")
    private String P_GUEST_W;
    @Value(value="${P_GUEST_PWD:MjAyMDEyMzQ1Ng==}")
    private String P_GUEST;

    @PostMapping(value={"queryGlDailyRate"})
    public ContractGlDailyRateAbilityRspBO queryGlDailyRate(@RequestBody ContractGlDailyRateAbilityReqBO reqBO) {
        ContractGlDailyRateAbilityRspBO rspBO = new ContractGlDailyRateAbilityRspBO();
        StringBuffer content = this.doGetByHeader(reqBO, -180);
        if (StringUtils.isEmpty((Object)content) && StringUtils.isEmpty((Object)content)) {
            throw new ZTBusinessException("\u8c03\u7528ERP\u7cfb\u7edf\u63a5\u53e3\u67e5\u8be2\u6c47\u7387\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        ContractGlDailyRateResultBO contractGlDailyRateResultBO = (ContractGlDailyRateResultBO)JSON.parseObject((String)content.toString(), ContractGlDailyRateResultBO.class);
        if (Objects.isNull(contractGlDailyRateResultBO) || CollectionUtils.isEmpty((Collection)contractGlDailyRateResultBO.getDAILYRATE())) {
            content = this.doGetByHeader(reqBO, -1095);
            contractGlDailyRateResultBO = (ContractGlDailyRateResultBO)JSON.parseObject((String)content.toString(), ContractGlDailyRateResultBO.class);
        }
        if (Objects.nonNull(contractGlDailyRateResultBO) && !CollectionUtils.isEmpty((Collection)contractGlDailyRateResultBO.getDAILYRATE())) {
            List dailyRate = contractGlDailyRateResultBO.getDAILYRATE();
            ArrayList list = new ArrayList();
            int count = 0;
            if (!CollectionUtils.isEmpty((Collection)dailyRate)) {
                List sortList = dailyRate.stream().sorted(Comparator.comparing(ContractGlDailyRateAbilityBO::getConversionDate).reversed()).collect(Collectors.toList());
                int start = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
                int end = reqBO.getPageNo() * reqBO.getPageSize();
                int size = contractGlDailyRateResultBO.getDAILYRATE().size() < end ? contractGlDailyRateResultBO.getDAILYRATE().size() - start : reqBO.getPageSize();
                for (int i = 0; i < size; ++i) {
                    list.add(sortList.get(start + i));
                    ++count;
                }
            }
            rspBO.setInfo(contractGlDailyRateResultBO.getINFO());
            rspBO.setStatus(contractGlDailyRateResultBO.getSTATUS());
            rspBO.setRows(list);
            rspBO.setTotal(Integer.valueOf(count));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(contractGlDailyRateResultBO.getDAILYRATE().size()));
        } else if (Objects.nonNull(contractGlDailyRateResultBO)) {
            rspBO.setInfo(contractGlDailyRateResultBO.getINFO());
            rspBO.setStatus(contractGlDailyRateResultBO.getSTATUS());
            rspBO.setRows(null);
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
        } else {
            throw new ZTBusinessException("\u8c03\u7528ERP\u7cfb\u7edf\u63a5\u53e3\u67e5\u8be2\u6c47\u7387\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + content);
        }
        return rspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer doGetByHeader(ContractGlDailyRateAbilityReqBO reqBO, int dayCntBefore) {
        StringBuffer content = new StringBuffer();
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            String inputLine;
            URL endpoint = new URL(this.GL_QUERY_DailyRate_URL);
            connection = (HttpURLConnection)endpoint.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("P_GUEST_W", this.P_GUEST_W);
            connection.setRequestProperty("P_GUEST", this.P_GUEST);
            connection.setRequestProperty("P_FORM_CURRENCY", reqBO.getFormCurrency());
            connection.setRequestProperty("P_TO_CURRENCY", reqBO.getToCurrency());
            connection.setRequestProperty("P_DATE_F", StringUtils.isEmpty((Object)reqBO.getDateT()) ? DateUtils.dateToStrAsFormat(DateUtils.dateBefore(new Date(), dayCntBefore), "yyyy-MM-dd HH:mm:ss") : reqBO.getDateT());
            connection.setRequestProperty("P_DATE_T", StringUtils.isEmpty((Object)reqBO.getDateF()) ? DateUtils.dateToStrAsFormat(new Date(), "yyyy-MM-dd HH:mm:ss") : reqBO.getDateF());
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return content;
    }
}

