/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractItemWaitOrderQueryAbilityService;
import com.tydic.contract.ability.bo.ContractItemWaitOrderQueryAbilityBO;
import com.tydic.contract.ability.bo.ContractItemWaitOrderQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemWaitOrderQueryAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractPreBuyMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.ContractItemWaitOrderQueryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.api.UmcEntityOrgSubQryAbilityService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubQryAbilityBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemWaitOrderQueryAbilityService"})
public class ContractItemWaitOrderQueryAbilityServiceImpl
implements ContractItemWaitOrderQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemWaitOrderQueryAbilityServiceImpl.class);
    @Autowired
    private CContractPreBuyMapper cContractPreBuyMapper;
    @Value(value="${DEVELOP_COMPANY_DEPARTMENT}")
    private String developCompanyDepartment;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private UmcEntityOrgSubQryAbilityService umcEntityOrgSubQryAbilityService;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"queryWaitOrder"})
    public ContractItemWaitOrderQueryAbilityRspBO queryWaitOrder(@RequestBody ContractItemWaitOrderQueryAbilityReqBO reqBO) {
        ContractItemWaitOrderQueryAbilityRspBO rspBO = new ContractItemWaitOrderQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isEmpty((Object)reqBO.getOccupation())) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u7528\u6237\u7684occupation\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOrgId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ContractItemWaitOrderQueryPO contractItemWaitOrderQueryPO = new ContractItemWaitOrderQueryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)contractItemWaitOrderQueryPO);
        contractItemWaitOrderQueryPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (!StringUtils.isEmpty((Object)this.developCompanyDepartment)) {
            if (this.developCompanyDepartment.contains(",")) {
                String[] split;
                for (String string : split = this.developCompanyDepartment.split(",")) {
                    try {
                        orgIdList.add(Long.valueOf(string));
                    }
                    catch (Exception e2) {
                        log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + string);
                    }
                }
            } else {
                try {
                    orgIdList.add(Long.valueOf(this.developCompanyDepartment));
                }
                catch (Exception e3) {
                    log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + this.developCompanyDepartment);
                }
            }
        }
        if (orgIdList.contains(reqBO.getOrgId())) {
            contractItemWaitOrderQueryPO.setPurchaseContractTypes(Arrays.asList(5));
            contractItemWaitOrderQueryPO.setBusinessTypes(Arrays.asList(7, 8));
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                contractItemWaitOrderQueryPO.setContractCreateUserId(reqBO.getUserId());
                contractItemWaitOrderQueryPO.setCreateUserId(reqBO.getUserId());
            }
        } else {
            ArrayList<Integer> contractTypes = new ArrayList<Integer>();
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                contractItemWaitOrderQueryPO.setContractType(ContractConstant.ContractType.SALE_CONTRACT);
                contractItemWaitOrderQueryPO.setAwardEmployeeNumber(reqBO.getOccupation());
                contractItemWaitOrderQueryPO.setCreateUserId(reqBO.getUserId());
                DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
                dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
                if (!"0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode())) throw new ZTBusinessException(dycUmcQueryBuyerPermissionRspBo.getRespDesc());
                if (!CollectionUtils.isEmpty((Collection)dycUmcQueryBuyerPermissionRspBo.getRows())) {
                    List<String> buyerNos = dycUmcQueryBuyerPermissionRspBo.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrgCode())).map(e -> e.getOrgCode()).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(buyerNos)) {
                        contractItemWaitOrderQueryPO.setBuyerNos(buyerNos);
                    }
                    log.info("\u4e70\u53d7\u4eba" + buyerNos);
                }
            } else {
                contractTypes.add(ContractConstant.ContractType.SALE_CONTRACT);
            }
            contractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
            contractItemWaitOrderQueryPO.setSearchDate(new Date());
            contractItemWaitOrderQueryPO.setUnitContractPricingType(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
            contractItemWaitOrderQueryPO.setUnitContractPricingConsType(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
            contractItemWaitOrderQueryPO.setContractTypes(contractTypes);
            contractItemWaitOrderQueryPO.setIsDevelopCompanyDepartment(1);
        }
        if (reqBO.getTabId() != null) {
            ArrayList<Integer> tabIdContractTypes;
            if (reqBO.getTabId() == 1) {
                tabIdContractTypes = new ArrayList<Integer>();
                tabIdContractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
                tabIdContractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
                contractItemWaitOrderQueryPO.setPurchaseContractTypes(Arrays.asList(5, 15));
                contractItemWaitOrderQueryPO.setBusinessTypes(Arrays.asList(7, 8));
                contractItemWaitOrderQueryPO.setTabIdContractTypes(tabIdContractTypes);
            }
            if (reqBO.getTabId() == 2) {
                tabIdContractTypes = new ArrayList();
                tabIdContractTypes.add(ContractConstant.ContractType.SALE_CONTRACT);
                tabIdContractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
                contractItemWaitOrderQueryPO.setPurchaseContractTypes(Arrays.asList(6, 16));
                contractItemWaitOrderQueryPO.setBusinessTypes(Arrays.asList(7, 8));
                contractItemWaitOrderQueryPO.setTabIdContractTypes(tabIdContractTypes);
            }
        }
        contractItemWaitOrderQueryPO.setVendorStatus(1);
        contractItemWaitOrderQueryPO.setSearchDate(new Date());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.cContractPreBuyMapper.selectByInfo(contractItemWaitOrderQueryPO));
        List result = page.getResult();
        ArrayList<ContractItemWaitOrderQueryAbilityBO> rows = new ArrayList<ContractItemWaitOrderQueryAbilityBO>();
        HashSet<String> codeSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (ContractItemWaitOrderQueryPO po : result) {
                ContractItemWaitOrderQueryAbilityBO row = (ContractItemWaitOrderQueryAbilityBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)po), ContractItemWaitOrderQueryAbilityBO.class);
                if (po.getAmountLimit() != null) {
                    row.setAmountLimit(MoneyUtils.haoToYuan(po.getAmountLimit()));
                }
                if (po.getOrderAmount() != null) {
                    row.setOrderAmount(MoneyUtils.haoToYuan(po.getOrderAmount()));
                }
                if (!StringUtils.isEmpty((Object)po.getBusinessType()) && (ContractConstant.ContractType.SPOT_CONTRACT.equals(po.getContractType()) && po.getBusinessType().equals(ContractConstant.BusinessType.SELF_PURCHASE) || ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(po.getContractType()) && po.getBusinessType().equals(ContractConstant.BusinessType.SELF_PURCHASE)) && (StringUtils.isEmpty((Object)po.getBuyerNo()) || StringUtils.isEmpty((Object)po.getBuyerName()))) {
                    row.setBuyerId(po.getContractBuyerId());
                    row.setBuyerNo(po.getContractBuyerNo());
                    row.setBuyerName(po.getContractBuyerName());
                }
                if (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(po.getContractType())) {
                    row.setBuyerId(po.getContractBuyerId());
                    row.setBuyerNo(po.getContractBuyerNo());
                    row.setBuyerName(po.getContractBuyerName());
                }
                if (po.getOrderDeliveryDate() != null) {
                    row.setOrderDeliveryDate(po.getOrderDeliveryDate().stripTrailingZeros().toPlainString());
                }
                if (!StringUtils.isEmpty((Object)po.getErpOrgCode())) {
                    codeSet.add(po.getErpOrgCode());
                }
                rows.add(row);
            }
        }
        if (!CollectionUtils.isEmpty(rows)) {
            void var9_20;
            if (CollectionUtils.isEmpty(codeSet)) {
                HashMap hashMap = new HashMap();
            } else {
                UmcEntityOrgSubQryAbilityRspBO umcEntityOrgSubQryAbilityRspBO = null;
                try {
                    UmcEntityOrgSubQryAbilityReqBO umcEntityOrgSubQryAbilityReqBO = new UmcEntityOrgSubQryAbilityReqBO();
                    umcEntityOrgSubQryAbilityReqBO.setSubOrgIdList(new ArrayList(codeSet));
                    umcEntityOrgSubQryAbilityRspBO = this.umcEntityOrgSubQryAbilityService.qryOrgCode(umcEntityOrgSubQryAbilityReqBO);
                }
                catch (Exception e4) {
                    log.error("\u8c03\u7528\u4f1a\u5458\u670d\u52a1\u67e5\u8be2\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u5f02\u5e38\uff1a" + e4);
                }
                if (Objects.nonNull(umcEntityOrgSubQryAbilityRspBO) && !CollectionUtils.isEmpty((Collection)umcEntityOrgSubQryAbilityRspBO.getSubQryAbilityBOS())) {
                    Map map = umcEntityOrgSubQryAbilityRspBO.getSubQryAbilityBOS().stream().collect(Collectors.toMap(UmcEntityOrgSubQryAbilityBO::getOrganizationId, Function.identity(), (k1, k2) -> k1));
                } else {
                    HashMap hashMap = new HashMap();
                }
            }
            rows.forEach(arg_0 -> ContractItemWaitOrderQueryAbilityServiceImpl.lambda$queryWaitOrder$850((Map)var9_20, arg_0));
        }
        if (!CollectionUtils.isEmpty(rows)) {
            this.setIsPushWms(rows);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        return rspBO;
    }

    private void setIsPushWms(List<ContractItemWaitOrderQueryAbilityBO> rows) {
        List<Long> contractIds = rows.stream().filter(e -> e.getContractId() != null && ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType())).map(ContractItemWaitOrderQueryAbilityBO::getContractId).collect(Collectors.toList());
        Map<Object, Object> contractIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(contractIds)) {
            CContractInfoExtPO searchPO = new CContractInfoExtPO();
            searchPO.setRelateIds(contractIds);
            List<CContractInfoExtPO> list = this.cContractInfoExtMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty(list)) {
                contractIdMap = list.stream().collect(Collectors.groupingBy(CContractInfoExtPO::getRelateId));
            }
        }
        for (ContractItemWaitOrderQueryAbilityBO row : rows) {
            if (!contractIdMap.containsKey(row.getContractId())) continue;
            row.setIsPushWms(((CContractInfoExtPO)((List)contractIdMap.get(row.getContractId())).get(0)).getIsPushWms());
        }
    }

    private static /* synthetic */ void lambda$queryWaitOrder$850(Map map, ContractItemWaitOrderQueryAbilityBO e) {
        if (e.getMaterialCategory() != null) {
            e.setMaterialCategoryStr(ContractTransFieldUtil.transMaterialCategory2(e.getMaterialCategory()));
        }
        if (e.getAmount() == null) {
            e.setAmount(BigDecimal.ZERO);
        }
        if (e.getOrderNum() == null) {
            e.setOrderNum(BigDecimal.ZERO);
        }
        if (!StringUtils.isEmpty((Object)e.getErpOrgCode()) && org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)e.getErpOrgCode()) && !CollectionUtils.isEmpty((Map)map) && Objects.nonNull(map.get(Long.valueOf(e.getErpOrgCode())))) {
            e.setOrganizationCode(((UmcEntityOrgSubQryAbilityBO)map.get(Long.valueOf(e.getErpOrgCode()))).getOrganizationCode());
        }
        e.setCanSaleNum(e.getAmount().subtract(e.getOrderNum()));
        if (!StringUtils.isEmpty((Object)e.getErpOrgCode())) {
            e.setDecCompanyCode(e.getErpOrgCode());
        }
    }
}

