/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryIsPushWmsAbilityService;
import com.tydic.contract.ability.bo.ContractQryIsPushWmsAbilityBO;
import com.tydic.contract.ability.bo.ContractQryIsPushWmsAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryIsPushWmsAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractQryIsPushWmsAbilityService"})
public class ContractQryIsPushWmsAbilityServiceImpl
implements ContractQryIsPushWmsAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEnterpriseQryListAbilityService umcEnterpriseQryListAbilityService;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;

    @PostMapping(value={"qryIsPushWms"})
    public ContractQryIsPushWmsAbilityRspBO qryIsPushWms(@RequestBody ContractQryIsPushWmsAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractIdList())) {
            throw new ZTBusinessException("\u5408\u540cids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractQryIsPushWmsAbilityRspBO rspBO = new ContractQryIsPushWmsAbilityRspBO();
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBO.getContractIdList());
        if (CollectionUtils.isEmpty(contractInfoPOS)) {
            HashMap<Long, Integer> contractMap = new HashMap<Long, Integer>();
            ArrayList<ContractQryIsPushWmsAbilityBO> rows = new ArrayList<ContractQryIsPushWmsAbilityBO>();
            for (Long contractId : reqBO.getContractIdList()) {
                ContractQryIsPushWmsAbilityBO row = new ContractQryIsPushWmsAbilityBO();
                Integer isPushWms = ContractConstant.ContractPushWmsStatus.NO;
                row.setContractId(contractId);
                row.setIsPushWms(isPushWms);
                rows.add(row);
                contractMap.put(contractId, isPushWms);
            }
            rspBO.setRows(rows);
            rspBO.setContractMap(contractMap);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Set buyerSet = contractInfoPOS.stream().filter(e -> ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType()) && !StringUtils.isEmpty((Object)e.getBuyerNo())).map(ContractInfoPO::getBuyerNo).collect(Collectors.toSet());
        List<Long> contractIds = contractInfoPOS.stream().filter(e -> ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType())).map(ContractInfoPO::getContractId).collect(Collectors.toList());
        HashMap<Long, Integer> contractExtMap = new HashMap<Long, Integer>();
        Map<Object, Object> orgCodeMap = new HashMap();
        if (!CollectionUtils.isEmpty(contractIds)) {
            CContractInfoExtPO searchPO = new CContractInfoExtPO();
            searchPO.setRelateIds(contractIds);
            List<CContractInfoExtPO> list = this.cContractInfoExtMapper.getList(searchPO);
            Boolean isQryBuyer = false;
            if (!CollectionUtils.isEmpty(list)) {
                for (CContractInfoExtPO infoExtPO : list) {
                    if (infoExtPO.getIsPushWms() == null) {
                        infoExtPO.setIsPushWms(ContractConstant.ContractPushWmsStatus.NO);
                    }
                    if (ContractConstant.ContractPushWmsStatus.YES.equals(infoExtPO.getIsPushWms())) {
                        isQryBuyer = true;
                    }
                    contractExtMap.put(infoExtPO.getRelateId(), infoExtPO.getIsPushWms());
                }
            }
            if (isQryBuyer.booleanValue() && !CollectionUtils.isEmpty(buyerSet)) {
                UmcEnterpriseQryListAbilityReqBO abilityReqBO = new UmcEnterpriseQryListAbilityReqBO();
                abilityReqBO.setOrgCodeWebList(new ArrayList(buyerSet));
                UmcEnterpriseQryListAbilityRspBO abilityRspBO = this.umcEnterpriseQryListAbilityService.qryList(abilityReqBO);
                if ("0000".equals(abilityRspBO.getRespCode())) {
                    List orgDetailBOS = abilityRspBO.getRows();
                    if (!CollectionUtils.isEmpty((Collection)orgDetailBOS)) {
                        orgCodeMap = orgDetailBOS.stream().filter(e -> e.getIsPushWms() != null).collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgCode, UmcEnterpriseOrgDetailBO::getIsPushWms));
                    }
                } else {
                    throw new ZTBusinessException("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5931\u8d25" + abilityRspBO.getRespDesc());
                }
            }
        }
        HashMap<Long, Integer> contractMap = new HashMap<Long, Integer>();
        ArrayList<ContractQryIsPushWmsAbilityBO> rows = new ArrayList<ContractQryIsPushWmsAbilityBO>();
        for (ContractInfoPO contractInfoPO : contractInfoPOS) {
            ContractQryIsPushWmsAbilityBO row = new ContractQryIsPushWmsAbilityBO();
            Integer isPushWms = ContractConstant.ContractPushWmsStatus.NO;
            if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()) && contractExtMap.containsKey(contractInfoPO.getContractId()) && ContractConstant.ContractPushWmsStatus.YES.equals(contractExtMap.get(contractInfoPO.getContractId())) && orgCodeMap.containsKey(contractInfoPO.getBuyerNo()) && ContractConstant.ContractPushWmsStatus.YES.equals(orgCodeMap.get(contractInfoPO.getBuyerNo()))) {
                isPushWms = ContractConstant.ContractPushWmsStatus.YES;
            }
            row.setContractId(contractInfoPO.getContractId());
            row.setIsPushWms(isPushWms);
            rows.add(row);
            contractMap.put(contractInfoPO.getContractId(), isPushWms);
        }
        rspBO.setRows(rows);
        rspBO.setContractMap(contractMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

