/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryProcurementPlanAgreementItemListAbilityService;
import com.tydic.contract.ability.bo.ContractPlanMatchingAgreementItemBO;
import com.tydic.contract.ability.bo.ContractQryProcurementPlanAgreementItemListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryProcurementPlanAgreementItemListAbilityRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractItemCanBuyListQryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractQryProcurementPlanAgreementItemListAbilityService"})
public class ContractQryProcurementPlanAgreementItemListAbilityServiceImpl
implements ContractQryProcurementPlanAgreementItemListAbilityService {
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;

    @PostMapping(value={"qryProcurementPlanAgreementItemList"})
    public ContractQryProcurementPlanAgreementItemListAbilityRspBO qryProcurementPlanAgreementItemList(@RequestBody ContractQryProcurementPlanAgreementItemListAbilityReqBO reqBO) {
        ContractQryProcurementPlanAgreementItemListAbilityRspBO rspBO = new ContractQryProcurementPlanAgreementItemListAbilityRspBO();
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractItemCanBuyListQryPO qryPO = new ContractItemCanBuyListQryPO();
        qryPO.setContractId(reqBO.getContractId());
        qryPO.setItemIds(reqBO.getItemIds());
        qryPO.setMaterialCode(reqBO.getMaterialCode());
        qryPO.setMaterialDesc(reqBO.getMaterialDesc());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.qryProcurementPlanAgreementItemList(qryPO));
        List result = page.getResult();
        ArrayList<ContractPlanMatchingAgreementItemBO> itemBOS = new ArrayList<ContractPlanMatchingAgreementItemBO>();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (ContractInfoItemPO infoItemPO : result) {
                ContractPlanMatchingAgreementItemBO bo = (ContractPlanMatchingAgreementItemBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)infoItemPO), ContractPlanMatchingAgreementItemBO.class);
                if (infoItemPO.getAmountLimit() != null) {
                    bo.setAmountLimit(MoneyUtils.haoToYuan(infoItemPO.getAmountLimit()));
                }
                if (infoItemPO.getOrderAmount() != null) {
                    bo.setOrderAmount(MoneyUtils.haoToYuan(infoItemPO.getOrderAmount()));
                }
                if (infoItemPO.getOrderAmount() != null) {
                    bo.setOrderAmount(MoneyUtils.haoToYuan(infoItemPO.getOrderAmount()));
                }
                if (infoItemPO.getOrderDeliveryDate() != null) {
                    bo.setOrderDeliveryDateStr(String.valueOf(infoItemPO.getOrderDeliveryDate().intValue()));
                }
                itemBOS.add(bo);
            }
        }
        for (ContractPlanMatchingAgreementItemBO itemBO : itemBOS) {
            if (itemBO.getContractStatus() != null) {
                itemBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(itemBO.getContractStatus()));
            }
            if (itemBO.getFactoryPrice() != null) {
                itemBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(itemBO.getFactoryPrice()));
            }
            if (itemBO.getPriceCategories() != null) {
                itemBO.setPriceCategoriesStr(ContractTransFieldUtil.transPriceCategories(itemBO.getPriceCategories()));
            }
            if (itemBO.getAmount() == null) {
                itemBO.setAmount(BigDecimal.ZERO);
            }
            if (itemBO.getOrderNum() == null) {
                itemBO.setOrderNum(BigDecimal.ZERO);
            }
            if (itemBO.getMaterialCategory() == null) continue;
            itemBO.setMaterialCategoryStr(ContractTransFieldUtil.transMaterialCategory2(itemBO.getMaterialCategory()));
        }
        rspBO.setRows(itemBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }
}

