/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractDownloadSignDocumentAbilityService;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.ability.bo.ContractAddContractQtyAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractDownloadSignDocumentAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDownloadSignDocumentAbilityRspBO;
import com.tydic.contract.atom.ContractPurchaseSyncSaleContractAtomiService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.InterFaceContractFzSyncService;
import com.tydic.contract.atom.InterFaceContractGetEnvelopesDetailAtomService;
import com.tydic.contract.atom.InterFaceContractSignAccessTokenCreateAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.EnvelopeContentAtomBO;
import com.tydic.contract.atom.bo.EnvelopeParticipantAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractFzSyncReqBo;
import com.tydic.contract.atom.bo.InterFaceContractFzSyncReqFileBo;
import com.tydic.contract.atom.bo.InterFaceContractGetEnvelopesDetailAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetEnvelopesDetailAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractSignAccessTokenCreateAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractSignAccessTokenCreateAtomRspBO;
import com.tydic.contract.busi.ContractPushMdmBusiService;
import com.tydic.contract.busi.ContractSignPushLegalBusiService;
import com.tydic.contract.busi.bo.ContractFreezeStatusSyncAgrBo;
import com.tydic.contract.busi.bo.ContractPurchaseSyncSaleContractBusiReqBO;
import com.tydic.contract.busi.bo.ContractPurchaseSyncSaleContractBusiRspBO;
import com.tydic.contract.busi.bo.ContractPushErpBusiReqBO;
import com.tydic.contract.busi.bo.ContractSignPushLegalBusiReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.CContractSignFileMapper;
import com.tydic.contract.dao.CContractSignOperLogMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOperateNodeRecordMapper;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.CContractAgrPO;
import com.tydic.contract.po.CContractSignFilePO;
import com.tydic.contract.po.CContractSignOperLogPO;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.contract.po.UocSchemeTempPO;
import com.tydic.contract.utils.ContractIsJy;
import com.tydic.contract.utils.DateUtils;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.UocExtensionOfflineContractSyncAbilityService;
import com.tydic.uoc.common.ability.bo.UocAttachmentBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractPayBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractSyncReqBo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ContractSyncSignatureThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ContractSyncSignatureThread.class);
    private InterFaceContractGetEnvelopesDetailAtomService interFaceContractGetEnvelopesDetailAtomService;
    private ContractInfoMapper contractInfoMapper;
    private ContractAccessoryMapper contractAccessoryMapper;
    private Long envelopeId;
    private Long contractId;
    private ProxyMessageProducer syncContractFreezeStatusProvider;
    private CContractAgrMapper cContractAgrMapper;
    private String topic;
    private String tag;
    @Value(value="${UOCCREATE_SCHEME_SYNC_TOPIC:UOCCREATE_SCHEME_SYNC_TOPIC}")
    private String uocCreateSchemeTempTopic;
    @Value(value="${UOCCREATE_SCHEME_SYNC_TAG:UOCCREATE_SCHEME_SYNC_TAG}")
    private String uocCreateSchemeTempTag;
    private Integer contractStatus;
    private Integer signatureSort;
    private InterFaceContractSignAccessTokenCreateAtomService interFaceContractSignAccessTokenCreateAtomService;
    private ContractDownloadSignDocumentAbilityService contractDownloadSignDocumentAbilityService;
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    private ContractOperateNodeRecordMapper contractOperateNodeRecordMapper;
    @Autowired
    private InterFaceContractFzSyncService interFaceContractFzSyncService;
    @Autowired
    private ContractPushMdmBusiService contractPushMdmBusiService;
    private String clientId;
    private String secret;
    private CContractSignOperLogMapper contractSignOperLogMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    private String buyerNo;
    private String buyerName;
    private Long supplierId;
    private String supplierName;
    private Integer contractType;
    private Integer pushErpFlag;
    private ProxyMessageProducer mqContractPushErpProvider;
    private String contractPushErpTopic;
    private String contractPushErpTag;
    private Integer validaType;
    private Integer validaNum;
    private String multiDealerName;
    private String multiDealerCode;
    private ContractPurchaseSyncSaleContractAtomiService contractPurchaseSyncSaleContractAtomiService;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    private String planDiversionSyncTopic;
    private String planDiversionSyncTag;
    private ContractSignPushLegalBusiService contractSignPushLegalBusiService;
    private ContractPushLogMapper contractPushLogMapper;
    private String signatureEffectPushlegal;
    private CContractSignFileMapper cContractSignFileMapper;
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    private UocExtensionOfflineContractSyncAbilityService uocExtensionOfflineContractSyncAbilityService;
    private ProxyMessageProducer planAddContractQtyMsgProvider;
    private String planAddContractQtyTopic;
    private String planAddContractQtyTag;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        InterFaceContractGetEnvelopesDetailAtomReqBO atomReqBO = new InterFaceContractGetEnvelopesDetailAtomReqBO();
        atomReqBO.setEnvelopeId(this.envelopeId);
        ArrayList<Long> pushErpContractIds = new ArrayList<Long>();
        ArrayList<Long> pushPlanContractIds = new ArrayList<Long>();
        ArrayList<Long> pushLegalContractIds = new ArrayList<Long>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String accessToken = this.getAccessToken(this.clientId, this.secret);
            atomReqBO.setAccessToken(accessToken);
            InterFaceContractGetEnvelopesDetailAtomRspBO atomRspBO = this.interFaceContractGetEnvelopesDetailAtomService.getEnvelopesDetail(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) throw new ZTBusinessException(atomRspBO.getRespDesc());
            if (atomRspBO.getEnvelopeBasicInfo() == null) {
                throw new ZTBusinessException("\u4fe1\u5c01\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (ContractConstant.ContractSignatureEnvelopeStatus.SIGNED_SUCCESS.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                Long saleContractId;
                ContractInfoPO saleInfoPO;
                List<CRelBuySaleContractPO> relBuySaleContractPOS;
                ContractInfoPO contractInfoPO1 = new ContractInfoPO();
                CContractSignFilePO qryPo = new CContractSignFilePO();
                qryPo.setEnvelopeId(this.envelopeId);
                List<CContractSignFilePO> signFilePOList = this.cContractSignFileMapper.queryAllByCondition(qryPo);
                if (!CollectionUtils.isEmpty(signFilePOList)) {
                    this.replaceFile(this.envelopeId, accessToken, atomRspBO.getEnvelopeContents(), signFilePOList);
                } else {
                    String fileUrl = null;
                    ContractDownloadSignDocumentAbilityReqBO signDocumentAbilityReqBO = new ContractDownloadSignDocumentAbilityReqBO();
                    signDocumentAbilityReqBO.setEnvelopeId(this.envelopeId);
                    signDocumentAbilityReqBO.setAccessToken(accessToken);
                    ContractDownloadSignDocumentAbilityRspBO contractDownloadSignDocumentAbilityRspBO = this.contractDownloadSignDocumentAbilityService.downloadSignDocument(signDocumentAbilityReqBO);
                    if (!"0000".equals(contractDownloadSignDocumentAbilityRspBO.getRespCode())) {
                        throw new ZTBusinessException(contractDownloadSignDocumentAbilityRspBO.getRespDesc());
                    }
                    fileUrl = contractDownloadSignDocumentAbilityRspBO.getFileUrl();
                    contractInfoPO1.setContractDocUrl(fileUrl);
                }
                contractInfoPO1.setContractId(this.contractId);
                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                contractInfoPO1.setIsProcess(2);
                ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(this.contractId);
                if (contractInfoPO != null && !StringUtils.isEmpty((Object)contractInfoPO.getIsJy())) {
                    contractInfoPO1.setIsJy(contractInfoPO.getIsJy());
                }
                List<ContractInfoChangePO> contractInfoChangePOS = this.contractInfoChangeMapper.selectByContractId(this.contractId);
                Date date = new Date();
                if (!CollectionUtils.isEmpty(contractInfoChangePOS) && contractInfoPO.getEffectiveDate() != null) {
                    contractInfoPO1.setEffectiveDate(contractInfoPO.getEffectiveDate());
                    contractInfoPO1.setContractEffectiveDate(contractInfoPO.getEffectiveDate());
                } else {
                    contractInfoPO1.setEffectiveDate(date);
                    contractInfoPO1.setContractEffectiveDate(date);
                }
                contractInfoPO1.setContractSignDate(date);
                if (this.validaType != null && this.validaNum != null) {
                    Calendar c = Calendar.getInstance();
                    if (!CollectionUtils.isEmpty(contractInfoChangePOS)) {
                        c.setTime(contractInfoPO.getContractEffectiveDate() != null ? contractInfoPO.getContractEffectiveDate() : date);
                    } else {
                        c.setTime(date);
                    }
                    if (ContractConstant.TermOfValidityType.MONTHS.equals(this.validaType)) {
                        c.add(2, this.validaNum);
                    } else if (ContractConstant.TermOfValidityType.YEARS.equals(this.validaType)) {
                        c.add(1, this.validaNum);
                    } else if (ContractConstant.TermOfValidityType.DAY.equals(this.validaType)) {
                        c.add(5, this.validaNum);
                    }
                    contractInfoPO1.setContractValidTime(c.getTime());
                    contractInfoPO1.setExpiredCheckFlag(0);
                    contractInfoPO1.setContractEndDate(c.getTime());
                }
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(this.contractType) && ContractIsJy.isJy(contractInfoPO1.getIsJy()).booleanValue()) {
                    contractInfoPO1.setPushErpStatus(ContractConstant.PushErpStatus.IN_SYNC);
                    pushErpContractIds.add(this.contractId);
                    contractInfoPO1.setPushPlanStatus(ContractConstant.PushErpStatus.IN_SYNC);
                    pushPlanContractIds.add(this.contractId);
                }
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(this.contractType) && ContractIsJy.isJy(contractInfoPO1.getIsJy()).booleanValue() && this.pushErpFlag != null && this.pushErpFlag == 1) {
                    contractInfoPO1.setPushPlanStatus(ContractConstant.PushErpStatus.IN_SYNC);
                    pushPlanContractIds.add(this.contractId);
                }
                if (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(this.contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(this.contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(this.contractType)) {
                    pushLegalContractIds.add(this.contractId);
                }
                if (ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(this.contractType) || ContractConstant.ContractType.ORDER_CONTRACT.equals(this.contractType)) {
                    contractInfoPO1.setPurchaseContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                }
                this.platformContractPushErpPlan(contractInfoPO, contractInfoPO1, pushPlanContractIds);
                contractInfoPO1.setUpdateTime(new Date());
                int updateResult = this.contractInfoMapper.updateContract(contractInfoPO1);
                if (updateResult != 1) {
                    throw new ZTBusinessException("\u4fee\u6539\u5408\u540c\u6570\u636e\u5931\u8d25");
                }
                ArrayList<String> nodes = new ArrayList<String>();
                nodes.add("FIRST_PARTY_SIGN");
                nodes.add("SECOND_PARTY_SIGN");
                nodes.add("THIRD_PARTY_SIGN");
                this.contractOperateNodeRecordMapper.deleteByContractIdAndNodes(this.contractId, nodes);
                ArrayList<Integer> types = new ArrayList<Integer>();
                types.add(ContractConstant.SignOperLogType.SIGN_INIT);
                this.contractSignOperLogMapper.deleteByNotInTypes(types, this.envelopeId);
                List<EnvelopeParticipantAtomBO> envelopeParticipants = atomRspBO.getEnvelopeParticipants();
                List<EnvelopeParticipantAtomBO> partSignInfoS = envelopeParticipants.stream().filter(e -> e.getRoleType() != null && e.getRoleType().equals(1)).collect(Collectors.toList());
                this.recordSignSucceeNode(partSignInfoS);
                this.recordSignSucceeLog(sdf, contractInfoPO1, partSignInfoS);
                ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
                contractRecordContractNodeOperLogAtomReqBO.setContractId(this.contractId);
                contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CONTRACT_EFFECT");
                contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u5408\u540c\u751f\u6548");
                contractRecordContractNodeOperLogAtomReqBO.setOperUserId(1L);
                contractRecordContractNodeOperLogAtomReqBO.setOperUserName("admin");
                this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
                CompletableFuture.runAsync(() -> this.contractPushMdmBusiService.pushData(contractInfoPO1.getContractId()));
                ContractInfoItemPO qryItemPO = new ContractInfoItemPO();
                qryItemPO.setContractId(this.contractId);
                List<UocSchemeTempPO> pushOrderSchemeList = this.contractInfoItemMapper.getContractScheme(qryItemPO);
                if (!CollectionUtils.isEmpty(pushOrderSchemeList)) {
                    JSONObject object = new JSONObject();
                    object.put("tempList", pushOrderSchemeList);
                    this.syncContractFreezeStatusProvider.send(new ProxyMessage(this.uocCreateSchemeTempTopic, this.uocCreateSchemeTempTag, JSON.toJSONString((Object)object)));
                }
                ContractFreezeStatusSyncAgrBo contractFreezeStatusSyncAgrBo = new ContractFreezeStatusSyncAgrBo();
                try {
                    CContractAgrPO cContractAgrPO = new CContractAgrPO();
                    cContractAgrPO.setRelateId(this.contractId);
                    List<CContractAgrPO> cContractAgrPOS = this.cContractAgrMapper.getList(cContractAgrPO);
                    if (!CollectionUtils.isEmpty(cContractAgrPOS)) {
                        contractFreezeStatusSyncAgrBo.setContractId(this.contractId);
                        contractFreezeStatusSyncAgrBo.setAgrId(cContractAgrPOS.get(0).getAgreementId());
                        contractFreezeStatusSyncAgrBo.setDealType(1);
                        System.out.println("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\uff1a" + JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo));
                        this.syncContractFreezeStatusProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo)));
                    }
                }
                catch (Exception e2) {
                    System.out.println("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\u5f02\u5e38\uff1a" + e2.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractFreezeStatusSyncAgrBo));
                }
                List<ContractInfoItemPO> itemPOS = this.contractInfoItemMapper.selectAmountByContractId(this.contractId);
                if (!CollectionUtils.isEmpty(itemPOS)) {
                    ContractAddContractQtyAbilityReqBO addContractQtyAbilityReqBO = new ContractAddContractQtyAbilityReqBO();
                    addContractQtyAbilityReqBO.setContractId(this.contractId);
                    Map<Long, BigDecimal> planIdMap = itemPOS.stream().collect(Collectors.toMap(a -> Long.valueOf(a.getPlanItemId()), ContractInfoItemPO::getAmount));
                    addContractQtyAbilityReqBO.setPlanIdMap(planIdMap);
                    log.info("\u53d1\u9001\u540c\u6b65\u8ba1\u5212\u5408\u540c\u91cf\u6d88\u606f\uff1a" + JSON.toJSONString((Object)addContractQtyAbilityReqBO));
                    this.planAddContractQtyMsgProvider.send(new ProxyMessage(this.planAddContractQtyTopic, this.planAddContractQtyTag, JSON.toJSONString((Object)addContractQtyAbilityReqBO)));
                }
                if (contractInfoPO != null && this.contractId != null) {
                    List<String> biddingCodes = this.contractInfoItemMapper.getBiddingCode(this.contractId);
                    String businessCode = String.join((CharSequence)",", biddingCodes);
                    try {
                        InterFaceContractFzSyncReqBo interFaceContractFzSyncReqBo = new InterFaceContractFzSyncReqBo();
                        interFaceContractFzSyncReqBo.setCompanyId(contractInfoPO.getSupplierCode());
                        interFaceContractFzSyncReqBo.setCompanyName(contractInfoPO.getSupplierName());
                        interFaceContractFzSyncReqBo.setBusinessId("");
                        interFaceContractFzSyncReqBo.setBusinessCode(businessCode);
                        interFaceContractFzSyncReqBo.setAgreementCode(contractInfoPO.getContractCode());
                        interFaceContractFzSyncReqBo.setAgreementName(contractInfoPO.getContractName());
                        interFaceContractFzSyncReqBo.setContractId(contractInfoPO.getContractId().toString());
                        interFaceContractFzSyncReqBo.setContractType(String.valueOf(contractInfoPO.getContractType()));
                        if (contractInfoPO.getContractAmount() != null) {
                            interFaceContractFzSyncReqBo.setAmountValue(MoneyUtils.haoToYuan(contractInfoPO.getContractAmount()).toString());
                        }
                        if (contractInfoPO.getContractSignDate() != null) {
                            interFaceContractFzSyncReqBo.setCheckDate(DateUtils.dateToStr(contractInfoPO.getContractSignDate()));
                        }
                        interFaceContractFzSyncReqBo.setDeptId(contractInfoPO.getBuyerNo());
                        interFaceContractFzSyncReqBo.setDeptName(contractInfoPO.getBuyerName());
                        if (!StringUtils.isEmpty((Object)contractInfoPO.getContractDocUrl())) {
                            ArrayList<InterFaceContractFzSyncReqFileBo> fileList = new ArrayList<InterFaceContractFzSyncReqFileBo>();
                            InterFaceContractFzSyncReqFileBo interFaceContractFzSyncReqFileBo = new InterFaceContractFzSyncReqFileBo();
                            interFaceContractFzSyncReqFileBo.setFileName(contractInfoPO.getContractDocName());
                            interFaceContractFzSyncReqFileBo.setFileUrl(contractInfoPO.getContractDocUrl());
                            fileList.add(interFaceContractFzSyncReqFileBo);
                            interFaceContractFzSyncReqBo.setFileList(fileList);
                        }
                        this.interFaceContractFzSyncService.syncContractFz(interFaceContractFzSyncReqBo);
                    }
                    catch (Exception e3) {
                        log.error("\u63a8\u9001\u975e\u62db\u5931\u8d25\uff1a" + e3.getMessage());
                    }
                }
                if (!CollectionUtils.isEmpty(relBuySaleContractPOS = this.cRelBuySaleContractMapper.getListBuyId(this.contractId)) && (saleInfoPO = this.contractInfoMapper.selectByPrimaryKey(saleContractId = relBuySaleContractPOS.get(0).getSaleContractId())) != null && ContractConstant.ContractStatus.CONTRACT_STATUS_FREEZE.equals(saleInfoPO.getContractStatus())) {
                    ContractPurchaseSyncSaleContractBusiReqBO busiReqBO = new ContractPurchaseSyncSaleContractBusiReqBO();
                    busiReqBO.setContractId(this.contractId);
                    busiReqBO.setOperationType(2);
                    ContractPurchaseSyncSaleContractBusiRspBO syncSaleContractBusiRspBO = this.contractPurchaseSyncSaleContractAtomiService.purchaseSyncSaleContract(busiReqBO);
                    if (!"0000".equals(syncSaleContractBusiRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u540c\u6b65\u91c7\u9500\u5408\u540c\u5931\u8d25" + syncSaleContractBusiRspBO.getRespDesc());
                    }
                }
            } else if (ContractConstant.ContractSignatureEnvelopeStatus.WAITING_TO_SIGN.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                List<EnvelopeParticipantAtomBO> envelopeParticipants = atomRspBO.getEnvelopeParticipants();
                if (CollectionUtils.isEmpty(envelopeParticipants)) {
                    throw new ZTBusinessException("\u53c2\u4e0e\u8005\u4fe1\u606f\u4e3a\u7a7a");
                }
                ArrayList<String> nodes = new ArrayList<String>();
                nodes.add("FIRST_PARTY_SIGN");
                nodes.add("SECOND_PARTY_SIGN");
                nodes.add("THIRD_PARTY_SIGN");
                this.contractOperateNodeRecordMapper.deleteByContractIdAndNodes(this.contractId, nodes);
                List<EnvelopeParticipantAtomBO> partSignInfoS = envelopeParticipants.stream().filter(e -> e.getRoleType() != null && e.getRoleType().equals(1)).collect(Collectors.toList());
                this.recordSignSucceeNode(partSignInfoS);
                for (EnvelopeParticipantAtomBO signInfo : partSignInfoS) {
                    ContractInfoPO contractInfoPO1;
                    if (!signInfo.getStatus().equals(ContractConstant.ContractSignerStatus.SIGNED_SUCCESS)) continue;
                    if (partSignInfoS.size() == 2) {
                        if (this.getSignatureSort() == 0) {
                            if (signInfo.getAssignedSeq() == 1 && ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                                contractInfoPO1 = new ContractInfoPO();
                                contractInfoPO1.setContractId(this.contractId);
                                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE);
                                contractInfoPO1.setIsProcess(0);
                                this.contractInfoMapper.updateContract(contractInfoPO1);
                                break;
                            }
                        } else if (signInfo.getAssignedSeq() == 1 && ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                            contractInfoPO1 = new ContractInfoPO();
                            contractInfoPO1.setContractId(this.contractId);
                            contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE);
                            contractInfoPO1.setIsProcess(0);
                            this.contractInfoMapper.updateContract(contractInfoPO1);
                            break;
                        }
                    }
                    if (partSignInfoS.size() == 3) {
                        if (this.getSignatureSort() == 0) {
                            if (signInfo.getAssignedSeq() == 2 && ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                                contractInfoPO1 = new ContractInfoPO();
                                contractInfoPO1.setContractId(this.contractId);
                                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE);
                                contractInfoPO1.setIsProcess(0);
                                this.contractInfoMapper.updateContract(contractInfoPO1);
                                break;
                            }
                        } else if (signInfo.getAssignedSeq() == 1 && ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                            contractInfoPO1 = new ContractInfoPO();
                            contractInfoPO1.setContractId(this.contractId);
                            contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE);
                            contractInfoPO1.setIsProcess(0);
                            this.contractInfoMapper.updateContract(contractInfoPO1);
                            break;
                        }
                    }
                    if (partSignInfoS.size() == 4) {
                        if (this.getSignatureSort() == 0) {
                            if (signInfo.getAssignedSeq() == 2 && ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                                contractInfoPO1 = new ContractInfoPO();
                                contractInfoPO1.setContractId(this.contractId);
                                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE);
                                contractInfoPO1.setIsProcess(0);
                                this.contractInfoMapper.updateContract(contractInfoPO1);
                                break;
                            }
                        } else if (signInfo.getAssignedSeq() == 2 && ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                            contractInfoPO1 = new ContractInfoPO();
                            contractInfoPO1.setContractId(this.contractId);
                            contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE);
                            contractInfoPO1.setIsProcess(0);
                            this.contractInfoMapper.updateContract(contractInfoPO1);
                            break;
                        }
                    }
                    if (partSignInfoS.size() != 6) continue;
                    if (this.getSignatureSort() == 0) {
                        if (signInfo.getAssignedSeq() == 2 && ContractConstant.ContractStatus.CONTRACT_THIRD_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                            contractInfoPO1 = new ContractInfoPO();
                            contractInfoPO1.setContractId(this.contractId);
                            contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE);
                            contractInfoPO1.setIsProcess(0);
                            this.contractInfoMapper.updateContract(contractInfoPO1);
                            break;
                        }
                        if (signInfo.getAssignedSeq() != 4 || !ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) continue;
                        contractInfoPO1 = new ContractInfoPO();
                        contractInfoPO1.setContractId(this.contractId);
                        contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE);
                        contractInfoPO1.setIsProcess(0);
                        this.contractInfoMapper.updateContract(contractInfoPO1);
                        break;
                    }
                    if (signInfo.getAssignedSeq() == 2 && ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) {
                        contractInfoPO1 = new ContractInfoPO();
                        contractInfoPO1.setContractId(this.contractId);
                        contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_THIRD_PARTY_WAIT_SIGNATURE);
                        contractInfoPO1.setIsProcess(0);
                        this.contractInfoMapper.updateContract(contractInfoPO1);
                        break;
                    }
                    if (signInfo.getAssignedSeq() != 4 || !ContractConstant.ContractStatus.CONTRACT_THIRD_PARTY_WAIT_SIGNATURE.equals(this.contractStatus)) continue;
                    contractInfoPO1 = new ContractInfoPO();
                    contractInfoPO1.setContractId(this.contractId);
                    contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE);
                    contractInfoPO1.setIsProcess(0);
                    this.contractInfoMapper.updateContract(contractInfoPO1);
                    break;
                }
                ContractInfoPO contractInfoPO1 = new ContractInfoPO();
                contractInfoPO1.setContractId(this.contractId);
                contractInfoPO1.setIsProcess(0);
                this.contractInfoMapper.updateContract(contractInfoPO1);
                ArrayList<Integer> types = new ArrayList<Integer>();
                types.add(ContractConstant.SignOperLogType.SIGN_INIT);
                this.contractSignOperLogMapper.deleteByNotInTypes(types, this.envelopeId);
                ContractInfoPO po = new ContractInfoPO();
                po.setContractId(this.contractId);
                this.recordSignSucceeLog(sdf, po, partSignInfoS);
            } else {
                if (!ContractConstant.ContractSignatureEnvelopeStatus.REJECT.equals(atomRspBO.getEnvelopeBasicInfo().getStatus()) && !ContractConstant.ContractSignatureEnvelopeStatus.REVOKE.equals(atomRspBO.getEnvelopeBasicInfo().getStatus()) && !ContractConstant.ContractSignatureEnvelopeStatus.INVALID.equals(atomRspBO.getEnvelopeBasicInfo().getStatus()) && !ContractConstant.ContractSignatureEnvelopeStatus.EXPIRED.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) throw new ZTBusinessException("\u6b64\u5408\u540c\u7535\u5b50\u7b7e\u7ae0\u4fe1\u5c01\u72b6\u6001\u6ca1\u6709\u5904\u7406\u6d41\u7a0b");
                ContractInfoPO contractInfoPO1 = new ContractInfoPO();
                contractInfoPO1.setContractId(this.contractId);
                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
                contractInfoPO1.setIsProcess(2);
                int updateResult = this.contractInfoMapper.updateContract(contractInfoPO1);
                if (updateResult != 1) throw new ZTBusinessException("\u4fee\u6539\u5408\u540c\u6570\u636e\u5931\u8d25");
                ArrayList<String> nodes = new ArrayList<String>();
                nodes.add("SEND_SIGN");
                nodes.add("FIRST_PARTY_SIGN");
                nodes.add("SECOND_PARTY_SIGN");
                nodes.add("THIRD_PARTY_SIGN");
                this.contractOperateNodeRecordMapper.deleteByContractIdAndNodes(this.contractId, nodes);
                ArrayList<Integer> types = new ArrayList<Integer>();
                types.add(ContractConstant.SignOperLogType.SIGN_INIT);
                this.contractSignOperLogMapper.deleteByNotInTypes(types, this.envelopeId);
                List<EnvelopeParticipantAtomBO> envelopeParticipants = atomRspBO.getEnvelopeParticipants();
                List<EnvelopeParticipantAtomBO> partSignInfoS = envelopeParticipants.stream().filter(e -> e.getRoleType() != null && e.getRoleType().equals(1)).collect(Collectors.toList());
                List initSignerList = envelopeParticipants.stream().filter(e -> e.getRoleType() != null && e.getRoleType().equals(0)).collect(Collectors.toList());
                if (ContractConstant.ContractSignatureEnvelopeStatus.REJECT.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    this.recordSignSucceeLog(sdf, contractInfoPO1, partSignInfoS);
                    for (EnvelopeParticipantAtomBO signInfo : partSignInfoS) {
                        if (!signInfo.getStatus().equals(ContractConstant.ContractSignerStatus.REJECT_SIGN)) continue;
                        CContractSignOperLogPO cContractSignOperLogPO1 = new CContractSignOperLogPO();
                        cContractSignOperLogPO1.setId(this.uccBatchSequence.nextId());
                        cContractSignOperLogPO1.setEnvelopeId(this.envelopeId);
                        cContractSignOperLogPO1.setContractId(contractInfoPO1.getContractId());
                        int i = signInfo.getName().lastIndexOf("(");
                        if (i != -1) {
                            cContractSignOperLogPO1.setOperUserName(signInfo.getName().substring(i + 1, signInfo.getName().length() - 1));
                        } else {
                            cContractSignOperLogPO1.setOperUserName(signInfo.getName());
                        }
                        if (partSignInfoS.size() == 2) {
                            if (signInfo.getAssignedSeq() == 1) {
                                if (this.getSignatureSort() == 0) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                } else {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                            } else if (this.getSignatureSort() == 0) {
                                cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                cContractSignOperLogPO1.setCompanyName(this.supplierName);
                            } else {
                                cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                cContractSignOperLogPO1.setCompanyName(this.buyerName);
                            }
                        }
                        if (partSignInfoS.size() == 3) {
                            if (this.getSignatureSort() == 0) {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                } else {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                            } else if (signInfo.getAssignedSeq() == 1) {
                                cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                cContractSignOperLogPO1.setCompanyName(this.buyerName);
                            } else {
                                cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                cContractSignOperLogPO1.setCompanyName(this.supplierName);
                            }
                        }
                        if (partSignInfoS.size() == 4) {
                            if (this.getSignatureSort() == 0) {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                } else {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                            } else if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                cContractSignOperLogPO1.setCompanyName(this.supplierName);
                            } else {
                                cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                cContractSignOperLogPO1.setCompanyName(this.buyerName);
                            }
                        }
                        if (partSignInfoS.size() == 6) {
                            if (this.getSignatureSort() == 0) {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.multiDealerCode);
                                    cContractSignOperLogPO1.setCompanyName(this.multiDealerName);
                                }
                                if (signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 4) {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                                if (signInfo.getAssignedSeq() == 5 || signInfo.getAssignedSeq() == 6) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                }
                            } else {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                                if (signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 4) {
                                    cContractSignOperLogPO1.setCompanyCode(this.multiDealerCode);
                                    cContractSignOperLogPO1.setCompanyName(this.multiDealerName);
                                }
                                if (signInfo.getAssignedSeq() == 5 || signInfo.getAssignedSeq() == 6) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                }
                            }
                        }
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_REJECT);
                        cContractSignOperLogPO1.setOperTypeStr("\u62d2\u7b7e");
                        try {
                            cContractSignOperLogPO1.setOperTime(sdf.parse(signInfo.getModifiedDatetime()));
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        this.contractSignOperLogMapper.insertSelective(cContractSignOperLogPO1);
                        break;
                    }
                } else if (ContractConstant.ContractSignatureEnvelopeStatus.REVOKE.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    this.recordSignSucceeLog(sdf, contractInfoPO1, partSignInfoS);
                    initSignerList.get(0);
                    CContractSignOperLogPO cContractSignOperLogPO1 = new CContractSignOperLogPO();
                    cContractSignOperLogPO1.setId(this.uccBatchSequence.nextId());
                    cContractSignOperLogPO1.setEnvelopeId(this.envelopeId);
                    cContractSignOperLogPO1.setContractId(contractInfoPO1.getContractId());
                    cContractSignOperLogPO1.setCompanyCode(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getEnterpriseCreditCode());
                    int i = ((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().lastIndexOf("(");
                    if (i != -1) {
                        cContractSignOperLogPO1.setOperUserName(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().substring(i + 1, ((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().length() - 1));
                        cContractSignOperLogPO1.setCompanyName(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().substring(0, i));
                    }
                    cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_INIT_BACK);
                    cContractSignOperLogPO1.setOperTypeStr("\u53d1\u8d77\u65b9\u64a4\u56de");
                    try {
                        cContractSignOperLogPO1.setOperTime(sdf.parse(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getModifiedDatetime()));
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    this.contractSignOperLogMapper.insertSelective(cContractSignOperLogPO1);
                } else if (ContractConstant.ContractSignatureEnvelopeStatus.INVALID.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    this.recordSignSucceeLog(sdf, contractInfoPO1, partSignInfoS);
                    for (EnvelopeParticipantAtomBO signInfo : partSignInfoS) {
                        if (!signInfo.getStatus().equals(ContractConstant.ContractSignerStatus.INVALID_SIGN)) continue;
                        CContractSignOperLogPO cContractSignOperLogPO1 = new CContractSignOperLogPO();
                        cContractSignOperLogPO1.setId(this.uccBatchSequence.nextId());
                        cContractSignOperLogPO1.setEnvelopeId(this.envelopeId);
                        cContractSignOperLogPO1.setContractId(contractInfoPO1.getContractId());
                        int i = signInfo.getName().lastIndexOf("(");
                        if (i != -1) {
                            cContractSignOperLogPO1.setOperUserName(signInfo.getName().substring(i + 1, signInfo.getName().length() - 1));
                        } else {
                            cContractSignOperLogPO1.setOperUserName(signInfo.getName());
                        }
                        if (partSignInfoS.size() == 2) {
                            if (signInfo.getAssignedSeq() == 1) {
                                if (this.getSignatureSort() == 0) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                } else {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                            } else if (this.getSignatureSort() == 0) {
                                cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                cContractSignOperLogPO1.setCompanyName(this.supplierName);
                            } else {
                                cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                cContractSignOperLogPO1.setCompanyName(this.buyerName);
                            }
                        }
                        if (partSignInfoS.size() == 3) {
                            if (this.getSignatureSort() == 0) {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                } else {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                            } else if (signInfo.getAssignedSeq() == 1) {
                                cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                cContractSignOperLogPO1.setCompanyName(this.buyerName);
                            } else {
                                cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                cContractSignOperLogPO1.setCompanyName(this.supplierName);
                            }
                        }
                        if (partSignInfoS.size() == 4) {
                            if (this.getSignatureSort() == 0) {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                } else {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                            } else if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                cContractSignOperLogPO1.setCompanyName(this.supplierName);
                            } else {
                                cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                cContractSignOperLogPO1.setCompanyName(this.buyerName);
                            }
                        }
                        if (partSignInfoS.size() == 6) {
                            if (this.getSignatureSort() == 0) {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.multiDealerCode);
                                    cContractSignOperLogPO1.setCompanyName(this.multiDealerName);
                                }
                                if (signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 4) {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                                if (signInfo.getAssignedSeq() == 5 || signInfo.getAssignedSeq() == 6) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                }
                            } else {
                                if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                                }
                                if (signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 4) {
                                    cContractSignOperLogPO1.setCompanyCode(this.multiDealerCode);
                                    cContractSignOperLogPO1.setCompanyName(this.multiDealerName);
                                }
                                if (signInfo.getAssignedSeq() == 5 || signInfo.getAssignedSeq() == 6) {
                                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                                }
                            }
                        }
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_INVALID);
                        cContractSignOperLogPO1.setOperTypeStr("\u4f5c\u5e9f\u7b7e\u7f72");
                        try {
                            cContractSignOperLogPO1.setOperTime(sdf.parse(signInfo.getModifiedDatetime()));
                        }
                        catch (Exception e6) {
                            // empty catch block
                        }
                        this.contractSignOperLogMapper.insertSelective(cContractSignOperLogPO1);
                        break;
                    }
                    initSignerList.get(0);
                    CContractSignOperLogPO cContractSignOperLogPO1 = new CContractSignOperLogPO();
                    cContractSignOperLogPO1.setId(this.uccBatchSequence.nextId());
                    cContractSignOperLogPO1.setEnvelopeId(this.envelopeId);
                    cContractSignOperLogPO1.setContractId(contractInfoPO1.getContractId());
                    cContractSignOperLogPO1.setCompanyCode(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getEnterpriseCreditCode());
                    int i = ((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().lastIndexOf("(");
                    if (i != -1) {
                        cContractSignOperLogPO1.setOperUserName(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().substring(i + 1, ((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().length() - 1));
                        cContractSignOperLogPO1.setCompanyName(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().substring(0, i));
                    }
                    cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_INVALID);
                    cContractSignOperLogPO1.setOperTypeStr("\u4f5c\u5e9f\u7b7e\u7f72");
                    try {
                        cContractSignOperLogPO1.setOperTime(sdf.parse(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getModifiedDatetime()));
                    }
                    catch (Exception e7) {
                        // empty catch block
                    }
                    this.contractSignOperLogMapper.insertSelective(cContractSignOperLogPO1);
                } else if (ContractConstant.ContractSignatureEnvelopeStatus.EXPIRED.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                    this.recordSignSucceeLog(sdf, contractInfoPO1, partSignInfoS);
                    initSignerList.get(0);
                    CContractSignOperLogPO cContractSignOperLogPO1 = new CContractSignOperLogPO();
                    cContractSignOperLogPO1.setId(this.uccBatchSequence.nextId());
                    cContractSignOperLogPO1.setEnvelopeId(this.envelopeId);
                    cContractSignOperLogPO1.setContractId(contractInfoPO1.getContractId());
                    cContractSignOperLogPO1.setCompanyCode(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getEnterpriseCreditCode());
                    int i = ((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().lastIndexOf("(");
                    if (i != -1) {
                        cContractSignOperLogPO1.setOperUserName(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().substring(i + 1, ((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().length() - 1));
                        cContractSignOperLogPO1.setCompanyName(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getName().substring(0, i));
                    }
                    cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_OVERDUE);
                    cContractSignOperLogPO1.setOperTypeStr("\u4fe1\u5c01\u8fc7\u671f");
                    try {
                        cContractSignOperLogPO1.setOperTime(sdf.parse(((EnvelopeParticipantAtomBO)initSignerList.get(0)).getModifiedDatetime()));
                    }
                    catch (Exception e8) {
                        // empty catch block
                    }
                    this.contractSignOperLogMapper.insertSelective(cContractSignOperLogPO1);
                }
            }
            this.syncOfflineContract(this.contractId);
        }
        catch (Exception e9) {
            ContractInfoPO updatePO = new ContractInfoPO();
            updatePO.setContractId(this.contractId);
            updatePO.setIsProcess(0);
            this.contractInfoMapper.updateByPrimaryKeySelective(updatePO);
            System.out.println("\u540c\u6b65\u7b7e\u7ae0\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u7ebf\u7a0b\u5904\u7406\u51fa\u73b0\u5f02\u5e38" + e9.getMessage());
            log.error("\u540c\u6b65\u7b7e\u7ae0\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u7ebf\u7a0b\u5904\u7406\u51fa\u73b0\u5f02\u5e38" + e9.getMessage());
        }
        if (!CollectionUtils.isEmpty(pushErpContractIds) || !CollectionUtils.isEmpty(pushPlanContractIds)) {
            ContractPushErpBusiReqBO contractPushErpBusiReqBO = new ContractPushErpBusiReqBO();
            try {
                contractPushErpBusiReqBO.setContractIds(pushErpContractIds);
                contractPushErpBusiReqBO.setPushPlanContractIds(pushPlanContractIds);
                System.out.println("\u53d1\u9001\u540c\u6b65erp\u6d88\u606f\uff1a" + JSON.toJSONString((Object)((Object)contractPushErpBusiReqBO)));
                this.mqContractPushErpProvider.send(new ProxyMessage(this.contractPushErpTopic, this.contractPushErpTag, JSON.toJSONString((Object)((Object)contractPushErpBusiReqBO))));
            }
            catch (Exception e10) {
                System.out.println("\u53d1\u9001\u540c\u6b65erp\u6d88\u606f\uff1a" + e10.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)((Object)contractPushErpBusiReqBO)));
            }
        }
        if ("0".equals(this.signatureEffectPushlegal) || CollectionUtils.isEmpty(pushLegalContractIds)) return;
        pushLegalContractIds.forEach(p -> {
            ContractSignPushLegalBusiReqBO reqBO = new ContractSignPushLegalBusiReqBO();
            reqBO.setContractId((Long)p);
            this.contractSignPushLegalBusiService.dealSignPushLegal(reqBO);
            ContractPushLogPO pushLogPO = new ContractPushLogPO();
            pushLogPO.setId(Sequence.getInstance().nextId());
            pushLogPO.setType(12);
            pushLogPO.setCreateTime(new Date());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            String pushLegalReturnTimeStr = sdf1.format(reqBO.getPushLegalReturnTime());
            String pushLegalTimeStr = sdf1.format(reqBO.getPushLegalTime());
            pushLogPO.setRspJson("\u8c03\u7528\u63a8\u9001\u65f6\u95f4" + pushLegalTimeStr + "\u63a8\u9001\u8fd4\u56de\u65f6\u95f4" + pushLegalReturnTimeStr + "\u63a8\u9001\u8fd4\u56de\u62a5\u6587" + reqBO.getPushLegalReturnInfo());
            pushLogPO.setReqJson(reqBO.getReqJson());
            this.contractPushLogMapper.insert(pushLogPO);
        });
    }

    private void recordSignSucceeLog(SimpleDateFormat sdf, ContractInfoPO contractInfoPO1, List<EnvelopeParticipantAtomBO> partSignInfoS) {
        for (EnvelopeParticipantAtomBO signInfo : partSignInfoS) {
            if (!signInfo.getStatus().equals(ContractConstant.ContractSignerStatus.SIGNED_SUCCESS)) continue;
            CContractSignOperLogPO cContractSignOperLogPO1 = new CContractSignOperLogPO();
            cContractSignOperLogPO1.setId(this.uccBatchSequence.nextId());
            cContractSignOperLogPO1.setEnvelopeId(this.envelopeId);
            cContractSignOperLogPO1.setContractId(contractInfoPO1.getContractId());
            int i = signInfo.getName().lastIndexOf("(");
            if (i != -1) {
                cContractSignOperLogPO1.setOperUserName(signInfo.getName().substring(i + 1, signInfo.getName().length() - 1));
            } else {
                cContractSignOperLogPO1.setOperUserName(signInfo.getName());
            }
            cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_OK);
            cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u7ae0\u5b8c\u6210");
            if (partSignInfoS.size() == 2) {
                if (signInfo.getAssignedSeq() == 1) {
                    if (this.getSignatureSort() == 0) {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    } else {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    }
                } else if (this.getSignatureSort() == 0) {
                    cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                    cContractSignOperLogPO1.setCompanyName(this.supplierName);
                } else {
                    cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                    cContractSignOperLogPO1.setCompanyName(this.buyerName);
                }
            }
            if (partSignInfoS.size() == 3) {
                if (this.getSignatureSort() == 0) {
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    } else {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    }
                    if (signInfo.getAssignedSeq() == 1) {
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_NAME_OK);
                        cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u540d\u5b8c\u6210");
                    }
                } else {
                    if (signInfo.getAssignedSeq() == 1) {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    } else {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    }
                    if (signInfo.getAssignedSeq() == 3) {
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_NAME_OK);
                        cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u540d\u5b8c\u6210");
                    }
                }
            }
            if (partSignInfoS.size() == 4) {
                if (this.getSignatureSort() == 0) {
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    } else {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    }
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 3) {
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_NAME_OK);
                        cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u540d\u5b8c\u6210");
                    }
                } else {
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    } else {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    }
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 3) {
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_NAME_OK);
                        cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u540d\u5b8c\u6210");
                    }
                }
            }
            if (partSignInfoS.size() == 6) {
                if (this.getSignatureSort() == 0) {
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                        cContractSignOperLogPO1.setCompanyCode(this.multiDealerCode);
                        cContractSignOperLogPO1.setCompanyName(this.multiDealerName);
                    }
                    if (signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 4) {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    }
                    if (signInfo.getAssignedSeq() == 5 || signInfo.getAssignedSeq() == 6) {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    }
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 5) {
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_NAME_OK);
                        cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u540d\u5b8c\u6210");
                    }
                } else {
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 2) {
                        cContractSignOperLogPO1.setCompanyCode(this.supplierId != null ? this.supplierId.toString() : "");
                        cContractSignOperLogPO1.setCompanyName(this.supplierName);
                    }
                    if (signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 4) {
                        cContractSignOperLogPO1.setCompanyCode(this.multiDealerCode);
                        cContractSignOperLogPO1.setCompanyName(this.multiDealerName);
                    }
                    if (signInfo.getAssignedSeq() == 5 || signInfo.getAssignedSeq() == 6) {
                        cContractSignOperLogPO1.setCompanyCode(this.buyerNo);
                        cContractSignOperLogPO1.setCompanyName(this.buyerName);
                    }
                    if (signInfo.getAssignedSeq() == 1 || signInfo.getAssignedSeq() == 3 || signInfo.getAssignedSeq() == 5) {
                        cContractSignOperLogPO1.setOperType(ContractConstant.SignOperLogType.SIGN_NAME_OK);
                        cContractSignOperLogPO1.setOperTypeStr("\u7b7e\u540d\u5b8c\u6210");
                    }
                }
            }
            try {
                cContractSignOperLogPO1.setOperTime(sdf.parse(signInfo.getModifiedDatetime()));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.contractSignOperLogMapper.insertSelective(cContractSignOperLogPO1);
        }
    }

    private void recordSignSucceeNode(List<EnvelopeParticipantAtomBO> partSignInfoS) {
        for (EnvelopeParticipantAtomBO signInfo : partSignInfoS) {
            ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO1;
            if (!signInfo.getStatus().equals(ContractConstant.ContractSignerStatus.SIGNED_SUCCESS)) continue;
            if (partSignInfoS.size() == 2) {
                contractRecordContractNodeOperLogAtomReqBO1 = new ContractRecordContractNodeOperLogAtomReqBO();
                contractRecordContractNodeOperLogAtomReqBO1.setContractId(this.contractId);
                contractRecordContractNodeOperLogAtomReqBO1.setOperUserId(1L);
                contractRecordContractNodeOperLogAtomReqBO1.setOperUserName("admin");
                contractRecordContractNodeOperLogAtomReqBO1.setOperTime(signInfo.getModifiedDatetime());
                if (this.getSignatureSort() == 0) {
                    if (signInfo.getAssignedSeq() == 1) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    } else {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                } else if (signInfo.getAssignedSeq() == 1) {
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                    this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                } else {
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                    this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                }
            }
            if (partSignInfoS.size() == 3) {
                contractRecordContractNodeOperLogAtomReqBO1 = new ContractRecordContractNodeOperLogAtomReqBO();
                contractRecordContractNodeOperLogAtomReqBO1.setContractId(this.contractId);
                contractRecordContractNodeOperLogAtomReqBO1.setOperUserId(1L);
                contractRecordContractNodeOperLogAtomReqBO1.setOperUserName("admin");
                contractRecordContractNodeOperLogAtomReqBO1.setOperTime(signInfo.getModifiedDatetime());
                if (this.getSignatureSort() == 0) {
                    if (signInfo.getAssignedSeq() == 2) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                    if (signInfo.getAssignedSeq() == 3) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                } else {
                    if (signInfo.getAssignedSeq() == 1) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                    if (signInfo.getAssignedSeq() == 3) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                }
            }
            if (partSignInfoS.size() == 4) {
                contractRecordContractNodeOperLogAtomReqBO1 = new ContractRecordContractNodeOperLogAtomReqBO();
                contractRecordContractNodeOperLogAtomReqBO1.setContractId(this.contractId);
                contractRecordContractNodeOperLogAtomReqBO1.setOperUserId(1L);
                contractRecordContractNodeOperLogAtomReqBO1.setOperUserName("admin");
                contractRecordContractNodeOperLogAtomReqBO1.setOperTime(signInfo.getModifiedDatetime());
                if (this.getSignatureSort() == 0) {
                    if (signInfo.getAssignedSeq() == 2) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                    if (signInfo.getAssignedSeq() == 4) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                } else {
                    if (signInfo.getAssignedSeq() == 2) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                    if (signInfo.getAssignedSeq() == 4) {
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                        contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                    }
                }
            }
            if (partSignInfoS.size() != 6) continue;
            contractRecordContractNodeOperLogAtomReqBO1 = new ContractRecordContractNodeOperLogAtomReqBO();
            contractRecordContractNodeOperLogAtomReqBO1.setContractId(this.contractId);
            contractRecordContractNodeOperLogAtomReqBO1.setOperUserId(1L);
            contractRecordContractNodeOperLogAtomReqBO1.setOperUserName("admin");
            contractRecordContractNodeOperLogAtomReqBO1.setOperTime(signInfo.getModifiedDatetime());
            if (this.getSignatureSort() == 0) {
                if (signInfo.getAssignedSeq() == 6) {
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                    this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                }
                if (signInfo.getAssignedSeq() == 4) {
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                    contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                    this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                }
                if (signInfo.getAssignedSeq() != 2) continue;
                contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("THIRD_PARTY_SIGN");
                contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e19\u65b9\u7b7e\u7ae0");
                this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
                continue;
            }
            if (signInfo.getAssignedSeq() == 2) {
                contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("SECOND_PARTY_SIGN");
                contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e59\u65b9\u7b7e\u7ae0");
                this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
            }
            if (signInfo.getAssignedSeq() == 6) {
                contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("FIRST_PARTY_SIGN");
                contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u7532\u65b9\u7b7e\u7ae0");
                this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
            }
            if (signInfo.getAssignedSeq() != 4) continue;
            contractRecordContractNodeOperLogAtomReqBO1.setNodeCode("THIRD_PARTY_SIGN");
            contractRecordContractNodeOperLogAtomReqBO1.setNodeName("\u4e19\u65b9\u7b7e\u7ae0");
            this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO1);
        }
    }

    public void replaceFile(Long envelopeId, String accessToken, List<EnvelopeContentAtomBO> envelopeContents, List<CContractSignFilePO> signFilePOList) {
        log.error("\u4fe1\u5c01\u8fd4\u56de\u9644\u4ef6\u4fe1\u606f\uff1a" + JSON.toJSONString(envelopeContents));
        if (!CollectionUtils.isEmpty(envelopeContents)) {
            Map<Long, CContractSignFilePO> signFileMap = signFilePOList.stream().collect(Collectors.toMap(CContractSignFilePO::getFileId, bo -> bo, (k1, k2) -> k1));
            for (EnvelopeContentAtomBO envelopeContent : envelopeContents) {
                ContractDownloadSignDocumentAbilityReqBO signDocumentAbilityReqBO = new ContractDownloadSignDocumentAbilityReqBO();
                signDocumentAbilityReqBO.setEnvelopeId(envelopeId);
                signDocumentAbilityReqBO.setAccessToken(accessToken);
                signDocumentAbilityReqBO.setFileId(envelopeContent.getId());
                ContractDownloadSignDocumentAbilityRspBO contractDownloadSignDocumentAbilityRspBO = this.contractDownloadSignDocumentAbilityService.downloadSignDocument(signDocumentAbilityReqBO);
                if ("0000".equals(contractDownloadSignDocumentAbilityRspBO.getRespCode())) {
                    String fileUrl = contractDownloadSignDocumentAbilityRspBO.getFileUrl();
                    if (signFileMap.get(envelopeContent.getFileId()) == null) continue;
                    CContractSignFilePO cContractSignFilePO = signFileMap.get(envelopeContent.getFileId());
                    if (cContractSignFilePO.getFileType() == 1 || cContractSignFilePO.getFileType() == 3) {
                        ContractInfoPO updatePO = new ContractInfoPO();
                        updatePO.setContractId(cContractSignFilePO.getRelateId());
                        if (cContractSignFilePO.getFileType() == 1) {
                            updatePO.setContractDocUrl(fileUrl);
                        }
                        if (cContractSignFilePO.getFileType() == 3) {
                            updatePO.setItemPdfAccessoryUrl(fileUrl);
                        }
                        this.contractInfoMapper.updateContract(updatePO);
                        continue;
                    }
                    if (cContractSignFilePO.getFileType() == 2) {
                        ContractAccessoryPo updatePo = new ContractAccessoryPo();
                        updatePo.setAcceessoryId(cContractSignFilePO.getRelateId());
                        updatePo.setAcceessoryUrl(fileUrl);
                        this.contractAccessoryMapper.updateByPrimaryKeySelective(updatePo);
                        continue;
                    }
                    throw new ZTBusinessException("\u9644\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408");
                }
                throw new ZTBusinessException(contractDownloadSignDocumentAbilityRspBO.getRespDesc());
            }
        } else {
            throw new ZTBusinessException("\u4fe1\u5c01\u9644\u4ef6\u8fd4\u56de\u4e3a\u7a7a");
        }
    }

    private String getAccessToken(String clientId, String secret) {
        String accessToken = null;
        InterFaceContractSignAccessTokenCreateAtomReqBO signAccessTokenCreateAtomReqBO = new InterFaceContractSignAccessTokenCreateAtomReqBO();
        signAccessTokenCreateAtomReqBO.setClientId(clientId);
        signAccessTokenCreateAtomReqBO.setSecret(secret);
        InterFaceContractSignAccessTokenCreateAtomRspBO signAccessTokenCreateAtomRspBO = this.interFaceContractSignAccessTokenCreateAtomService.signAccessTokenCreate(signAccessTokenCreateAtomReqBO);
        if (!"0000".equals(signAccessTokenCreateAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(signAccessTokenCreateAtomRspBO.getRespDesc());
        }
        accessToken = signAccessTokenCreateAtomRspBO.getAccessToken();
        return accessToken;
    }

    private void platformContractPushErpPlan(ContractInfoPO contractInfoPO, ContractInfoPO contractInfoPO1, List<Long> pushPlanContractIds) {
        if (ObjectUtil.isNotEmpty((Object)contractInfoPO) && ContractConstant.BusinessType.TRIPARTITE_INTERNAL_AGENCY.equals(contractInfoPO.getBusinessType()) && ObjectUtil.isNotEmpty((Object)contractInfoPO.getPushErpFlag()) && contractInfoPO.getPushErpFlag() == 1 && ContractIsJy.isJy(contractInfoPO1.getIsJy()).booleanValue()) {
            contractInfoPO1.setPushPlanStatus(ContractConstant.PushErpStatus.IN_SYNC);
            pushPlanContractIds.add(this.contractId);
        }
    }

    public InterFaceContractGetEnvelopesDetailAtomService getInterFaceContractGetEnvelopesDetailAtomService() {
        return this.interFaceContractGetEnvelopesDetailAtomService;
    }

    public void setInterFaceContractGetEnvelopesDetailAtomService(InterFaceContractGetEnvelopesDetailAtomService interFaceContractGetEnvelopesDetailAtomService) {
        this.interFaceContractGetEnvelopesDetailAtomService = interFaceContractGetEnvelopesDetailAtomService;
    }

    public ContractInfoMapper getContractInfoMapper() {
        return this.contractInfoMapper;
    }

    public void setContractInfoMapper(ContractInfoMapper contractInfoMapper) {
        this.contractInfoMapper = contractInfoMapper;
    }

    public ContractAccessoryMapper getContractAccessoryMapper() {
        return this.contractAccessoryMapper;
    }

    public void setContractAccessoryMapper(ContractAccessoryMapper contractAccessoryMapper) {
        this.contractAccessoryMapper = contractAccessoryMapper;
    }

    public Long getEnvelopeId() {
        return this.envelopeId;
    }

    public void setEnvelopeId(Long envelopeId) {
        this.envelopeId = envelopeId;
    }

    public Long getContractId() {
        return this.contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public ProxyMessageProducer getSyncContractFreezeStatusProvider() {
        return this.syncContractFreezeStatusProvider;
    }

    public void setSyncContractFreezeStatusProvider(ProxyMessageProducer syncContractFreezeStatusProvider) {
        this.syncContractFreezeStatusProvider = syncContractFreezeStatusProvider;
    }

    public CContractAgrMapper getcContractAgrMapper() {
        return this.cContractAgrMapper;
    }

    public void setcContractAgrMapper(CContractAgrMapper cContractAgrMapper) {
        this.cContractAgrMapper = cContractAgrMapper;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getContractStatus() {
        return this.contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Integer getSignatureSort() {
        return this.signatureSort;
    }

    public void setSignatureSort(Integer signatureSort) {
        this.signatureSort = signatureSort;
    }

    public InterFaceContractSignAccessTokenCreateAtomService getInterFaceContractSignAccessTokenCreateAtomService() {
        return this.interFaceContractSignAccessTokenCreateAtomService;
    }

    public void setInterFaceContractSignAccessTokenCreateAtomService(InterFaceContractSignAccessTokenCreateAtomService interFaceContractSignAccessTokenCreateAtomService) {
        this.interFaceContractSignAccessTokenCreateAtomService = interFaceContractSignAccessTokenCreateAtomService;
    }

    public ContractDownloadSignDocumentAbilityService getContractDownloadSignDocumentAbilityService() {
        return this.contractDownloadSignDocumentAbilityService;
    }

    public void setContractDownloadSignDocumentAbilityService(ContractDownloadSignDocumentAbilityService contractDownloadSignDocumentAbilityService) {
        this.contractDownloadSignDocumentAbilityService = contractDownloadSignDocumentAbilityService;
    }

    public ContractRecordContractNodeOperLogAtomService getContractRecordContractNodeOperLogAtomService() {
        return this.contractRecordContractNodeOperLogAtomService;
    }

    public void setContractRecordContractNodeOperLogAtomService(ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService) {
        this.contractRecordContractNodeOperLogAtomService = contractRecordContractNodeOperLogAtomService;
    }

    public ContractOperateNodeRecordMapper getContractOperateNodeRecordMapper() {
        return this.contractOperateNodeRecordMapper;
    }

    public void setContractOperateNodeRecordMapper(ContractOperateNodeRecordMapper contractOperateNodeRecordMapper) {
        this.contractOperateNodeRecordMapper = contractOperateNodeRecordMapper;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CContractSignOperLogMapper getContractSignOperLogMapper() {
        return this.contractSignOperLogMapper;
    }

    public void setContractSignOperLogMapper(CContractSignOperLogMapper contractSignOperLogMapper) {
        this.contractSignOperLogMapper = contractSignOperLogMapper;
    }

    public String getBuyerNo() {
        return this.buyerNo;
    }

    public void setBuyerNo(String buyerNo) {
        this.buyerNo = buyerNo;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public Long getSupplierId() {
        return this.supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return this.supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getContractType() {
        return this.contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getPushErpFlag() {
        return this.pushErpFlag;
    }

    public void setPushErpFlag(Integer pushErpFlag) {
        this.pushErpFlag = pushErpFlag;
    }

    public ProxyMessageProducer getMqContractPushErpProvider() {
        return this.mqContractPushErpProvider;
    }

    public void setMqContractPushErpProvider(ProxyMessageProducer mqContractPushErpProvider) {
        this.mqContractPushErpProvider = mqContractPushErpProvider;
    }

    public String getContractPushErpTopic() {
        return this.contractPushErpTopic;
    }

    public void setContractPushErpTopic(String contractPushErpTopic) {
        this.contractPushErpTopic = contractPushErpTopic;
    }

    public String getContractPushErpTag() {
        return this.contractPushErpTag;
    }

    public void setContractPushErpTag(String contractPushErpTag) {
        this.contractPushErpTag = contractPushErpTag;
    }

    public Integer getValidaType() {
        return this.validaType;
    }

    public void setValidaType(Integer validaType) {
        this.validaType = validaType;
    }

    public Integer getValidaNum() {
        return this.validaNum;
    }

    public void setValidaNum(Integer validaNum) {
        this.validaNum = validaNum;
    }

    public String getMultiDealerName() {
        return this.multiDealerName;
    }

    public void setMultiDealerName(String multiDealerName) {
        this.multiDealerName = multiDealerName;
    }

    public String getMultiDealerCode() {
        return this.multiDealerCode;
    }

    public void setMultiDealerCode(String multiDealerCode) {
        this.multiDealerCode = multiDealerCode;
    }

    public ContractInfoItemMapper getContractInfoItemMapper() {
        return this.contractInfoItemMapper;
    }

    public void setContractInfoItemMapper(ContractInfoItemMapper contractInfoItemMapper) {
        this.contractInfoItemMapper = contractInfoItemMapper;
    }

    public InterFaceContractFzSyncService getInterFaceContractFzSyncService() {
        return this.interFaceContractFzSyncService;
    }

    public void setInterFaceContractFzSyncService(InterFaceContractFzSyncService interFaceContractFzSyncService) {
        this.interFaceContractFzSyncService = interFaceContractFzSyncService;
    }

    public ContractPurchaseSyncSaleContractAtomiService getContractPurchaseSyncSaleContractAtomiService() {
        return this.contractPurchaseSyncSaleContractAtomiService;
    }

    public void setContractPurchaseSyncSaleContractAtomiService(ContractPurchaseSyncSaleContractAtomiService contractPurchaseSyncSaleContractAtomiService) {
        this.contractPurchaseSyncSaleContractAtomiService = contractPurchaseSyncSaleContractAtomiService;
    }

    public CRelBuySaleContractMapper getcRelBuySaleContractMapper() {
        return this.cRelBuySaleContractMapper;
    }

    public void setcRelBuySaleContractMapper(CRelBuySaleContractMapper cRelBuySaleContractMapper) {
        this.cRelBuySaleContractMapper = cRelBuySaleContractMapper;
    }

    public ProxyMessageProducer getPlanDiversionSyncMsgProvider() {
        return this.planDiversionSyncMsgProvider;
    }

    public void setPlanDiversionSyncMsgProvider(ProxyMessageProducer planDiversionSyncMsgProvider) {
        this.planDiversionSyncMsgProvider = planDiversionSyncMsgProvider;
    }

    public String getPlanDiversionSyncTopic() {
        return this.planDiversionSyncTopic;
    }

    public void setPlanDiversionSyncTopic(String planDiversionSyncTopic) {
        this.planDiversionSyncTopic = planDiversionSyncTopic;
    }

    public String getPlanDiversionSyncTag() {
        return this.planDiversionSyncTag;
    }

    public void setPlanDiversionSyncTag(String planDiversionSyncTag) {
        this.planDiversionSyncTag = planDiversionSyncTag;
    }

    public ContractInfoChangeMapper getContractInfoChangeMapper() {
        return this.contractInfoChangeMapper;
    }

    public void setContractInfoChangeMapper(ContractInfoChangeMapper contractInfoChangeMapper) {
        this.contractInfoChangeMapper = contractInfoChangeMapper;
    }

    public ContractSignPushLegalBusiService getContractSignPushLegalBusiService() {
        return this.contractSignPushLegalBusiService;
    }

    public void setContractSignPushLegalBusiService(ContractSignPushLegalBusiService contractSignPushLegalBusiService) {
        this.contractSignPushLegalBusiService = contractSignPushLegalBusiService;
    }

    public ContractPushLogMapper getContractPushLogMapper() {
        return this.contractPushLogMapper;
    }

    public void setContractPushLogMapper(ContractPushLogMapper contractPushLogMapper) {
        this.contractPushLogMapper = contractPushLogMapper;
    }

    public String getSignatureEffectPushlegal() {
        return this.signatureEffectPushlegal;
    }

    public void setSignatureEffectPushlegal(String signatureEffectPushlegal) {
        this.signatureEffectPushlegal = signatureEffectPushlegal;
    }

    public CContractSignFileMapper getcContractSignFileMapper() {
        return this.cContractSignFileMapper;
    }

    public void setcContractSignFileMapper(CContractSignFileMapper cContractSignFileMapper) {
        this.cContractSignFileMapper = cContractSignFileMapper;
    }

    public ContractDetailQueryAbilityService getContractDetailQueryAbilityService() {
        return this.contractDetailQueryAbilityService;
    }

    public void setContractDetailQueryAbilityService(ContractDetailQueryAbilityService contractDetailQueryAbilityService) {
        this.contractDetailQueryAbilityService = contractDetailQueryAbilityService;
    }

    public UocExtensionOfflineContractSyncAbilityService getUocExtensionOfflineContractSyncAbilityService() {
        return this.uocExtensionOfflineContractSyncAbilityService;
    }

    public void setUocExtensionOfflineContractSyncAbilityService(UocExtensionOfflineContractSyncAbilityService uocExtensionOfflineContractSyncAbilityService) {
        this.uocExtensionOfflineContractSyncAbilityService = uocExtensionOfflineContractSyncAbilityService;
    }

    private void syncOfflineContract(Long contractId) {
        UocExtensionOfflineContractSyncReqBo reqBo = new UocExtensionOfflineContractSyncReqBo();
        ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO = (ContractDetailQueryAbilityReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBo), ContractDetailQueryAbilityReqBO.class);
        contractDetailQueryAbilityReqBO.setContractId(contractId);
        contractDetailQueryAbilityReqBO.setQueryRangeType(Integer.valueOf(1));
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
        if (ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractDetailQueryAbilityRspBO.getContractStatus())) {
            UocAttachmentBO attachmentBO;
            reqBo.setDealType(Integer.valueOf(2));
            reqBo.setContractStatus(UocConstant.OfflineContractStatus.TOOK_EFFECT);
            reqBo.setExt2(String.valueOf(contractId));
            reqBo.setSignDate(contractDetailQueryAbilityRspBO.getContractSignDate());
            reqBo.setContractNo(contractDetailQueryAbilityRspBO.getContractCode());
            reqBo.setContractName(contractDetailQueryAbilityRspBO.getContractName());
            reqBo.setEffectiveDate(contractDetailQueryAbilityRspBO.getContractEffectiveDate());
            reqBo.setExpirationDate(contractDetailQueryAbilityRspBO.getContractEndDate());
            reqBo.setSupplierId(contractDetailQueryAbilityRspBO.getSupplierId());
            reqBo.setSupplierCode(contractDetailQueryAbilityRspBO.getSupplierCode());
            reqBo.setSupplierName(contractDetailQueryAbilityRspBO.getSupplierName());
            reqBo.setErpSupplierCode(contractDetailQueryAbilityRspBO.getSupplierCode());
            ArrayList<UocExtensionOfflineContractPayBO> payList = new ArrayList<UocExtensionOfflineContractPayBO>();
            if (UocCoreConstant.PayType.PAY_TYPE_PHASE.equals(contractDetailQueryAbilityRspBO.getPayType())) {
                for (Object bo : contractDetailQueryAbilityRspBO.getSettlementDetailBos()) {
                    UocExtensionOfflineContractPayBO payBO = new UocExtensionOfflineContractPayBO();
                    payBO.setPayType(contractDetailQueryAbilityRspBO.getPayType());
                    payBO.setPayMethod(bo.getMoneyType());
                    payBO.setPayNode(Integer.valueOf(bo.getPanelPointCode()));
                    payBO.setPayPercent(bo.getPayPercent());
                    payBO.setPayDays(bo.getDays());
                    payList.add(payBO);
                }
            } else if (UocCoreConstant.PayType.PAY_TYPE_PERIOD.equals(contractDetailQueryAbilityRspBO.getPayType())) {
                UocExtensionOfflineContractPayBO payBO = new UocExtensionOfflineContractPayBO();
                payBO.setPayType(contractDetailQueryAbilityRspBO.getPayType());
                payBO.setPayRule(contractDetailQueryAbilityRspBO.getExpectSettle());
                payBO.setPayNodeRule(contractDetailQueryAbilityRspBO.getPayNodeRuleAllow());
                payBO.setPayDays(Integer.valueOf(contractDetailQueryAbilityRspBO.getSettleDay()));
                payList.add(payBO);
            }
            reqBo.setPayList(payList);
            ArrayList<UocAttachmentBO> fileList = new ArrayList<UocAttachmentBO>();
            if (!CollectionUtils.isEmpty((Collection)contractDetailQueryAbilityRspBO.getAccessoryList())) {
                for (ContractAccessoryBO bo : contractDetailQueryAbilityRspBO.getAccessoryList()) {
                    UocAttachmentBO attachmentBO2 = new UocAttachmentBO();
                    attachmentBO2.setFileName(bo.getAcceessoryName());
                    attachmentBO2.setFileUrl(bo.getAcceessoryUrl());
                    fileList.add(attachmentBO2);
                }
            }
            if (!StringUtils.isEmpty((Object)contractDetailQueryAbilityRspBO.getSupplierBusiLicenseName()) && !StringUtils.isEmpty((Object)contractDetailQueryAbilityRspBO.getSupplierBusiLicenseUrl())) {
                attachmentBO = new UocAttachmentBO();
                attachmentBO.setFileName(contractDetailQueryAbilityRspBO.getSupplierBusiLicenseName());
                attachmentBO.setFileUrl(contractDetailQueryAbilityRspBO.getSupplierBusiLicenseUrl());
                fileList.add(attachmentBO);
            }
            if (!StringUtils.isEmpty((Object)contractDetailQueryAbilityRspBO.getContractDocName()) && !StringUtils.isEmpty((Object)contractDetailQueryAbilityRspBO.getContractDocUrl())) {
                attachmentBO = new UocAttachmentBO();
                attachmentBO.setFileName(contractDetailQueryAbilityRspBO.getContractDocName());
                attachmentBO.setFileUrl(contractDetailQueryAbilityRspBO.getContractDocUrl());
                fileList.add(attachmentBO);
            }
            reqBo.setFileList(fileList);
            this.uocExtensionOfflineContractSyncAbilityService.dealOfflineContractSync(reqBo);
        }
    }

    public ProxyMessageProducer getPlanAddContractQtyMsgProvider() {
        return this.planAddContractQtyMsgProvider;
    }

    public void setPlanAddContractQtyMsgProvider(ProxyMessageProducer planAddContractQtyMsgProvider) {
        this.planAddContractQtyMsgProvider = planAddContractQtyMsgProvider;
    }

    public String getPlanAddContractQtyTopic() {
        return this.planAddContractQtyTopic;
    }

    public void setPlanAddContractQtyTopic(String planAddContractQtyTopic) {
        this.planAddContractQtyTopic = planAddContractQtyTopic;
    }

    public String getPlanAddContractQtyTag() {
        return this.planAddContractQtyTag;
    }

    public void setPlanAddContractQtyTag(String planAddContractQtyTag) {
        this.planAddContractQtyTag = planAddContractQtyTag;
    }
}

