/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.FscToBeSettlementListQryAbilityService;
import com.tydic.contract.ability.bo.FscToBeSettlementListQryAbilityBO;
import com.tydic.contract.ability.bo.FscToBeSettlementListQryAbilityReqBO;
import com.tydic.contract.ability.bo.FscToBeSettlementListQryAbilityRspBO;
import com.tydic.contract.dao.FscOrderFinanceMapper;
import com.tydic.contract.dao.FscOrderMapper;
import com.tydic.contract.po.FscOrderFinancePO;
import com.tydic.contract.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.FscToBeSettlementListQryAbilityService"})
public class FscToBeSettlementListQryAbilityServiceImpl
implements FscToBeSettlementListQryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"qryFscToBeSettlementList"})
    public FscToBeSettlementListQryAbilityRspBO qryFscToBeSettlementList(@RequestBody FscToBeSettlementListQryAbilityReqBO reqBO) {
        FscToBeSettlementListQryAbilityRspBO rspBO = new FscToBeSettlementListQryAbilityRspBO();
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPO.class);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.fscOrderMapper.getJoinListPage(fscOrderPO));
        List fscOrderPOList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            return rspBO;
        }
        List reqBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderPOList), FscToBeSettlementListQryAbilityBO.class);
        List<Long> fscOrderIdList = fscOrderPOList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        List<FscOrderFinancePO> fscOrderFinancePOList = this.fscOrderFinanceMapper.getexchangeRateList(fscOrderIdList);
        Map<Long, BigDecimal> decimalMap = fscOrderFinancePOList.stream().collect(Collectors.toMap(FscOrderFinancePO::getFscOrderId, FscOrderFinancePO::getExchangeRate));
        for (FscToBeSettlementListQryAbilityBO fscOrderBO : reqBOList) {
            fscOrderBO.setTotalChargeBen(fscOrderBO.getTotalCharge().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setPaidAmountBen(fscOrderBO.getPaidAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setToPayAmountBen(fscOrderBO.getToPayAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setPayingAmountBen(fscOrderBO.getPayingAmount().multiply(decimalMap.get(fscOrderBO.getFscOrderId())).setScale(20, 4));
            fscOrderBO.setRemainPayAmount(fscOrderBO.getTotalCharge().subtract(fscOrderBO.getPaidAmount()));
            fscOrderBO.setRemainPayAmountBen(fscOrderBO.getTotalChargeBen().subtract(fscOrderBO.getPaidAmountBen()));
        }
        rspBO.setRows(reqBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }
}

