/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityRspBo;
import com.tydic.contract.atom.ContractQueryErpAgrDetailsAtomService;
import com.tydic.contract.atom.bo.ContractQueryErpAgrDetailsAtomReqBO;
import com.tydic.contract.atom.bo.ContractQueryErpAgrDetailsAtomRspBO;
import com.tydic.contract.atom.bo.ContractQueryErpAgrDetailsContractItemInfoBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQryAbilityRspBO;
import com.tydic.umc.supplier.ability.api.UmcSupplierInfoQryListAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityRspBO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractQueryErpAgrDetailsAtomServiceImpl
implements ContractQueryErpAgrDetailsAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractQueryErpAgrDetailsAtomServiceImpl.class);
    @Value(value="${CONTRACT_QUERY_ERP_AGR_DETAILS_URL}")
    private String contractQueryErpAgrDetailsUrl;
    @Value(value="${ERP_P_GUEST_NAME:Q1VYUE9QT1JUQUw=}")
    private String pGuestName;
    @Value(value="${ERP_P_GUEST_PWD:MjAyMDEyMzQ1Ng==}")
    private String pGuestPwd;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private UmcSupplierInfoQryListAbilityService umcSupplierInfoQryListAbilityService;
    @Autowired
    private UccMaterialInfoQueryAbilityService uccMaterialInfoQueryAbilityService;
    @Autowired
    private UmcMemDetailQryAbilityService umcMemDetailQryAbilityService;
    @Value(value="${QRY_MATERIAL_IS_EXCLUDE_GENERAL:1}")
    private String IsExcludeGeneral;

    @Override
    public ContractQueryErpAgrDetailsAtomRspBO queryErpAgrDetails(ContractQueryErpAgrDetailsAtomReqBO reqBO) {
        this.validateParams(reqBO);
        String rspStr = this.HttpRequest(reqBO);
        return this.analysisRspMessage(rspStr);
    }

    private void validateParams(ContractQueryErpAgrDetailsAtomReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getAgreementCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBusiOrgCode())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5b9e\u4f53\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String HttpRequest(ContractQueryErpAgrDetailsAtomReqBO reqBO) {
        String rspStr = "";
        try {
            JSONObject reqJsonObject = new JSONObject();
            reqJsonObject.put("P_GUEST_W", (Object)this.pGuestName);
            reqJsonObject.put("P_GUEST", (Object)this.pGuestPwd);
            reqJsonObject.put("P_PO_NUM", (Object)reqBO.getAgreementCode());
            reqJsonObject.put("P_ORG_ID", (Object)reqBO.getBusiOrgCode());
            log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2HTTP\u8bf7\u6c42\u8c03\u7528\u5165\u53c2\uff1a{}", (Object)reqJsonObject.toJSONString());
            rspStr = HttpUtil.doPost(this.contractQueryErpAgrDetailsUrl, reqJsonObject.toJSONString(), null);
            log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2HTTP\u8bf7\u6c42\u8c03\u7528\u51fa\u53c2\uff1a{}", (Object)(ObjectUtil.isEmpty((Object)rspStr) ? "{}" : JSONObject.parseObject((String)rspStr).toJSONString()));
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2HTTP\u8bf7\u6c42\u8c03\u7528\u5931\u8d25");
        }
        return rspStr;
    }

    private ContractQueryErpAgrDetailsAtomRspBO analysisRspMessage(String rspMessage) {
        ContractQueryErpAgrDetailsAtomRspBO rspBO = new ContractQueryErpAgrDetailsAtomRspBO();
        if (ObjectUtil.isEmpty((Object)rspMessage)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        JSONObject rspJsonObject = JSONObject.parseObject((String)rspMessage);
        if (ObjectUtil.isEmpty((Object)rspJsonObject.get((Object)"STATUS"))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u8fd4\u56de\u72b6\u6001\u4e3a\u7a7a");
            return rspBO;
        }
        if (!"S".equals(rspJsonObject.get((Object)"STATUS"))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(rspJsonObject.getString("INFO"));
            return rspBO;
        }
        if (ObjectUtil.isEmpty((Object)rspJsonObject.getJSONArray("PODETAIL")) || rspJsonObject.getJSONArray("PODETAIL").size() == 0) {
            rspBO.setRespCode("1020");
            rspBO.setRespDesc("\u67e5\u8be2\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u4e3a\u7a7a");
            return rspBO;
        }
        log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)rspJsonObject.toJSONString());
        this.packingRspParams(rspBO, rspJsonObject);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void packingRspParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONObject rspJsonObject) {
        JSONArray podetailDatas = rspJsonObject.getJSONArray("PODETAIL");
        JSONObject podetailData = podetailDatas.getJSONObject(0);
        this.packingBasicParams(rspBO, podetailData);
        this.packingBuyerParams(rspBO, podetailData);
        this.packingSupplierParams(rspBO, podetailData);
        this.packingPaymentParams(rspBO, podetailData);
        this.packingOtherParams(rspBO, podetailData);
        JSONArray polineDatas = podetailData.getJSONArray("POLINE");
        this.packingContractItemInfoParams(rspBO, polineDatas, podetailData);
        log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBO)));
    }

    private void packingBasicParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONObject podetailData) {
        rspBO.setContractCode(podetailData.getString("PO_NUM"));
        rspBO.setMaterialSource("6");
        rspBO.setContractType(ObjectUtil.isEmpty((Object)podetailData.getString("ATTRIBUTE13")) ? 13 : ("\u662f".equals(podetailData.getString("ATTRIBUTE13")) ? 12 : 13));
    }

    private void packingBuyerParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONObject podetailData) {
        UmcEnterpriseOrgQryDetailAbilityReqBO qryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        qryDetailAbilityReqBO.setErpOrgCode(podetailData.getString("ORG_ID"));
        UmcEnterpriseOrgQryDetailAbilityRspBO qryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(qryDetailAbilityReqBO);
        log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3|\u4e70\u53d7\u4eba\u4fe1\u606f|\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qryDetailAbilityRspBO));
        if (!("0000".equals(qryDetailAbilityRspBO.getRespCode()) && ObjectUtil.isNotEmpty((Object)qryDetailAbilityRspBO) && ObjectUtil.isNotEmpty((Object)qryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO()))) {
            throw new ZTBusinessException("\u4e70\u53d7\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UmcEnterpriseOrgDetailBO umcEnterpriseOrgDetailBO = qryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO();
        rspBO.setBuyerId(Long.valueOf(umcEnterpriseOrgDetailBO.getOrgCode()));
        rspBO.setBuyerNo(umcEnterpriseOrgDetailBO.getOrgCode());
        rspBO.setBuyerName(umcEnterpriseOrgDetailBO.getOrgName());
        rspBO.setBuyerLegalRepresentative(umcEnterpriseOrgDetailBO.getLegalPerson());
        rspBO.setBuyerAuthorizedAgent(umcEnterpriseOrgDetailBO.getEntrustedAgentName());
        rspBO.setBuyerUniAddress(umcEnterpriseOrgDetailBO.getAddress());
        rspBO.setBuyerBankName(umcEnterpriseOrgDetailBO.getBankName());
        rspBO.setBuyerBankSubName(umcEnterpriseOrgDetailBO.getBankBranchName());
        rspBO.setBuyerAccount(umcEnterpriseOrgDetailBO.getBankAccount());
        rspBO.setBuynerErpNo(podetailData.getString("ORG_ID"));
        rspBO.setOrgTaxFlag(StringUtils.isEmpty((Object)umcEnterpriseOrgDetailBO.getTaxInclude()) ? "0" : umcEnterpriseOrgDetailBO.getTaxInclude());
    }

    private void packingSupplierParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONObject podetailData) {
        UmcSupplierInfoQryListAbilityReqBO qryListAbilityReqBO = new UmcSupplierInfoQryListAbilityReqBO();
        qryListAbilityReqBO.setPageNo(Integer.valueOf(1));
        qryListAbilityReqBO.setPageSize(Integer.valueOf(1));
        qryListAbilityReqBO.setErpOrgCode(podetailData.getString("VENDOR_CODE"));
        UmcSupplierInfoQryListAbilityRspBO qryListAbilityRspBO = this.umcSupplierInfoQryListAbilityService.supplierInfoQryList(qryListAbilityReqBO);
        log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3|\u51fa\u5356\u4eba\u4fe1\u606f|\u67e5\u8be2\u4f01\u4e1a\u4f9b\u5e94\u5546\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qryListAbilityRspBO));
        if (!"0000".equals(qryListAbilityRspBO.getRespCode()) || !ObjectUtil.isNotEmpty((Object)qryListAbilityRspBO) || CollectionUtils.isEmpty((Collection)qryListAbilityRspBO.getRows())) {
            throw new ZTBusinessException("\u51fa\u5356\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UmcSupplierInfoBO umcSupplierInfoBO = (UmcSupplierInfoBO)qryListAbilityRspBO.getRows().get(0);
        rspBO.setSupplierId(umcSupplierInfoBO.getSupplierId());
        rspBO.setSupplierCode(umcSupplierInfoBO.getSupplierCode());
        rspBO.setSupplierName(umcSupplierInfoBO.getSupplierName());
        rspBO.setSupplierLegalRepresentative(umcSupplierInfoBO.getLegalPerson());
        rspBO.setSupplierAddressAliasId(podetailData.getString("B2BSITE_ID"));
        rspBO.setSupplierAddressAlias(podetailData.getString("VENDOR_SITE_CODE"));
        rspBO.setSupplierErpOrgCode(umcSupplierInfoBO.getErpOrgCode());
    }

    private void packingPaymentParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONObject podetailData) {
        rspBO.setCurrency(podetailData.getString("CURRENCY_CODE"));
        if (ObjectUtil.isNotEmpty((Object)podetailData.getString("AMOUNT_LIMIT"))) {
            rspBO.setAmountLimit(new BigDecimal(podetailData.getString("AMOUNT_LIMIT")));
        }
        if (ObjectUtil.isNotEmpty((Object)podetailData.getString("BLANKET_TOTAL_AMOUNT"))) {
            rspBO.setDiscussAmount(new BigDecimal(podetailData.getString("BLANKET_TOTAL_AMOUNT")));
        }
        if (ObjectUtil.isNotEmpty((Object)podetailData.getString("MIN_RELEASE_AMOUNT"))) {
            rspBO.setMinAmount(new BigDecimal(podetailData.getString("MIN_RELEASE_AMOUNT")));
        }
    }

    private void packingOtherParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONObject podetailData) {
        if (ObjectUtil.isNotEmpty((Object)podetailData.getString("ATTRIBUTE15")) && ObjectUtil.isNotEmpty((Object)ContractConstant.PurchaseTypeEnum.getValueByName(podetailData.getString("ATTRIBUTE15")))) {
            rspBO.setPurchaseType(ContractConstant.PurchaseTypeEnum.getValueByName(podetailData.getString("ATTRIBUTE15")));
        }
        UmcMemDetailQryAbilityReqBO umcMemDetailQryAbilityReqBO = new UmcMemDetailQryAbilityReqBO();
        umcMemDetailQryAbilityReqBO.setAgentAccount(podetailData.getString("CREATED_USERNAME"));
        UmcMemDetailQryAbilityRspBO umcMemDetailQryAbilityRspBO = this.umcMemDetailQryAbilityService.qryMemDetail(umcMemDetailQryAbilityReqBO);
        log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3|\u5176\u4ed6\u4fe1\u606f|\u67e5\u8be2\u4f1a\u5458\u8be6\u60c5\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcMemDetailQryAbilityRspBO));
        if ("0000".equals(umcMemDetailQryAbilityRspBO.getRespCode()) && ObjectUtil.isNotEmpty((Object)umcMemDetailQryAbilityRspBO)) {
            rspBO.setCreateUserId(umcMemDetailQryAbilityRspBO.getUserId());
            rspBO.setCreateUserCode(umcMemDetailQryAbilityRspBO.getOccupation());
            rspBO.setCreateUserName(umcMemDetailQryAbilityRspBO.getMemName2());
            rspBO.setCreateTime(podetailData.getDate("CREATION_DATE"));
        }
        if (ObjectUtil.isNotEmpty((Object)umcMemDetailQryAbilityRspBO) && ObjectUtil.isNotEmpty((Object)umcMemDetailQryAbilityRspBO.getOrgId())) {
            UmcEnterpriseOrgQryDetailAbilityReqBO orgQryDetailByOrgIdAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailByOrgIdAbilityReqBO.setOrgIdWeb(umcMemDetailQryAbilityRspBO.getOrgId());
            UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailByOrgIdAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailByOrgIdAbilityReqBO);
            log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3|\u5176\u4ed6\u4fe1\u606f|\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orgQryDetailByOrgIdAbilityRspBO));
            if (ObjectUtil.isNotEmpty((Object)orgQryDetailByOrgIdAbilityRspBO) && ObjectUtil.isNotEmpty((Object)orgQryDetailByOrgIdAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
                rspBO.setCreateDeptId(umcMemDetailQryAbilityRspBO.getOrgId());
                rspBO.setCreateDeptCode(orgQryDetailByOrgIdAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode());
                rspBO.setCreateDeptName(umcMemDetailQryAbilityRspBO.getOrgName());
                rspBO.setCreateDeptOrgPath(orgQryDetailByOrgIdAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgTreePath());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)umcMemDetailQryAbilityRspBO) && ObjectUtil.isNotEmpty((Object)umcMemDetailQryAbilityRspBO.getOrgTreePath())) {
            List<String> list = Arrays.asList(umcMemDetailQryAbilityRspBO.getOrgTreePath().split("-"));
            for (String s : list) {
                UmcEnterpriseOrgQryDetailAbilityReqBO orgQryDetailByOrgIdWebAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                orgQryDetailByOrgIdWebAbilityReqBO.setOrgIdWeb(Long.valueOf(Long.parseLong(s)));
                UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailByOrgIdWebAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailByOrgIdWebAbilityReqBO);
                if (!ObjectUtil.isNotEmpty((Object)orgQryDetailByOrgIdWebAbilityRspBO) || !ObjectUtil.isNotEmpty((Object)orgQryDetailByOrgIdWebAbilityRspBO.getUmcEnterpriseOrgDetailBO()) || !"1".equals(orgQryDetailByOrgIdWebAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsPurchase())) continue;
                rspBO.setPurchaserUnitId(orgQryDetailByOrgIdWebAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId());
                rspBO.setPurchaserUnitCode(orgQryDetailByOrgIdWebAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode());
                rspBO.setPurchaserUnitName(orgQryDetailByOrgIdWebAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgName());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)podetailData.getString("START_DATE"))) {
            rspBO.setContractSignDate(podetailData.getDate("START_DATE"));
        }
        if (ObjectUtil.isNotEmpty((Object)podetailData.getString("START_DATE")) && ObjectUtil.isNotEmpty((Object)podetailData.getString("END_DATE"))) {
            LocalDate startLocalDate = LocalDateTime.parse(podetailData.getString("START_DATE"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate();
            LocalDate endLocalDate = LocalDateTime.parse(podetailData.getString("END_DATE"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate().plusDays(1L);
            if (endLocalDate.isAfter(startLocalDate)) {
                long months = ChronoUnit.MONTHS.between(startLocalDate, endLocalDate);
                rspBO.setValidaNum(Math.toIntExact(months));
                rspBO.setValidaType(9);
                rspBO.setContractValidTime(Date.from(endLocalDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                rspBO.setContractEndDate(rspBO.getContractValidTime());
            }
        }
        rspBO.setPoHeaderId(podetailData.getString("PO_HEADER_ID"));
    }

    private void packingContractItemInfoParams(ContractQueryErpAgrDetailsAtomRspBO rspBO, JSONArray polineDatas, JSONObject podetailData) {
        ArrayList<ContractQueryErpAgrDetailsContractItemInfoBO> contractItemInfoBOList = new ArrayList<ContractQueryErpAgrDetailsContractItemInfoBO>();
        ArrayList<ContractQueryErpAgrDetailsContractItemInfoBO> contractItemInfoBOS = new ArrayList<ContractQueryErpAgrDetailsContractItemInfoBO>();
        ArrayList<String> noExistMaterialCodeList = new ArrayList<String>();
        Integer attribute1 = podetailData.getInteger("ATTRIBUTE1");
        if (ObjectUtil.isNotEmpty((Object)polineDatas) && polineDatas.size() > 0) {
            for (int i = 0; i < polineDatas.size(); ++i) {
                ContractQueryErpAgrDetailsContractItemInfoBO contractItemInfoBO = new ContractQueryErpAgrDetailsContractItemInfoBO();
                contractItemInfoBO.setMaterialCode(polineDatas.getJSONObject(i).getString("ITEM_NO"));
                if (ObjectUtil.isNotEmpty((Object)polineDatas.getJSONObject(i).getInteger("ATTRIBUTE5"))) {
                    contractItemInfoBO.setRate(polineDatas.getJSONObject(i).getInteger("ATTRIBUTE5"));
                } else if (attribute1 != null) {
                    contractItemInfoBO.setRate(attribute1);
                } else {
                    contractItemInfoBO.setRate(0);
                }
                contractItemInfoBO.setUnitPriceExcludingTax(new BigDecimal(polineDatas.getJSONObject(i).getString("UNIT_PRICE")));
                BigDecimal bigDecimal = new BigDecimal(100 + contractItemInfoBO.getRate()).divide(BigDecimal.valueOf(100L), 10, 4);
                BigDecimal taxUnitPrice = contractItemInfoBO.getUnitPriceExcludingTax().multiply(bigDecimal).setScale(10, 4);
                contractItemInfoBO.setTaxUnitPrice(taxUnitPrice);
                contractItemInfoBO.setPoLineId(polineDatas.getJSONObject(i).getString("PO_LINE_ID"));
                contractItemInfoBOList.add(contractItemInfoBO);
            }
            List<String> materialCodeList = contractItemInfoBOList.stream().map(ContractQueryErpAgrDetailsContractItemInfoBO::getMaterialCode).collect(Collectors.toList());
            UccMaterialInfoQueryAbilityReqBo uccMaterialInfoQueryAbilityReqBo = new UccMaterialInfoQueryAbilityReqBo();
            uccMaterialInfoQueryAbilityReqBo.setPageNo(1);
            uccMaterialInfoQueryAbilityReqBo.setPageSize(materialCodeList.size());
            uccMaterialInfoQueryAbilityReqBo.setIsExcludeGeneral(Integer.valueOf(this.IsExcludeGeneral));
            uccMaterialInfoQueryAbilityReqBo.setMaterialCodes(materialCodeList);
            UccMaterialInfoQueryAbilityRspBo uccMaterialInfo = this.uccMaterialInfoQueryAbilityService.getUccMaterialInfo(uccMaterialInfoQueryAbilityReqBo);
            log.info("\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3|\u5408\u540c\u660e\u7ec6|\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccMaterialInfo));
            List uccMaterialInfoQueryAbilityBoList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccMaterialInfo.getRows()), UccMaterialInfoQueryAbilityBo.class);
            if (!CollectionUtils.isEmpty((Collection)uccMaterialInfoQueryAbilityBoList)) {
                Map<String, UccMaterialInfoQueryAbilityBo> uccMaterialInfoQueryAbilityBoMap = uccMaterialInfoQueryAbilityBoList.stream().collect(Collectors.toMap(UccMaterialInfoQueryAbilityBo::getMaterialCode, bo -> bo, (k1, k2) -> k1));
                for (ContractQueryErpAgrDetailsContractItemInfoBO contractItemInfoBO : contractItemInfoBOList) {
                    if (ObjectUtil.isNotEmpty((Object)uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()))) {
                        ContractQueryErpAgrDetailsContractItemInfoBO contractItemInfo = new ContractQueryErpAgrDetailsContractItemInfoBO();
                        contractItemInfo.setMaterialCode(contractItemInfoBO.getMaterialCode());
                        contractItemInfo.setRate(contractItemInfoBO.getRate());
                        contractItemInfo.setUnitPriceExcludingTax(contractItemInfoBO.getUnitPriceExcludingTax());
                        contractItemInfo.setTaxUnitPrice(contractItemInfoBO.getTaxUnitPrice());
                        contractItemInfo.setMaterialDesc(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getMaterialDesc());
                        contractItemInfo.setUnitName(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getUnit());
                        contractItemInfo.setMaterialId(Long.valueOf(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getMaterialId()));
                        contractItemInfo.setMaterialName(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getMaterialName());
                        contractItemInfo.setCatalogId(String.valueOf(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getCatalogId()));
                        contractItemInfo.setCatalogCode(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getCatalogCode());
                        contractItemInfo.setCatalogName(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getCatalogName());
                        contractItemInfo.setMaterialModel(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getMaterialModel());
                        contractItemInfo.setMaterialSpec(uccMaterialInfoQueryAbilityBoMap.get(contractItemInfoBO.getMaterialCode()).getMaterialSpec());
                        contractItemInfo.setPoLineId(contractItemInfoBO.getPoLineId());
                        contractItemInfoBOS.add(contractItemInfo);
                        continue;
                    }
                    noExistMaterialCodeList.add(contractItemInfoBO.getMaterialCode());
                }
            } else {
                throw new ZTBusinessException(this.packingContractItemInfoMaterialErrorMessage(materialCodeList));
            }
            if (contractItemInfoBOS.size() != contractItemInfoBOList.size()) {
                throw new ZTBusinessException(this.packingContractItemInfoMaterialErrorMessage(noExistMaterialCodeList));
            }
        } else {
            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        rspBO.setContractItemInfoBOList(contractItemInfoBOS);
    }

    private String packingContractItemInfoMaterialErrorMessage(List<String> noExistMaterialCodeList) {
        StringBuilder errorMessage = new StringBuilder("\u7269\u6599\u7f16\u7801\uff08");
        for (int i = 0; i < noExistMaterialCodeList.size(); ++i) {
            errorMessage.append(noExistMaterialCodeList.get(i));
            if (i == noExistMaterialCodeList.size() - 1) continue;
            errorMessage.append(",");
        }
        errorMessage.append("\uff09\u6613\u8d2d\u4e0d\u5b58\u5728");
        return errorMessage.toString();
    }
}

