/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractWmsStockGroupQryRspBoGroupList;
import com.tydic.contract.atom.ContractWmsStockGroupQryAtomService;
import com.tydic.contract.atom.bo.ContractWmsStockGroupQryAtomReqBo;
import com.tydic.contract.atom.bo.ContractWmsStockGroupQryAtomRspBo;
import com.tydic.contract.utils.HttpUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractWmsStockGroupQryAtomServiceImpl
implements ContractWmsStockGroupQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractWmsStockGroupQryAtomServiceImpl.class);
    @Value(value="${WMS_STOCK_GROUP_URL}")
    private String wmsStockGroupUrl;

    @Override
    public ContractWmsStockGroupQryAtomRspBo qryWmsStockGroupList(ContractWmsStockGroupQryAtomReqBo reqBo) {
        ContractWmsStockGroupQryAtomRspBo rspBO = new ContractWmsStockGroupQryAtomRspBo();
        rspBO.setRespDesc("0000");
        rspBO.setRespCode("\u6210\u529f");
        String reqStr = reqBo.getData();
        try {
            log.info("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u5165\u53c2" + reqStr);
            String rspStr = HttpUtil.doPost(this.wmsStockGroupUrl, reqStr, null);
            log.info("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u51fa\u53c2" + rspStr);
            rspBO.setRspStr(rspStr);
            rspBO = this.resolveRsp(rspStr, rspBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private ContractWmsStockGroupQryAtomRspBo resolveRsp(String rspStr, ContractWmsStockGroupQryAtomRspBo rspBO) {
        JSONObject jsonObject;
        try {
            if (StringUtils.isEmpty((Object)rspStr)) {
                throw new ZTBusinessException("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            }
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        String code = jsonObject.getString("code");
        if (code == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (!"200".equals(code)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u4e3a\u5931\u8d25:" + jsonObject.get((Object)"code") + "," + jsonObject.get((Object)"msg"));
            return rspBO;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        if (jsonArray == null || jsonArray.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u4ed3\u5e93\u7ec4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return rspBO;
        }
        List materialList = JSONObject.parseArray((String)jsonArray.toString(), ContractWmsStockGroupQryRspBoGroupList.class);
        rspBO.setRows(materialList);
        return rspBO;
    }
}

