/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractAuditLogBO;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.busi.ContractCceSyncAuditLogBusiService;
import com.tydic.contract.busi.bo.ContractCceSyncAuditLogBusiReqBO;
import com.tydic.contract.busi.bo.ContractCceSyncAuditLogBusiRspBO;
import com.tydic.contract.dao.CContractLegalSyncAuditLogMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOperateNodeRecordMapper;
import com.tydic.contract.po.CContractLegalSyncAuditLogPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOperateNodeRecordPo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractCceSyncAuditLogBusiServiceImpl
implements ContractCceSyncAuditLogBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractCceSyncAuditLogBusiServiceImpl.class);
    @Autowired
    private CContractLegalSyncAuditLogMapper cContractLegalSyncAuditLogMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractOperateNodeRecordMapper contractOperateNodeRecordMapper;

    @Override
    public ContractCceSyncAuditLogBusiRspBO recordSyncAuditLog(ContractCceSyncAuditLogBusiReqBO reqBO) {
        ContractCceSyncAuditLogBusiRspBO rspBO = new ContractCceSyncAuditLogBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getAuditLogInfo())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        int beginSize = reqBO.getAuditLogInfo().size();
        reqBO.setAuditLogInfo(reqBO.getAuditLogInfo().stream().filter(a -> !StringUtils.isEmpty((Object)a.getContractCode()) && !StringUtils.isEmpty((Object)a.getContractApprovalRemark()) && a.getContractApprovalResult() != null && a.getApprovalRecordId() != null).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(reqBO.getAuditLogInfo())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6392\u9664\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a\u4e4b\u540e\uff0c\u5ba1\u6279\u8bb0\u5f55\u540c\u6b65\u5f85\u5904\u7406\u6570\u636e\u4e3a\u7a7a!");
            return rspBO;
        }
        int endSize = reqBO.getAuditLogInfo().size();
        rspBO.setDealBeginSize(beginSize);
        rspBO.setDealEndSize(endSize);
        rspBO.setRespDesc("\u63a5\u6536\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a" + beginSize + "\u6821\u9a8c\u5b8c\u5fc5\u586b\u4e4b\u540e\u5df2\u5904\u7406\u7684\u6570\u636e\u957f\u5ea6\u4e3a" + endSize);
        List<ContractAuditLogBO> auditLogBOS = reqBO.getAuditLogInfo();
        HashMap<String, ContractAuditLogBO> approvalRecordIdMap = new HashMap<String, ContractAuditLogBO>();
        for (ContractAuditLogBO contractAuditLogBO : reqBO.getAuditLogInfo()) {
            approvalRecordIdMap.put(contractAuditLogBO.getApprovalRecordId(), contractAuditLogBO);
        }
        ArrayList<ContractAuditLogBO> bos = new ArrayList<ContractAuditLogBO>();
        for (ContractAuditLogBO auditLogBO : approvalRecordIdMap.values()) {
            bos.add(auditLogBO);
        }
        auditLogBOS = bos;
        Date date = new Date();
        ArrayList<CContractLegalSyncAuditLogPO> collect = new ArrayList<CContractLegalSyncAuditLogPO>();
        List<String> approvalRecordIds = auditLogBOS.stream().map(ContractAuditLogBO::getApprovalRecordId).collect(Collectors.toList());
        List<CContractLegalSyncAuditLogPO> auditLogPOS = this.cContractLegalSyncAuditLogMapper.selectByApprovalRecordIds(approvalRecordIds);
        List<Object> existApprovalRecordIds = new ArrayList();
        Map<Object, Object> existApprovalRecordIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(auditLogPOS)) {
            existApprovalRecordIds = auditLogPOS.stream().map(CContractLegalSyncAuditLogPO::getApprovalRecordId).collect(Collectors.toList());
            existApprovalRecordIdMap = auditLogPOS.stream().collect(Collectors.groupingBy(CContractLegalSyncAuditLogPO::getApprovalRecordId));
        }
        ArrayList<CContractLegalSyncAuditLogPO> updatePOS = new ArrayList<CContractLegalSyncAuditLogPO>();
        for (ContractAuditLogBO auditLogBO : auditLogBOS) {
            if (existApprovalRecordIds.contains(auditLogBO.getApprovalRecordId())) {
                for (CContractLegalSyncAuditLogPO po : (List)existApprovalRecordIdMap.get(auditLogBO.getApprovalRecordId())) {
                    CContractLegalSyncAuditLogPO updatePO = new CContractLegalSyncAuditLogPO();
                    BeanUtils.copyProperties((Object)po, (Object)updatePO);
                    BeanUtils.copyProperties((Object)auditLogBO, (Object)updatePO);
                    updatePOS.add(updatePO);
                }
                continue;
            }
            CContractLegalSyncAuditLogPO insertPO = new CContractLegalSyncAuditLogPO();
            BeanUtils.copyProperties((Object)auditLogBO, (Object)insertPO);
            insertPO.setLogTime(date);
            insertPO.setDealDesc("\u5ba1\u6279");
            insertPO.setId(Sequence.getInstance().nextId());
            collect.add(insertPO);
        }
        if (collect.size() > 0) {
            int i = this.cContractLegalSyncAuditLogMapper.insertBatch(collect);
            log.info("\u6210\u529f\u65b0\u589e\u4e86" + i + "\u6761\u6570\u636e");
            if (i < 1) {
                throw new ZTBusinessException("\u6cd5\u52a1\u5ba1\u6279\u8bb0\u5f55\u4fe1\u606f\u540c\u6b65\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty(updatePOS)) {
            int count = this.cContractLegalSyncAuditLogMapper.updateBatch(updatePOS);
            log.info("\u6210\u529f\u4fee\u6539\u4e86" + count + "\u6761\u6570\u636e");
        }
        try {
            if (!CollectionUtils.isEmpty(reqBO.getAuditLogInfo())) {
                HashMap<String, Date> contractCodeDealTimeMap = new HashMap<String, Date>();
                Map<Object, Object> pushContractCodeMap = new HashMap();
                for (ContractAuditLogBO contractAuditLogBO : reqBO.getAuditLogInfo()) {
                    if (StringUtils.isEmpty((Object)contractAuditLogBO.getDealTime()) || StringUtils.isEmpty((Object)contractAuditLogBO.getContractCode())) continue;
                    contractCodeDealTimeMap.put(contractAuditLogBO.getContractCode(), contractAuditLogBO.getDealTime());
                }
                Set contractCodes = reqBO.getAuditLogInfo().stream().filter(e -> !StringUtils.isEmpty((Object)e.getContractCode())).map(ContractAuditLogBO::getContractCode).collect(Collectors.toSet());
                List<Object> recordedNodeContractIds = new ArrayList();
                if (!CollectionUtils.isEmpty(contractCodes)) {
                    ArrayList<String> pushContractCodes = new ArrayList<String>();
                    pushContractCodes.addAll(contractCodes);
                    List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.selectByPushContractCodes(pushContractCodes);
                    if (!CollectionUtils.isEmpty(contractInfoPOS)) {
                        pushContractCodeMap = contractInfoPOS.stream().collect(Collectors.groupingBy(ContractInfoPO::getPushLegalContractCode));
                        List<Long> contractIds = contractInfoPOS.stream().map(ContractInfoPO::getContractId).collect(Collectors.toList());
                        List<ContractOperateNodeRecordPo> nodeRecordPos = this.contractOperateNodeRecordMapper.selectByContractIdsAndnodeCode(contractIds, "CONTRACT_APPROVAL");
                        if (!CollectionUtils.isEmpty(nodeRecordPos)) {
                            recordedNodeContractIds = nodeRecordPos.stream().map(ContractOperateNodeRecordPo::getContractId).collect(Collectors.toList());
                        }
                    }
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (String contractCode : contractCodes) {
                    if (!pushContractCodeMap.keySet().contains(contractCode)) continue;
                    Date date1 = (Date)contractCodeDealTimeMap.get(contractCode);
                    List contractInfoPOS = (List)pushContractCodeMap.get(contractCode);
                    for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                        if (recordedNodeContractIds.contains(contractInfoPO.getContractId())) continue;
                        this.recordContractNodeOperLog(contractInfoPO.getContractId(), null, "\u6cd5\u52a1\u5ba1\u6279", "CONTRACT_APPROVAL", "\u5408\u540c\u5ba1\u6279", sdf.format(date1));
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error("\u8bb0\u5f55\u63a8\u9001\u6cd5\u52a1\u5408\u540c\u7684\u5ba1\u6279\u65f6\u95f4\u70b9\u5931\u8d25" + e2.getMessage());
        }
        return rspBO;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName, String nodeCode, String nodeName, String operTime) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode(nodeCode);
        contractRecordContractNodeOperLogAtomReqBO.setNodeName(nodeName);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        contractRecordContractNodeOperLogAtomReqBO.setOperTime("");
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }
}

