/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractConsignSetupReqBo;
import com.tydic.contract.ability.bo.ContractConsignSetupRspBo;
import com.tydic.contract.busi.ContractConsignSetupBusiService;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractConsignSetupBusiServiceImpl
implements ContractConsignSetupBusiService {
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;

    @Override
    public ContractConsignSetupRspBo saveConsignSetup(ContractConsignSetupReqBo reqBo) {
        this.checkReq(reqBo);
        CContractInfoExtPO qryPo = new CContractInfoExtPO();
        qryPo.setRelateIds(reqBo.getContractIds());
        List<CContractInfoExtPO> extPOS = this.cContractInfoExtMapper.getList(qryPo);
        Map<Object, Object> relateIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(extPOS)) {
            relateIdMap = extPOS.stream().collect(Collectors.groupingBy(CContractInfoExtPO::getRelateId));
        }
        ArrayList<CContractInfoExtPO> addInfoExtPOS = new ArrayList<CContractInfoExtPO>();
        ArrayList<Long> updateIds = new ArrayList<Long>();
        for (Long contractId : reqBo.getContractIds()) {
            if (relateIdMap.containsKey(contractId)) {
                updateIds.add(((CContractInfoExtPO)((List)relateIdMap.get(contractId)).get(0)).getId());
                continue;
            }
            CContractInfoExtPO infoExtPO = new CContractInfoExtPO();
            infoExtPO.setId(Sequence.getInstance().nextId());
            infoExtPO.setRelateId(contractId);
            infoExtPO.setCreateTime(new Date());
            infoExtPO.setCreateUserId(reqBo.getUserId());
            infoExtPO.setCreateUserCode(reqBo.getUsername());
            infoExtPO.setCreateUserName(reqBo.getName());
            infoExtPO.setUpdateTime(new Date());
            infoExtPO.setUpdateUserId(reqBo.getUserId());
            infoExtPO.setUpdateUserCode(reqBo.getUsername());
            infoExtPO.setUpdateUserName(reqBo.getName());
            infoExtPO.setReplenishmentAuthority(reqBo.getReplenishmentAuthority());
            infoExtPO.setSupRepLinkman(reqBo.getSupRepLinkman());
            infoExtPO.setSupRepPhone(reqBo.getSupRepPhone());
            infoExtPO.setSupRepBuyer(reqBo.getSupRepBuyer());
            infoExtPO.setSupRepBuyerId(reqBo.getSupRepBuyerId());
            infoExtPO.setSupRepBuyerCode(reqBo.getSupRepBuyerCode());
            addInfoExtPOS.add(infoExtPO);
        }
        if (!CollectionUtils.isEmpty(updateIds)) {
            CContractInfoExtPO setUpdatePo = new CContractInfoExtPO();
            setUpdatePo.setIds(updateIds);
            setUpdatePo.setUpdateTime(new Date());
            setUpdatePo.setUpdateUserId(reqBo.getUserId());
            setUpdatePo.setUpdateUserCode(reqBo.getUsername());
            setUpdatePo.setUpdateUserName(reqBo.getName());
            setUpdatePo.setReplenishmentAuthority(reqBo.getReplenishmentAuthority());
            setUpdatePo.setSupRepLinkman(reqBo.getSupRepLinkman());
            setUpdatePo.setSupRepPhone(reqBo.getSupRepPhone());
            setUpdatePo.setSupRepBuyer(reqBo.getSupRepBuyer());
            setUpdatePo.setSupRepBuyerId(reqBo.getSupRepBuyerId());
            setUpdatePo.setSupRepBuyerCode(reqBo.getSupRepBuyerCode());
            this.cContractInfoExtMapper.updateWmsByIds(setUpdatePo);
        }
        if (!CollectionUtils.isEmpty(addInfoExtPOS)) {
            this.cContractInfoExtMapper.insertBatch(addInfoExtPOS);
        }
        ContractConsignSetupRspBo rspBo = new ContractConsignSetupRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void checkReq(ContractConsignSetupReqBo reqBo) {
        if (reqBo == null) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getContractIds())) {
            throw new RuntimeException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getReplenishmentAuthority() == null) {
            throw new RuntimeException("\u662f\u5426\u5f00\u53d1\u4f9b\u5e94\u5546\u8865\u8d27\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getReplenishmentAuthority() != 1 && reqBo.getReplenishmentAuthority() != 0) {
            throw new RuntimeException("\u662f\u5426\u5f00\u53d1\u4f9b\u5e94\u5546\u8865\u8d27\u6743\u9650\u679a\u4e3e\u503c\u9519\u8bef");
        }
        if (reqBo.getReplenishmentAuthority() == 1) {
            if (StringUtils.isEmpty((Object)reqBo.getSupRepLinkman())) {
                throw new RuntimeException("\u4f9b\u5e94\u5546\u8865\u8d27\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBo.getSupRepPhone())) {
                throw new RuntimeException("\u4f9b\u5e94\u5546\u8865\u8d27\u8054\u7cfb\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBo.getSupRepBuyer())) {
                throw new RuntimeException("\u9ed8\u8ba4\u91c7\u8d2d\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getSupRepBuyerId() == null) {
                throw new RuntimeException("\u9ed8\u8ba4\u91c7\u8d2d\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBo.getSupRepBuyerCode())) {
                throw new RuntimeException("\u9ed8\u8ba4\u91c7\u8d2d\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

