/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractDicDictionaryQryReqBO;
import com.tydic.contract.ability.bo.ContractDicDictionaryReqBO;
import com.tydic.contract.ability.bo.ContractDicRspListPageBO;
import com.tydic.contract.ability.bo.DicDictionaryBO;
import com.tydic.contract.busi.ContractDictionaryBusiService;
import com.tydic.contract.dao.SysDicDictionaryMapper;
import com.tydic.contract.po.SysDicDictionaryPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractDictionaryBusiServiceImpl
implements ContractDictionaryBusiService {
    private static final Integer DIC_ORDER_ID = 1;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @Override
    public List<DicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode, String title) {
        SysDicDictionaryPO dicDictionary = new SysDicDictionaryPO();
        dicDictionary.setSysCode(sysCode);
        dicDictionary.setPCode(pCode);
        dicDictionary.setTitle(title);
        if (StringUtils.isEmpty((Object)dicDictionary.getOrderBy())) {
            dicDictionary.setOrderBy("ORDER_ID");
        }
        dicDictionary.setDelFlag(1);
        ArrayList<DicDictionaryBO> dicDictionaryBOS = new ArrayList<DicDictionaryBO>();
        List<SysDicDictionaryPO> dicDictionaryPOS = this.sysDicDictionaryMapper.getList(dicDictionary);
        if (dicDictionaryPOS != null) {
            for (SysDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    @Override
    public int updateDicDictionary(ContractDicDictionaryReqBO dicDictionaryBO) {
        SysDicDictionaryPO dicDictionaryModel = new SysDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.sysDicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    @Override
    public int addDicDictionary(ContractDicDictionaryReqBO dicDictionaryBO) {
        SysDicDictionaryPO dicDictionaryModel = new SysDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(DIC_ORDER_ID);
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.sysDicDictionaryMapper.insert(dicDictionaryModel);
    }

    @Override
    public int checkDicBy(String code, String pCode) {
        SysDicDictionaryPO dicDictionaryModel = new SysDicDictionaryPO();
        dicDictionaryModel.setPCode(pCode);
        dicDictionaryModel.setCode(code);
        return this.sysDicDictionaryMapper.getCheckBy(dicDictionaryModel);
    }

    @Override
    public int deleteDicDictionary(ContractDicDictionaryReqBO dicDictionaryBO) {
        SysDicDictionaryPO dicDictionaryModel = new SysDicDictionaryPO();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.sysDicDictionaryMapper.deleteBy(dicDictionaryModel);
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String pCode) {
        List<SysDicDictionaryPO> listPo = this.sysDicDictionaryMapper.selectByPCode(pCode);
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysDicDictionaryPO po : listPo) {
            map.put(po.getCode(), po.getDescrip());
        }
        return map;
    }

    @Override
    public ContractDicRspListPageBO queryListBypCode(ContractDicDictionaryQryReqBO reqBO) {
        ContractDicRspListPageBO rspBO = new ContractDicRspListPageBO();
        SysDicDictionaryPO dicDictionary = new SysDicDictionaryPO();
        dicDictionary.setSysCode(reqBO.getSysCode());
        dicDictionary.setPCode(reqBO.getPCode());
        dicDictionary.setTitle(reqBO.getTitle());
        dicDictionary.setDescrip(reqBO.getDescrip());
        if (StringUtils.isEmpty((Object)dicDictionary.getOrderBy())) {
            dicDictionary.setOrderBy("ORDER_ID");
        }
        dicDictionary.setDelFlag(1);
        ArrayList<DicDictionaryBO> dicDictionaryBOS = new ArrayList<DicDictionaryBO>();
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.sysDicDictionaryMapper.getList(dicDictionary));
        List result = page.getResult();
        if (result != null) {
            for (SysDicDictionaryPO dicDictionaryPO : result) {
                DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        rspBO.setRows(dicDictionaryBOS);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        return rspBO;
    }
}

