/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractPlanMatchingAgreementItemBO;
import com.tydic.contract.busi.ContractFrameworkAgreementItemQryListBusiService;
import com.tydic.contract.busi.bo.ContractFrameworkAgreementItemQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractFrameworkAgreementItemQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractItemCanBuyListQryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractFrameworkAgreementItemQryListBusiServiceImpl
implements ContractFrameworkAgreementItemQryListBusiService {
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;

    @Override
    public ContractFrameworkAgreementItemQryListBusiRspBO qryFrameworkAgreementItemList(ContractFrameworkAgreementItemQryListBusiReqBO reqBO) {
        ContractFrameworkAgreementItemQryListBusiRspBO rspBO = new ContractFrameworkAgreementItemQryListBusiRspBO();
        ContractItemCanBuyListQryPO qryPO = new ContractItemCanBuyListQryPO();
        qryPO.setContractId(reqBO.getContractId());
        qryPO.setItemIds(reqBO.getItemIds());
        qryPO.setMaterialCode(reqBO.getMaterialCode());
        qryPO.setMaterialDesc(reqBO.getMaterialDesc());
        if (null != reqBO.getContractId()) {
            qryPO.setIsNumFlag(1);
        }
        ArrayList<Integer> contractTypes = new ArrayList<Integer>();
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        qryPO.setContractTypes(contractTypes);
        if (reqBO.getIsPlanQry() != null && reqBO.getIsPlanQry() == 1) {
            qryPO.setIsNumFlag(null);
            qryPO.setContractTypes(null);
        }
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.qryItemByList(qryPO));
        List result = page.getResult();
        ArrayList<ContractPlanMatchingAgreementItemBO> itemBOS = new ArrayList<ContractPlanMatchingAgreementItemBO>();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (ContractInfoItemPO infoItemPO : result) {
                ContractPlanMatchingAgreementItemBO bo = (ContractPlanMatchingAgreementItemBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)infoItemPO), ContractPlanMatchingAgreementItemBO.class);
                if (infoItemPO.getAmountLimit() != null) {
                    bo.setAmountLimit(MoneyUtils.haoToYuan(infoItemPO.getAmountLimit()));
                }
                if (infoItemPO.getOrderAmount() != null) {
                    bo.setOrderAmount(MoneyUtils.haoToYuan(infoItemPO.getOrderAmount()));
                }
                if (infoItemPO.getOrderAmount() != null) {
                    bo.setOrderAmount(MoneyUtils.haoToYuan(infoItemPO.getOrderAmount()));
                }
                if (infoItemPO.getOrderDeliveryDate() != null) {
                    bo.setOrderDeliveryDateStr(String.valueOf(infoItemPO.getOrderDeliveryDate().intValue()));
                }
                itemBOS.add(bo);
            }
        }
        for (ContractPlanMatchingAgreementItemBO itemBO : itemBOS) {
            if (itemBO.getContractStatus() != null) {
                itemBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(itemBO.getContractStatus()));
            }
            if (itemBO.getFactoryPrice() != null) {
                itemBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(itemBO.getFactoryPrice()));
            }
            if (itemBO.getPriceCategories() != null) {
                itemBO.setPriceCategoriesStr(ContractTransFieldUtil.transPriceCategories(itemBO.getPriceCategories()));
            }
            if (itemBO.getAmount() == null) {
                itemBO.setAmount(BigDecimal.ZERO);
            }
            if (itemBO.getOrderNum() == null) {
                itemBO.setOrderNum(BigDecimal.ZERO);
            }
            if (itemBO.getMaterialCategory() == null) continue;
            itemBO.setMaterialCategoryStr(ContractTransFieldUtil.transMaterialCategory2(itemBO.getMaterialCategory()));
        }
        if (!CollectionUtils.isEmpty(itemBOS)) {
            this.setIsPushWms(itemBOS);
        }
        rspBO.setRows(itemBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setPageNo(page.getPageNum());
        rspBO.setTotal(page.getPages());
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }

    private void setIsPushWms(List<ContractPlanMatchingAgreementItemBO> rows) {
        List<Long> contractIds = rows.stream().filter(e -> e.getContractId() != null && ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType())).map(ContractPlanMatchingAgreementItemBO::getContractId).collect(Collectors.toList());
        Map<Object, Object> contractIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(contractIds)) {
            CContractInfoExtPO searchPO = new CContractInfoExtPO();
            searchPO.setRelateIds(contractIds);
            List<CContractInfoExtPO> list = this.cContractInfoExtMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty(list)) {
                contractIdMap = list.stream().collect(Collectors.groupingBy(CContractInfoExtPO::getRelateId));
            }
        }
        for (ContractPlanMatchingAgreementItemBO row : rows) {
            if (!contractIdMap.containsKey(row.getContractId())) continue;
            row.setIsPushWms(((CContractInfoExtPO)((List)contractIdMap.get(row.getContractId())).get(0)).getIsPushWms());
        }
    }
}

