/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcExpressRelationBatchInsertAbilityService;
import com.tydic.cfc.ability.bo.CfcExpressRelationBatchInsertAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcExpressRelationBatchInsertAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcExpressRelationBatchInsertBO;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.contract.ability.bo.CContractOrderInfoBO;
import com.tydic.contract.ability.bo.ContractHtAddAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtAddAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHtAddHtPayAbilityBO;
import com.tydic.contract.ability.bo.ContractHtAddInfoAbilityBO;
import com.tydic.contract.ability.bo.ContractHtAddInfoItemAbilityBO;
import com.tydic.contract.ability.bo.ContractHtAddOrderInfoAbilityBO;
import com.tydic.contract.ability.bo.ContractHtSettlementDetailAbilityBO;
import com.tydic.contract.busi.ContractHtAddBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractHtSettlementDetailMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractHtSettlementDetailPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSettlementDetailPO;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.ppc.ability.api.PlanQueryByPlanIdsAbilityService;
import com.tydic.ppc.ability.bo.CcePlanDiversionBO;
import com.tydic.ppc.ability.bo.PlanQueryByPlanIdsAbilityReqBO;
import com.tydic.ppc.ability.bo.PlanQueryByPlanIdsAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailHTQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgInfo;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailHTQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailHTQryAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailHTUserInfoBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractHtAddBusiServiceImpl
implements ContractHtAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractHtAddBusiServiceImpl.class);
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private CfcExpressRelationBatchInsertAbilityService cfcExpressRelationBatchInsertAbilityService;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Autowired
    private ContractSettlementDetailMapper contractSettlementDetailMapper;
    @Autowired
    private UmcMemDetailHTQryAbilityService umcMemDetailHTQryAbilityService;
    @Autowired
    UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;
    @Autowired
    PlanQueryByPlanIdsAbilityService planQueryByPlanIdsAbilityService;
    @Autowired
    private UccThematerialsearchAbilityService uccThematerialsearchAbilityService;
    private final Integer simpleSchemeType = 2;
    @Autowired
    private ContractHtSettlementDetailMapper contractHtSettlementDetailMapper;

    @Override
    public ContractHtAddAbilityRspBO addHtContract(ContractHtAddAbilityReqBO reqBO) {
        List detailPOS;
        Set orderIdSet;
        ContractHtAddAbilityRspBO rspBO = new ContractHtAddAbilityRspBO();
        this.checkReqBO(reqBO);
        ContractInfoPO searchInfoPO = new ContractInfoPO();
        searchInfoPO.setOutContractId(reqBO.getInfoBO().getOutContractId());
        List<ContractInfoPO> infoPOS = this.contractInfoMapper.getList(searchInfoPO);
        if (!CollectionUtils.isEmpty(infoPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u5df2\u5b58\u5728");
            return rspBO;
        }
        this.buildSettlementDetailBOS(reqBO);
        ContractInfoPO addInfoPO = (ContractInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO.getInfoBO()), ContractInfoPO.class);
        Long contractId = this.uccBatchSequence.nextId();
        addInfoPO.setContractId(contractId);
        ContractHtAddInfoAbilityBO infoBO = reqBO.getInfoBO();
        addInfoPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        if (infoBO.getContractAmount() != null) {
            addInfoPO.setContractAmount(MoneyUtils.yuanToHaoToLong(infoBO.getContractAmount()));
        }
        if (infoBO.getAmountLimit() != null) {
            addInfoPO.setAmountLimit(MoneyUtils.yuanToHaoToLong(infoBO.getAmountLimit()));
        }
        if (infoBO.getContractAmountExcludingTax() != null) {
            addInfoPO.setContractAmountExcludingTax(MoneyUtils.yuanToHaoToLong(infoBO.getContractAmountExcludingTax()));
        }
        if (infoBO.getContractAmount() != null && infoBO.getContractAmountExcludingTax() != null) {
            BigDecimal contractTax = infoBO.getContractAmount().subtract(infoBO.getContractAmountExcludingTax());
            addInfoPO.setContractTax(MoneyUtils.yuanToHaoToLong(contractTax));
        }
        CContractInfoExtPO infoExtPO = new CContractInfoExtPO();
        if (reqBO.getExtBO() != null) {
            infoExtPO = (CContractInfoExtPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO.getExtBO()), CContractInfoExtPO.class);
        }
        addInfoPO.setContractValidTime(infoBO.getContractEndDate());
        addInfoPO.setEffectiveDate(infoBO.getContractEffectiveDate());
        this.buildContract(infoBO, addInfoPO, infoExtPO);
        addInfoPO.setUpdateTime(addInfoPO.getCreateTime());
        this.contractInfoMapper.insertSelective(addInfoPO);
        infoExtPO.setId(this.uccBatchSequence.nextId());
        infoExtPO.setRelateId(contractId);
        infoExtPO.setActualBusinessEntityCode(infoBO.getActualBusinessEntityCode());
        infoExtPO.setActualBusinessEntityName(infoBO.getActualBusinessEntityName());
        infoExtPO.setActualBusinessEntityErpCode(infoBO.getActualBusinessEntityErpCode());
        this.cContractInfoExtMapper.insert(infoExtPO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            String jsonString = JSON.toJSONString((Object)reqBO.getAccessoryList());
            List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
            for (ContractAccessoryPo contractAccessoryPo : list) {
                contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
                contractAccessoryPo.setRelateId(contractId);
                contractAccessoryPo.setRelateCode(infoBO.getContractCode());
                contractAccessoryPo.setCreateUserId(addInfoPO.getCreateUserId());
                contractAccessoryPo.setCreateUserName(addInfoPO.getCreateUserName());
                contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            }
            int result = this.contractAccessoryMapper.insertBatch(list);
            if (result < 1) {
                throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExpressBOS())) {
            CfcExpressRelationBatchInsertAbilityReqBO abilityReqBO = new CfcExpressRelationBatchInsertAbilityReqBO();
            abilityReqBO.setObjId(contractId);
            abilityReqBO.setObjNo(infoBO.getContractCode());
            abilityReqBO.setSuitType(Integer.valueOf(1));
            List expressRelationList = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getExpressBOS()), CfcExpressRelationBatchInsertBO.class);
            abilityReqBO.setExpressRelationList(expressRelationList);
            try {
                CfcExpressRelationBatchInsertAbilityRspBO abilityRspBO = this.cfcExpressRelationBatchInsertAbilityService.expressRelationBatchInsert(abilityReqBO);
                if (!"0000".equals(abilityRspBO.getRespCode())) {
                    throw new ZTBusinessException(abilityRspBO.getRespDesc());
                }
            }
            catch (Exception e2) {
                throw new ZTBusinessException("\u8bb0\u5f55\u8c03\u4ef7\u516c\u5f0f\u5931\u8d25" + e2.getMessage());
            }
        }
        ArrayList<CContractOrderInfoBO> cContractOrderInfoList = new ArrayList<CContractOrderInfoBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderInfoBOS()) && !CollectionUtils.isEmpty(orderIdSet = reqBO.getOrderInfoBOS().stream().filter(e -> e.getOrderId() != null).map(ContractHtAddOrderInfoAbilityBO::getOrderId).collect(Collectors.toSet()))) {
            CContractOrderInfoPO searchPO = new CContractOrderInfoPO();
            searchPO.setOrderIds(new ArrayList<Long>(orderIdSet));
            List<CContractOrderInfoPO> orderInfoPOS = this.cContractOrderInfoMapper.getList(searchPO);
            List<Object> orderList = new ArrayList();
            if (!CollectionUtils.isEmpty(orderInfoPOS)) {
                orderList = orderInfoPOS.stream().map(CContractOrderInfoPO::getOrderId).collect(Collectors.toList());
            }
            for (ContractHtAddOrderInfoAbilityBO orderInfoBO : reqBO.getOrderInfoBOS()) {
                if (orderInfoBO.getOrderId() == null || orderList.contains(orderInfoBO.getOrderId())) continue;
                CContractOrderInfoBO contractOrderInfoBO = (CContractOrderInfoBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoBO), CContractOrderInfoBO.class);
                cContractOrderInfoList.add(contractOrderInfoBO);
            }
        }
        if (!CollectionUtils.isEmpty(cContractOrderInfoList)) {
            this.cContractOrderInfoMapper.insertOrderList(cContractOrderInfoList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSettlementDetailBOS())) {
            detailPOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getSettlementDetailBOS()), ContractSettlementDetailPO.class);
            for (Serializable detailPO : detailPOS) {
                ((ContractSettlementDetailPO)detailPO).setId(Sequence.getInstance().nextId());
                ((ContractSettlementDetailPO)detailPO).setRelateId(contractId);
            }
            this.contractSettlementDetailMapper.insertBatch(detailPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getHtPayDetailBOS())) {
            detailPOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getHtPayDetailBOS()), ContractHtSettlementDetailPO.class);
            for (Serializable detailPO : detailPOS) {
                ((ContractHtSettlementDetailPO)detailPO).setId(Sequence.getInstance().nextId());
                ((ContractHtSettlementDetailPO)detailPO).setRelateId(contractId);
                ((ContractHtSettlementDetailPO)detailPO).setOutRelateId(reqBO.getInfoBO().getOutContractId());
            }
            this.contractHtSettlementDetailMapper.insertBatch(detailPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getItemBOS())) {
            ArrayList<ContractInfoItemPO> contractInfoItemPOList = new ArrayList<ContractInfoItemPO>();
            for (ContractHtAddInfoItemAbilityBO itemBO : reqBO.getItemBOS()) {
                ContractInfoItemPO infoItemPO = (ContractInfoItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemBO), ContractInfoItemPO.class);
                infoItemPO.setItemId(Sequence.getInstance().nextId());
                infoItemPO.setRelateId(contractId);
                infoItemPO.setContractCode(infoBO.getContractCode());
                if (infoItemPO.getRate() != null && infoItemPO.getTaxUnitPrice() != null) {
                    BigDecimal tax = new BigDecimal(String.valueOf(1.0f + (float)infoItemPO.getRate().intValue() / 100.0f));
                    infoItemPO.setUnitPriceExcludingTax(infoItemPO.getTaxUnitPrice().divide(tax, 8, 4).multiply(new BigDecimal("1")).setScale(8, 4));
                    if (infoItemPO.getAmount() != null) {
                        infoItemPO.setTaxAmount(infoItemPO.getTaxUnitPrice().multiply(infoItemPO.getAmount()).setScale(2, 4));
                        infoItemPO.setNotIncludingTaxAmount(infoItemPO.getUnitPriceExcludingTax().multiply(infoItemPO.getAmount()).setScale(2, 4));
                        infoItemPO.setTax(infoItemPO.getTaxAmount().subtract(infoItemPO.getNotIncludingTaxAmount()).setScale(2, 4));
                        infoItemPO.setMaterialName(itemBO.getMaterialLongName());
                        infoItemPO.setMaterialDesc(itemBO.getMaterialLongName());
                    }
                }
                infoItemPO.setBidderAmount(infoItemPO.getTaxUnitPrice());
                contractInfoItemPOList.add(infoItemPO);
            }
            this.contractInfoItemMapper.insertBatch(contractInfoItemPOList);
        }
        rspBO.setContractId(contractId);
        rspBO.setIsFz(infoBO.getIsFz());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildSettlementDetailBOS(ContractHtAddAbilityReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getHtPayDetailBOS())) {
            reqBO.getInfoBO().setPayType(ContractConstant.PayType.PHASED_PAYMENT_CODE);
            ArrayList<ContractHtSettlementDetailAbilityBO> settlementDetailBOS = new ArrayList<ContractHtSettlementDetailAbilityBO>();
            for (ContractHtAddHtPayAbilityBO htPayDetailBO : reqBO.getHtPayDetailBOS()) {
                if (StringUtils.isEmpty((Object)htPayDetailBO.getPanelPointCode())) {
                    reqBO.getInfoBO().setPayType(ContractConstant.PayType.NO_HAVE_PAY);
                    reqBO.getInfoBO().setPayRemark(htPayDetailBO.getPanelPointName());
                    settlementDetailBOS = new ArrayList();
                    break;
                }
                ContractHtSettlementDetailAbilityBO settlementDetailBO = new ContractHtSettlementDetailAbilityBO();
                settlementDetailBO.setDays(htPayDetailBO.getDays());
                settlementDetailBO.setPayPercent(htPayDetailBO.getPayPercent());
                settlementDetailBO.setExtField1("1");
                if ("1".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("1");
                    settlementDetailBO.setPanelPointName("\u4e0b\u5355\u9884\u4ed8");
                }
                if ("2".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("1");
                    settlementDetailBO.setPanelPointName("\u4e0b\u5355\u9884\u4ed8");
                }
                if ("3".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("1");
                    settlementDetailBO.setPanelPointName("\u4e0b\u5355\u9884\u4ed8");
                }
                if ("4".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("2");
                    settlementDetailBO.setPanelPointName("\u5230\u8d27\u9884\u4ed8");
                }
                if ("5".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.ACCOUNT_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("4");
                    settlementDetailBO.setPanelPointName("\u8ba2\u5355\u6536\u7968");
                }
                if ("6".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.GUARANTEE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("4");
                    settlementDetailBO.setPanelPointName("\u8ba2\u5355\u6536\u7968");
                }
                if ("7".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.GUARANTEE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("4");
                    settlementDetailBO.setPanelPointName("\u8ba2\u5355\u6536\u7968");
                }
                settlementDetailBOS.add(settlementDetailBO);
            }
            reqBO.setSettlementDetailBOS(settlementDetailBOS);
        } else {
            ArrayList settlementDetailBOS = new ArrayList();
            reqBO.getInfoBO().setPayType(ContractConstant.PayType.NO_HAVE_PAY);
            settlementDetailBOS = new ArrayList();
            reqBO.setSettlementDetailBOS(settlementDetailBOS);
        }
    }

    private void buildContract(ContractHtAddInfoAbilityBO infoBO, ContractInfoPO addInfoPO, CContractInfoExtPO infoExtPO) {
        block14: {
            UmcMemDetailHTQryAbilityReqBO htQryAbilityReqBO = new UmcMemDetailHTQryAbilityReqBO();
            htQryAbilityReqBO.setUserNameWeb(infoBO.getCreateUserCode());
            htQryAbilityReqBO.setIsQryPurchase(Integer.valueOf(1));
            htQryAbilityReqBO.setErpOrgCodeWeb(infoBO.getBuynerErpNo());
            htQryAbilityReqBO.setSupplierErpOrgCodeWeb(infoBO.getSupplierCode());
            htQryAbilityReqBO.setMultiSupplierErpOrgCodeWeb(infoBO.getMultiDealerCode());
            htQryAbilityReqBO.setContractType(infoBO.getContractType());
            try {
                UmcMemDetailHTQryAbilityRspBO htQryAbilityRspBO = this.umcMemDetailHTQryAbilityService.qryHtDetail(htQryAbilityReqBO);
                if ("0000".equals(htQryAbilityRspBO.getRespCode())) {
                    addInfoPO.setPurchaserUnitId(htQryAbilityRspBO.getPurchaseOrgId());
                    addInfoPO.setPurchaserUnitCode(htQryAbilityRspBO.getPurchaseOrgCode());
                    addInfoPO.setPurchaserUnitName(htQryAbilityRspBO.getPurchaseOrgName());
                    if (htQryAbilityRspBO.getHtUserInfo() == null || htQryAbilityRspBO.getHtUserInfo().getUserId() == null) {
                        throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                    }
                    UmcMemDetailHTUserInfoBO htUserInfo = htQryAbilityRspBO.getHtUserInfo();
                    addInfoPO.setCreateUserId(htUserInfo.getUserId());
                    addInfoPO.setCreateUserCode(htUserInfo.getOccupation());
                    addInfoPO.setCreateUserName(htUserInfo.getMemName2());
                    addInfoPO.setCreateDeptId(htUserInfo.getOrgId());
                    addInfoPO.setCreateDeptCode(htUserInfo.getOrgCode());
                    addInfoPO.setCreateDeptName(htUserInfo.getOrgName());
                    addInfoPO.setCreateDeptOrgPath(htUserInfo.getOrgTreePath());
                    if (ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(infoBO.getContractType())) {
                        addInfoPO.setPushErpFlag(htUserInfo.getContractPushErpFlag());
                    }
                    if (htQryAbilityRspBO.getBuyerOrg() == null || htQryAbilityRspBO.getBuyerOrg().getOrgId() == null) {
                        throw new ZTBusinessException("\u67e5\u8be2\u4e70\u53d7\u4eba\u4fe1\u606f\u5931\u8d25");
                    }
                    UmcEnterpriseOrgInfo buyerOrg = htQryAbilityRspBO.getBuyerOrg();
                    try {
                        addInfoPO.setBuyerId(Long.valueOf(buyerOrg.getOrgCode()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    addInfoPO.setBuyerNo(buyerOrg.getOrgCode());
                    addInfoPO.setBuyerName(buyerOrg.getBuyerOrgName());
                    addInfoPO.setBuyerLegalRepresentative(buyerOrg.getLegalPerson());
                    addInfoPO.setBuyerAuthorizedAgent(buyerOrg.getEntrustedAgentName());
                    addInfoPO.setBuyerUniAddress(buyerOrg.getAddress());
                    addInfoPO.setBuyerBankName(buyerOrg.getBankName());
                    addInfoPO.setBuyerBankSubName(buyerOrg.getBankBranchName());
                    addInfoPO.setBuyerAccount(buyerOrg.getBankAccount());
                    addInfoPO.setBuynerErpNo(infoBO.getBuynerErpNo());
                    addInfoPO.setOrgTaxFlag(StringUtils.isEmpty((Object)buyerOrg.getTaxInclude()) ? "0" : buyerOrg.getTaxInclude());
                    addInfoPO.setConBuyerName(buyerOrg.getConBuyerOrgName());
                    addInfoPO.setAcceptOrgId(buyerOrg.getAcceptOrgId());
                    addInfoPO.setAcceptOrgName(buyerOrg.getAcceptOrgName());
                    addInfoPO.setConsigneeOrgId(buyerOrg.getRecvOrgId());
                    addInfoPO.setConsigneeOrgName(buyerOrg.getRecvOrgName());
                    if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(infoBO.getContractType())) {
                        infoExtPO.setIsPushWms(buyerOrg.getIsPushWms());
                    }
                    if (CollectionUtils.isEmpty((Collection)htQryAbilityRspBO.getSupplierInfoList())) {
                        throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u6570\u636e\u5931\u8d25");
                    }
                    Map<String, List<UmcSupplierInfoBO>> erpCodeMap = htQryAbilityRspBO.getSupplierInfoList().stream().collect(Collectors.groupingBy(UmcSupplierInfoBO::getErpOrgCode));
                    if (!erpCodeMap.containsKey(infoBO.getSupplierCode())) {
                        throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
                    }
                    UmcSupplierInfoBO umcSupplierInfoBO = erpCodeMap.get(infoBO.getSupplierCode()).get(0);
                    addInfoPO.setSupplierId(umcSupplierInfoBO.getSupplierId());
                    addInfoPO.setSupplierCode(umcSupplierInfoBO.getSupplierCode());
                    addInfoPO.setSupplierName(umcSupplierInfoBO.getSupplierName());
                    addInfoPO.setVendorStatus(1);
                    if ("01".equals(umcSupplierInfoBO.getDelStatus())) {
                        addInfoPO.setVendorStatus(0);
                    }
                    if (!StringUtils.isEmpty((Object)infoBO.getMultiDealerCode())) {
                        if (!erpCodeMap.containsKey(infoBO.getMultiDealerCode())) {
                            throw new ZTBusinessException("\u67e5\u8be2\u4e19\u65b9\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
                        }
                        umcSupplierInfoBO = erpCodeMap.get(infoBO.getMultiDealerCode()).get(0);
                        addInfoPO.setMultiDealerId(umcSupplierInfoBO.getSupplierId());
                        addInfoPO.setMultiDealerCode(umcSupplierInfoBO.getSupplierCode());
                        addInfoPO.setMultiDealerName(umcSupplierInfoBO.getSupplierName());
                    }
                    break block14;
                }
                throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u548c\u673a\u6784\u4fe1\u606f\u5931\u8d25" + htQryAbilityRspBO.getRespDesc());
            }
            catch (Exception e) {
                log.error(e.toString());
                throw new ZTBusinessException(e.getMessage());
            }
        }
    }

    private void buildInfoItem(List<ContractInfoItemPO> contractInfoItemPOList) {
        this.getCatelogInfo(contractInfoItemPOList);
        this.getBuyerAndUserCompanyName(contractInfoItemPOList);
    }

    private void getBuyerAndUserCompanyName(List<ContractInfoItemPO> contractInfoItemTmpPOS) {
        Set planItemIds;
        Set decCompanyCodes = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getErpOrgCode())).map(ContractInfoItemPO::getErpOrgCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(decCompanyCodes)) {
            UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
            ArrayList organizationCodes = new ArrayList();
            organizationCodes.addAll(decCompanyCodes);
            umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(organizationCodes);
            UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
            if ("0000".equals(umcContractQueryBuyerInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
                Map<String, List<UmcEntityOrgSubBO>> oIdMap = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcEntityOrgSubBO::getOrganizationId));
                contractInfoItemTmpPOS.forEach(e -> {
                    if (!CollectionUtils.isEmpty((Collection)((Collection)oIdMap.get(e.getErpOrgCode())))) {
                        UmcEntityOrgSubBO umcEntityOrgSubBO = (UmcEntityOrgSubBO)((List)oIdMap.get(e.getErpOrgCode())).get(0);
                        e.setBuyerId(umcEntityOrgSubBO.getEntityId());
                        if (umcEntityOrgSubBO.getEntityId() != null) {
                            e.setBuyerNo(umcEntityOrgSubBO.getEntityId().toString());
                        }
                        e.setBuyerName(umcEntityOrgSubBO.getEntityName());
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty(planItemIds = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getPlanItemId())).map(ContractInfoItemPO::getPlanItemId).collect(Collectors.toSet()))) {
            List planIds = planItemIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            PlanQueryByPlanIdsAbilityReqBO planQueryByPlanIdsAbilityReqBO = new PlanQueryByPlanIdsAbilityReqBO();
            planQueryByPlanIdsAbilityReqBO.setPlanIds(planIds);
            PlanQueryByPlanIdsAbilityRspBO planQueryByPlanIdsAbilityRspBO = this.planQueryByPlanIdsAbilityService.qry(planQueryByPlanIdsAbilityReqBO);
            if ("0000".equals(planQueryByPlanIdsAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)planQueryByPlanIdsAbilityRspBO.getRows())) {
                Map<String, CcePlanDiversionBO> planIdMap = planQueryByPlanIdsAbilityRspBO.getRows().stream().collect(Collectors.toMap(CcePlanDiversionBO::getPlanId, CcePlanDiversionBO2 -> CcePlanDiversionBO2));
                contractInfoItemTmpPOS.forEach(e -> {
                    if (planIdMap.containsKey(e.getPlanItemId())) {
                        e.setUserCompanyName(((CcePlanDiversionBO)planIdMap.get(e.getPlanItemId())).getUseDepartment());
                        e.setScheduleNo(((CcePlanDiversionBO)planIdMap.get(e.getPlanItemId())).getScheduleNo());
                    }
                });
            }
        }
    }

    private void getCatelogInfo(List<ContractInfoItemPO> contractInfoItemTmpPOS) {
        if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
            Set collect = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialCode())).map(ContractInfoItemPO::getMaterialCode).collect(Collectors.toSet());
            ArrayList materialCodes = new ArrayList();
            materialCodes.addAll(collect);
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
                uccThematerialsearchAbilityReqBO.setMaterialCodes(materialCodes);
                uccThematerialsearchAbilityReqBO.setPageNo(1);
                uccThematerialsearchAbilityReqBO.setPageSize(materialCodes.size());
                UccThematerialsearchAbilityRspBO uccThematerialsearchAbilityRspBO = this.uccThematerialsearchAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
                if ("0000".equals(uccThematerialsearchAbilityRspBO.getRespCode())) {
                    List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccThematerialsearchAbilityRspBO.getRows()), UccEMdmMaterialBO.class);
                    if (!CollectionUtils.isEmpty((Collection)rows)) {
                        Map<String, List<UccEMdmMaterialBO>> materialCodeMap = rows.stream().collect(Collectors.groupingBy(UccEMdmMaterialBO::getMaterialCode));
                        ArrayList notExist = new ArrayList();
                        contractInfoItemTmpPOS.forEach(e -> {
                            if (materialCodeMap.containsKey(e.getMaterialCode())) {
                                UccEMdmMaterialBO uccEMdmMaterialBO = (UccEMdmMaterialBO)((List)materialCodeMap.get(e.getMaterialCode())).get(0);
                                e.setCatalogId(uccEMdmMaterialBO.getCatalogId().toString());
                                e.setCatalogCode(uccEMdmMaterialBO.getCatalogCode());
                                e.setCatalogName(uccEMdmMaterialBO.getCatalogName());
                                e.setMaterialName(uccEMdmMaterialBO.getMaterialName());
                            } else {
                                notExist.add(e.getMaterialCode());
                            }
                        });
                        if (!CollectionUtils.isEmpty(notExist)) {
                            throw new ZTBusinessException("\u7269\u8d44\u3010" + notExist + "\u3011\u5728\u6613\u8d2d\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u540c\u4e3b\u6570\u636e\u7cfb\u7edf\u5904\u7406");
                        }
                    } else {
                        throw new ZTBusinessException("\u7269\u8d44\u3010" + materialCodes + "\u3011\u5728\u6613\u8d2d\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u540c\u4e3b\u6570\u636e\u7cfb\u7edf\u5904\u7406");
                    }
                }
            }
        }
    }

    private void checkReqBO(ContractHtAddAbilityReqBO reqBO) {
        if (reqBO.getInfoBO() == null) {
            throw new ZTBusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractHtAddInfoAbilityBO infoBO = reqBO.getInfoBO();
        if (StringUtils.isEmpty((Object)infoBO.getOutContractId())) {
            throw new ZTBusinessException("\u5408\u540c\u7cfb\u7edf\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)infoBO.getOutContractUuId())) {
            throw new ZTBusinessException("\u5408\u540c\u7cfb\u7edfUUID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (infoBO.getContractType() == null) {
            throw new ZTBusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)infoBO.getBuynerErpNo())) {
            throw new ZTBusinessException("\u4e70\u53d7\u4ebaerp\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)infoBO.getSupplierCode())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u7f16\u7801\uff08erp\u7f16\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)infoBO.getCreateUserCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u4eba\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getItemBOS())) {
            HashSet<String> outItemIdSet = new HashSet<String>();
            Integer isJy = 0;
            for (ContractHtAddInfoItemAbilityBO e2 : reqBO.getItemBOS()) {
                if (StringUtils.isEmpty((Object)e2.getMaterialCode())) {
                    throw new ZTBusinessException("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)e2.getOutItemId())) {
                    throw new ZTBusinessException("\u5408\u540c\u7cfb\u7edf\u660e\u7ec6\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (e2.getSchemeType() != null && this.simpleSchemeType.equals(e2.getSchemeType())) {
                    isJy = 1;
                }
                outItemIdSet.add(e2.getOutItemId());
            }
            if (outItemIdSet.size() != reqBO.getItemBOS().size()) {
                throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u884cid\u4e0d\u80fd\u91cd\u590d");
            }
            reqBO.getInfoBO().setIsJy(isJy);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            reqBO.getAccessoryList().forEach(e -> {
                if (StringUtils.isEmpty((Object)e.getAcceessoryName())) {
                    throw new ZTBusinessException("\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)e.getAcceessoryUrl())) {
                    throw new ZTBusinessException("\u9644\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (e.getRelateType() == null) {
                    throw new ZTBusinessException("\u9644\u4ef6\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExpressBOS())) {
            reqBO.getExpressBOS().forEach(e -> {
                if (e.getExpressId() == null) {
                    throw new ZTBusinessException("\u516c\u5f0fID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderInfoBOS())) {
            reqBO.getOrderInfoBOS().forEach(e -> {
                if (e.getOrderId() == null) {
                    throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
    }
}

