/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.ability.ContractItemChangeQueryAbilityService;
import com.tydic.contract.ability.ContractItemQueryAbilityService;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.ContractItemChangeQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemChangeQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemPdfAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityRspBO;
import com.tydic.contract.busi.ContractItemPdfCreateBusiService;
import com.tydic.contract.busi.bo.ContractDetailInfoBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.contract.utils.PdfUtil;
import com.tydic.contract.utils.PdfUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class ContractItemPdfCreateBusiServiceImpl
implements ContractItemPdfCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemPdfCreateBusiServiceImpl.class);
    @Autowired
    private ContractItemQueryAbilityService contractItemQueryAbilityService;
    @Autowired
    ContractItemChangeQueryAbilityService contractItemChangeQueryAbilityService;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "contract/pdf";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @Override
    public ContractItemPdfAbilityRspBO pdfCreate(ContractItemQueryAbilityReqBO reqBO) {
        BaseFont baseFont;
        reqBO.setPageNo(Integer.valueOf(0));
        reqBO.setPageSize(Integer.valueOf(0));
        ContractItemPdfAbilityRspBO rspBO = new ContractItemPdfAbilityRspBO();
        Integer type = 1;
        ContractDetailInfoBO contractDetailInfoBO = new ContractDetailInfoBO();
        List contractItemAbilityBOS = new ArrayList();
        if (!StringUtils.isEmpty((Object)reqBO.getContractId())) {
            ContractDetailInfoBO infoEq = new ContractDetailInfoBO();
            infoEq.setContractId(reqBO.getContractId());
            contractDetailInfoBO = this.contractInfoMapper.selectContractDetailInfo(infoEq);
            ContractItemQueryAbilityRspBO contractItemQueryAbilityRspBO = this.contractItemQueryAbilityService.contractItemQuery(reqBO);
            contractItemAbilityBOS = contractItemQueryAbilityRspBO.getRows();
            if (null != contractDetailInfoBO.getMultiDealerId()) {
                type = 2;
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUpdateApplyId())) {
            ContractInfoChangePO contractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
            BeanUtils.copyProperties((Object)contractInfoChangePO, (Object)contractDetailInfoBO);
            ContractItemChangeQueryAbilityReqBO contractItemChangeQueryAbilityReqBO = new ContractItemChangeQueryAbilityReqBO();
            contractItemChangeQueryAbilityReqBO.setUpdateApplyId(reqBO.getUpdateApplyId());
            contractItemChangeQueryAbilityReqBO.setPageNo(Integer.valueOf(0));
            contractItemChangeQueryAbilityReqBO.setPageSize(Integer.valueOf(0));
            ContractItemChangeQueryAbilityRspBO contractItemChangeQueryAbilityRspBO = this.contractItemChangeQueryAbilityService.contractItemChangeQuery(contractItemChangeQueryAbilityReqBO);
            List contractItemChangeAbilityBOS = contractItemChangeQueryAbilityRspBO.getRows();
            if (!CollectionUtils.isEmpty((Collection)contractItemChangeAbilityBOS)) {
                contractItemAbilityBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)contractItemChangeAbilityBOS)).toJavaList(ContractItemAbilityBO.class);
            }
            if (null != contractInfoChangePO.getMultiDealerId()) {
                type = 2;
            }
        }
        Document document = new Document(PageSize.A3, -10.0f, 0.0f, 40.0f, 60.0f);
        PdfWriter pdfWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        Font contentFontBold = new Font(baseFont, 9.0f, 0);
        BigDecimal totalTaxAmount = new BigDecimal(BigInteger.ZERO);
        BigDecimal notTotalTaxAmount = new BigDecimal(BigInteger.ZERO);
        BigDecimal totalTax = new BigDecimal(BigInteger.ZERO);
        this.fieldHeader(contractDetailInfoBO, titleTable, tableList, contentFontBold, baseFont, type);
        if (!CollectionUtils.isEmpty(contractItemAbilityBOS)) {
            for (int i = 0; i < contractItemAbilityBOS.size(); ++i) {
                totalTaxAmount = totalTaxAmount.add(((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getTaxAmount());
                notTotalTaxAmount = notTotalTaxAmount.add(((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getNotIncludingTaxAmount());
                totalTax = totalTax.add(((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getTax());
                PdfPTable pdfPTable2 = new PdfPTable(17);
                PdfUtils.addCellToTable(pdfPTable2, i + 1, contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getMaterialCode(), contentFontBold, 0, 5, null, 2, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getMaterialDesc(), contentFontBold, 0, 5, null, 3, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getUnitName(), contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, Convert.toInt((Object)((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getAmount()), contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, StringUtils.isEmpty((Object)((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getRate()) ? Integer.valueOf(0) : ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getRate() + "%", contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getUnitPriceExcludingTax().stripTrailingZeros().toPlainString(), contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getTaxUnitPrice().stripTrailingZeros().toPlainString(), contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getNotIncludingTaxAmount().stripTrailingZeros().toPlainString(), contentFontBold, 0, 5, null, 1, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getTaxAmount().stripTrailingZeros().toPlainString(), contentFontBold, 0, 5, null, 2, null);
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getBrandOrigin(), contentFontBold, 0, 5, null, 1, null);
                if (ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractDetailInfoBO.getContractType()) || ContractConstant.ContractType.SPOT_CONTRACT.equals(contractDetailInfoBO.getContractType()) || ContractConstant.ContractType.DEVELOPMENT_CONTRACT.equals(contractDetailInfoBO.getContractType()) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractDetailInfoBO.getContractType())) {
                    PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getNeedArriveTime(), contentFontBold, 0, 5, null, 1, null);
                } else {
                    PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getDeliveryDateDesc(), contentFontBold, 0, 5, null, 1, null);
                }
                PdfUtils.addCellToTable(pdfPTable2, ((ContractItemAbilityBO)contractItemAbilityBOS.get(i)).getRemark(), contentFontBold, 0, 5, null, 1, null);
                tableList.add(pdfPTable2);
            }
        }
        this.fieldTail(tableList, contentFontBold, totalTaxAmount, notTotalTaxAmount, totalTax, type);
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        pdfWriter.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u5408\u540c\u660e\u7ec6PDF\u9644\u8868" + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        String exportUrl = null;
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        System.out.println("------------------");
        rspBO.setUrl(exportUrl);
        rspBO.setName(fileName);
        return rspBO;
    }

    @Override
    public String watermarkGenerate(String url, String text) {
        if (!StringUtils.isEmpty((Object)url) && url.endsWith(".pdf") && ObjectUtil.isNotEmpty((Object)text)) {
            return this.WatermarkGeneration(url, text);
        }
        log.error("pdf\u660e\u7ec6\u5165\u53c2url\u4e3a\u7a7a");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String WatermarkGeneration(String srcFileUrl, String text) {
        String exportUrl;
        block16: {
            exportUrl = "";
            String fileNamePrefix = "textWaterMark-";
            String srcFileName = fileNamePrefix + Sequence.getInstance().nextId() + ".pdf";
            String destFileName = fileNamePrefix + Sequence.getInstance().nextId() + ".pdf";
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + srcFileName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(srcFileUrl, file.getAbsolutePath());
            String srcFile = System.getProperty("user.dir") + "/temporaryfile/" + srcFileName;
            String destFile = System.getProperty("user.dir") + "/temporaryfile/" + destFileName;
            boolean addTextWaterMarkFlag = this.addContractItemTextWaterMark(srcFile, destFile, text);
            if (addTextWaterMarkFlag) {
                FileInputStream fileInput = null;
                try {
                    fileInput = new FileInputStream(destFile);
                    HttpUtil.deleteFile("temporaryfile/" + srcFileName);
                    HttpUtil.deleteFile("temporaryfile/" + destFileName);
                    String fileName = Sequence.getInstance().nextId() + ".pdf";
                    String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)fileInput);
                    if (FILE_TYPE_OSS.equals(this.fileType)) {
                        exportUrl = this.ossFileUrl + path;
                        break block16;
                    }
                    if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                        FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                        exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                        break block16;
                    }
                    throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
                }
                catch (Exception e) {
                    log.error("PDF\u6587\u4ef6\u6dfb\u52a0\u6587\u5b57\u6c34\u5370|\u4e0a\u4f20\u6587\u5b57\u6c34\u5370\u6587\u4ef6\u5f02\u5e38|\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)e.getMessage());
                }
                finally {
                    if (fileInput != null) {
                        try {
                            fileInput.close();
                        }
                        catch (IOException e) {
                            log.error("PDF\u6587\u4ef6\u6dfb\u52a0\u6587\u5b57\u6c34\u5370|\u4e0a\u4f20\u6587\u5b57\u6c34\u5370\u6587\u4ef6\u5f02\u5e38|\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)e.getMessage());
                        }
                    }
                }
            }
        }
        return exportUrl;
    }

    public boolean addContractItemTextWaterMark(String srcFile, String destFile, String text) {
        try {
            PdfReader reader = new PdfReader(srcFile);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(destFile));
            int total = reader.getNumberOfPages() + 1;
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(1.0f);
            BaseFont base = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
            for (int i = 1; i < total; ++i) {
                PdfContentByte content = stamper.getOverContent(i);
                content.setGState(gs);
                content.setFontAndSize(base, 11.0f);
                content.beginText();
                content.setColorFill(BaseColor.BLACK);
                content.showTextAligned(0, text, 690.0f, 1165.0f, 0.0f);
                content.endText();
            }
            stamper.close();
            reader.close();
            return true;
        }
        catch (Exception e) {
            log.error("PDF\u6587\u4ef6\u6dfb\u52a0\u6587\u5b57\u6c34\u5370|\u6dfb\u52a0\u6587\u672c\u6c34\u5370\u5f02\u5e38|\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    private void fieldHeader(ContractDetailInfoBO contractDetailInfoBO, PdfPTable titleTable, List<PdfPTable> tableList, Font contentFontBold, BaseFont baseFont, Integer type) {
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font fieldTable = new Font(baseFont, 9.0f, 1);
        if (type == 1) {
            PdfUtil.addCellToTable(titleTable, "\u5408\u540c\u660e\u7ec6\u9644\u8868\uff08\u4e24\u65b9\uff09", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
            tableList.add(titleTable);
            PdfPTable htmc = new PdfPTable(3);
            PdfUtils.addCellToTable(htmc, "\u5408\u540c\u540d\u79f0\uff1a" + contractDetailInfoBO.getContractName(), contentFontBold, 0, 5, null, 1, 0);
            PdfUtils.addCellToTable(htmc, "\u4e70\u53d7\u4eba\uff1a" + contractDetailInfoBO.getBuyerName(), contentFontBold, 0, 5, null, 1, 0);
            PdfUtils.addCellToTable(htmc, "\u4f9b\u5e94\u5546\uff1a" + contractDetailInfoBO.getSupplierName(), contentFontBold, 0, 5, null, 1, 0);
            tableList.add(htmc);
        } else {
            PdfUtil.addCellToTable(titleTable, "\u5408\u540c\u660e\u7ec6\u9644\u8868\uff08\u4e09\u65b9\uff09", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
            tableList.add(titleTable);
            PdfPTable sfht = new PdfPTable(1);
            PdfUtils.addCellToTable(sfht, "\u5408\u540c\u540d\u79f0\uff1a" + contractDetailInfoBO.getContractName(), contentFontBold, 0, 5, null, 1, 0);
            tableList.add(sfht);
            PdfPTable sfhtTow = new PdfPTable(3);
            PdfUtils.addCellToTable(sfhtTow, "\u7532\u65b9\uff1a" + contractDetailInfoBO.getBuyerName(), contentFontBold, 0, 5, null, 1, 0);
            PdfUtils.addCellToTable(sfhtTow, "\u4e59\u65b9\uff1a" + contractDetailInfoBO.getSupplierName(), contentFontBold, 0, 5, null, 1, 0);
            PdfUtils.addCellToTable(sfhtTow, "\u4e19\u65b9\uff1a" + contractDetailInfoBO.getMultiDealerName(), contentFontBold, 0, 5, null, 1, 0);
            tableList.add(sfhtTow);
        }
        PdfPTable pdfPTable1 = new PdfPTable(17);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable(pdfPTable1, "\u5e8f\u53f7", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u7269\u8d44\u7f16\u7801", fieldTable, 1, 5, null, 2, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u7269\u8d44\u63cf\u8ff0", fieldTable, 1, 5, null, 3, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u8ba1\u91cf\u5355\u4f4d", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u6570\u91cf", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u7a0e\u7387", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u4e0d\u542b\u7a0e\u5355\u4ef7", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u542b\u7a0e\u5355\u4ef7", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u4e0d\u542b\u7a0e\u91d1\u989d", fieldTable, 1, 5, null, 1, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u542b\u7a0e\u91d1\u989d", fieldTable, 1, 5, null, 2, null);
        PdfUtils.addCellToTable(pdfPTable1, "\u4ea7\u5730\u54c1\u724c", fieldTable, 1, 5, null, 1, null);
        if (ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractDetailInfoBO.getContractType()) || ContractConstant.ContractType.SPOT_CONTRACT.equals(contractDetailInfoBO.getContractType()) || ContractConstant.ContractType.DEVELOPMENT_CONTRACT.equals(contractDetailInfoBO.getContractType()) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractDetailInfoBO.getContractType())) {
            PdfUtils.addCellToTable(pdfPTable1, "\u4ea4\u8d27\u65e5\u671f", fieldTable, 0, 5, null, 1, null);
        } else {
            PdfUtils.addCellToTable(pdfPTable1, "\u4ea4\u8d27\u671f\u8bf4\u660e", fieldTable, 1, 5, null, 1, null);
        }
        PdfUtils.addCellToTable(pdfPTable1, "\u5907\u6ce8", fieldTable, 1, 5, null, 1, null);
    }

    private void fieldTail(List<PdfPTable> tableList, Font contentFontBold, BigDecimal totalTaxAmount, BigDecimal notTotalTaxAmount, BigDecimal totalTax, Integer type) {
        PdfPTable hsje = new PdfPTable(3);
        PdfUtils.addCellToTable(hsje, "   ", contentFontBold, 0, 5, null, 1, 0);
        PdfUtils.addCellToTable(hsje, "\u542b\u7a0e\u91d1\u989d\uff1a" + totalTaxAmount, contentFontBold, 0, 5, null, 1, 0);
        PdfUtils.addCellToTable(hsje, "\u5927\u5199\uff1a" + Convert.digitToChinese((Number)totalTaxAmount), contentFontBold, 0, 5, null, 1, 0);
        tableList.add(hsje);
        PdfPTable bhsje = new PdfPTable(3);
        PdfUtils.addCellToTable(bhsje, "\u5408\u8ba1\uff1a", contentFontBold, 0, 5, null, 1, 0);
        PdfUtils.addCellToTable(bhsje, "\u4e0d\u542b\u7a0e\u91d1\u989d\uff1a" + notTotalTaxAmount, contentFontBold, 0, 5, null, 1, 0);
        PdfUtils.addCellToTable(bhsje, "\u5927\u5199\uff1a" + Convert.digitToChinese((Number)notTotalTaxAmount), contentFontBold, 0, 5, null, 1, 0);
        tableList.add(bhsje);
        PdfPTable se = new PdfPTable(3);
        PdfUtils.addCellToTable(se, "  ", contentFontBold, 0, 5, null, 1, 0);
        PdfUtils.addCellToTable(se, "\u7a0e\u989d\uff1a" + totalTax, contentFontBold, 0, 5, null, 1, 0);
        PdfUtils.addCellToTable(se, "\u5927\u5199\uff1a" + Convert.digitToChinese((Number)totalTax), contentFontBold, 0, 5, null, 1, 0);
        tableList.add(se);
        if (type == 1) {
            PdfPTable jf = new PdfPTable(2);
            PdfUtils.addCellToTable(jf, "\u7532\u65b9\uff08\u76d6\u7ae0\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            PdfUtils.addCellToTable(jf, "\u4e59\u65b9\uff08\u76d6\u7ae0\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(jf);
            PdfPTable fddb = new PdfPTable(2);
            PdfUtils.addCellToTable(fddb, "\u6cd5\u5b9a\u4ee3\u8868\u4eba/\u59d4\u6258\u4ee3\u7406\u4eba\uff08\u7532\u65b9\u7b7e\u540d\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            PdfUtils.addCellToTable(fddb, "\u6cd5\u5b9a\u4ee3\u8868\u4eba/\u59d4\u6258\u4ee3\u7406\u4eba\uff08\u4e59\u65b9\u7b7e\u540d\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(fddb);
        } else {
            PdfPTable jf = new PdfPTable(1);
            PdfUtils.addCellToTable(jf, "\u7532\u65b9\uff08\u76d6\u7ae0\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(jf);
            PdfPTable jfq = new PdfPTable(1);
            PdfUtils.addCellToTable(jfq, "\u6cd5\u5b9a\u4ee3\u8868\u4eba/\u59d4\u6258\u4ee3\u7406\u4eba\uff08\u7532\u65b9\u7b7e\u540d\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(jfq);
            PdfPTable yf = new PdfPTable(1);
            PdfUtils.addCellToTable(yf, "\u4e59\u65b9\uff08\u76d6\u7ae0\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(yf);
            PdfPTable yfq = new PdfPTable(1);
            PdfUtils.addCellToTable(yfq, "\u6cd5\u5b9a\u4ee3\u8868\u4eba/\u59d4\u6258\u4ee3\u7406\u4eba\uff08\u4e59\u65b9\u7b7e\u540d\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(yfq);
            PdfPTable bf = new PdfPTable(1);
            PdfUtils.addCellToTable(bf, "\u4e19\u65b9\uff08\u76d6\u7ae0\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(bf);
            PdfPTable bfq = new PdfPTable(1);
            PdfUtils.addCellToTable(bfq, "\u6cd5\u5b9a\u4ee3\u8868\u4eba/\u59d4\u6258\u4ee3\u7406\u4eba\uff08\u4e19\u65b9\u7b7e\u540d\uff09\uff1a", contentFontBold, 0, 5, null, 1, 0);
            tableList.add(bfq);
        }
    }
}

